/*
 * Comms.h
 *
 *  Created on: Mar 13, 2013
 *      Author: B34981
 */

#ifndef COMMS_H_
#define COMMS_H_

/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "derivative.h"

/**********************************************************************************************
* Constants
**********************************************************************************************/


/**********************************************************************************************
* Macros
**********************************************************************************************/

                
/**********************************************************************************************
* Types
**********************************************************************************************/


/**********************************************************************************************
* Variables
**********************************************************************************************/


/**********************************************************************************************
* Global Variables
**********************************************************************************************/


/**********************************************************************************************
* Global Functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver
* @param    none
* @return   none
*
************************************************************************************************/
void Comms_Init(void);

/***********************************************************************************************
*
* @brief    Comms_Tx_Ack - Reply to received Boot Phrases depending on checksum results
* @param    ACK_OPTS ack: OK or CRC_ERROR
* @return   none
*
************************************************************************************************/  	
void Comms_Tx_Ack(enum ACK_OPTS ack);

/***********************************************************************************************
*
* @brief    Comms_Rx_Data - Poll or Interrupt that receives serial data.
* @param    none
* @return   none (Data must fill the BP structure, when BP is fill, update u8BootPhraseRcvd)
*
************************************************************************************************/ 
void Comms_Rx_Data(void);

/***********************************************************************************************
*
* @brief    Comms_Reset_Reg - Reset the modified registers to its defaut values
* @param    none
* @return   none
*
************************************************************************************************/  	
void Comms_Reset_Reg(void);

#endif /* COMMS_H_ */
