/*
 * main.h
 *
 *  Created on: Mar 14, 2013
 *      Author: B34981
 */

#ifndef MAIN_H_
#define MAIN_H_

/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "derivative.h"


/**********************************************************************************************
* Constants
**********************************************************************************************/


/**********************************************************************************************
* User Modifiable Macros
**********************************************************************************************/
/* Oscillator frequency for the PLL configuration, clock is always scaled to 32 MHz */
#define OSCILLATOR_FREQUENCY 4			/* In MHz 4, 8, 12 or 16 MHz only */

/* Time to wait after POR, when timeout is met, jump to application code */
#define TIMEOUT 10						/* Timeout in 100 ms increments: 10 is a second */

/* Macros to ERASE flash */
#define FLASH_START_ADD 0xFE0000
#define FLASH_SECTORS_TO_ERASE 252		/* 256 total - 1 interrupt vector - 3 (1.5k) for Bootloader = 252. Each sector is 512 bytes */

/* Macros that define SHADOW segments */
#define SHADOW_ROM_ADD 0xFFFC00			
#define SHADOW_RAM_ADD 0x001000			

/* GPIO Macros for visual indication */
#define ACTIVITY_LED_ENABLE 1			/* When the Activity Led is disabled, the rest related defines don't care */
#define ACTIVITY_LED_DDR DDRP_DDRP0
#define ACTIVITY_LED PTP_PTP0
#define LED_ON 1

/* File size definitions */
#define CHECK_PHRASE_CHECKSUM 0			/* If 1, check the S19 checksum before flashing */

/* Set the pointer where to jump when not in bootloader mode */
#define APPLICATION_START_ADD	0xFE0000	/* User configurable application pointer, recommend Flash start */


/**********************************************************************************************
* Macros - Do Not Modify
**********************************************************************************************/
#define FLASH_SECTOR_SIZE 512
#define FLASH_VECTOR_SECTOR_ADD 0xFFFE00	/* The last sector holds the memory protection bit and the interrupt vector */
#define SHADOW_SIZE_IN_WORDS 256			/* Shadow segment size in words 512/2 */
#define LED_OFF !LED_ON
#define BOOTLOADER_START_ADD (UINT32)((UINT32)FLASH_START_ADD + ((UINT32)FLASH_SECTORS_TO_ERASE * (UINT32)FLASH_SECTOR_SIZE))  /* Bootloader start addres, to avoid programming over the bootloader */

/**********************************************************************************************
* Types
**********************************************************************************************/
enum ACK_OPTS
{
	OK = 0x41,				/* 'A' means data was received OK */
	CRC_Error = 0x45		/* 'E' means that the prhase has an error, expect retransmission */
};

/* Boot Phrase with 37 bytes maximum according to S19 standard */
typedef union
{
	UINT8 Byte[37];				/* Byte level access to the Phrase */
	struct{
	UINT8 PhraseSize;			/* The first byte holds the phrase size (wihtout including the size on the count) */
	UINT8 PhraseAddress[3];		/* The three next bytes are the address, only for S12Z devices with 24-bit addressing */
	UINT8 PhraseData[33];		/* Maximum 32 data bytes. The last PhraseData is the CRC */
	}F;	
}BootPhraseStruct; 

/**********************************************************************************************
* Variables
**********************************************************************************************/


/**********************************************************************************************
* Global Variables
**********************************************************************************************/


/**********************************************************************************************
* Global Functions
**********************************************************************************************/

#endif /* MAIN_H_ */
