/*
 * MCU_init.c
 * 
 * 	This file contains the configuration routines for the CPMU and PIM modules
 * 		MCU_init -> Initialises the CPMU module as configured in config_me.h
 *
 *  Created on: Mar 12, 2015
 *      Author: B52932
 */

#include "derivative.h"
#include "MCU_init.h"

/* MCU_init( CPMU_freq, select )
 * Initialises the PIM module to route input capture pins 1-2-3 for the sensor hall reading to channel 1
 * and initialises the CPMU frequency with respect the following parameters
 *  CPMU_freq = 0 -> No change to CPMU module frequency is the same after reset 12.5MHz CPU and 25MHz Bus
 *  CPMU_freq = 1 -> CPMU is initialised to 25 MHz CPU and 12.5 MHz Bus
 *  CPMU_freq = 2 -> CPMU is initialised to 20 MHz CPU and 20 MHz Bus
 *  
 *  select = 0 -> Routes PWM outputs to Motor
 * 	select = 1 -> Routes PWM outputs to GPIOs
 * 	
 * */
void MCU_init(unsigned char CPMU_freq, unsigned char select){
	
	/* Init CPMU */
	switch(CPMU_freq){
		case CPU_25MHZ:
			CPMUSYNR_SYNDIV = 49;
			CPMUSYNR_VCOFRQ = 0b11;
			while(!CPMUIFLG_LOCK);
			break;
		case CPU_20MHZ:
			CPMUSYNR_SYNDIV = 39;
			CPMUSYNR_VCOFRQ = 0b01;
			while(!CPMUIFLG_LOCK);
			break;
		default:
			break;
	}
	
	/* Init PIM */
	if(select){
		MODRR1 = 0b1111; /* PWM on external pins
		 	 	 	 	    PWM0 -> PP0 PWM1 -> PP1
		 	 	 	 	    PWM2 -> PP2 PWM3 -> PT0
		 	 	 	 	    PWM4 -> PT1 PWM5 -> PT2
		 	 	 	 	    */
		  DDRP_DDRP0 = 1; /* Enable P0 as output*/
		  DDRP_DDRP1 = 1; /* Enable P1 as output*/
		  DDRP_DDRP2 = 1; /* Enable P2 as output*/
		  DDRT_DDRT0 = 1; /* Enable T0 as output*/
		  DDRT_DDRT1 = 1; /* Enable T1 as output*/
		  DDRT_DDRT2 = 1; /* Enable T2 as output*/
	} else{
		MODRR2_T0IC1RR = 1; /* Input Capture channel 1 connected to PT3-1 */
		DDRT = 0x00;		  /* Configure port T as inputs */
		PERT = 0x0E;		  /* Enable port T pull-ups */
		DDRE = 0x00;		  /* Configure port E as inputs */
		DDRP_DDRP0 = 1;	  	  /* Enable EVDD */
		PTP_PTP0 = 1;		  /* Turn on EVDD */
	}
	
}
