/*
 * MCU_init.h
 *
 *  Created on: Mar 12, 2015
 *      Author: B52932
 */

#ifndef MCU_INIT_H_
#define MCU_INIT_H_

#define CPU_12_5MHZ  0
#define CPU_25MHZ 1
#define CPU_20MHZ  2

#define PWM_MOTOR 0
#define PWM_GPIO  1

/* Timer initialisation */
#define init_TIM1_motor    TIM0TIOS_IOS1 = 0; /* Configure channel 1 as input compare */ \
						   TIM0TCTL4 |= TIM0TCTL4_EDG1B_MASK | TIM0TCTL4_EDG1A_MASK; /* Capture on any edge */\
						   TIM0TIE_C1I = 1; /* Enable interrupt on channel 1 */\
						   TIM0TSCR1_TEN = 1; /* Enable Timer*/

#define init_TIM1_gpio	   TIM0TIOS_IOS1 = 1; /* Configure channel 1 as output compare */ \
						   TIM0TC1 = 25000; /* Commute every 1ms */\
						   TIM0TIE_C1I = 1; /* Enable interrupt on channel 1 */\
						   TIM0TSCR1_TEN = 1; /* Enable Timer*/

#define ENCE	TIM0TIOS_IOS0 = 1; /* Configure channel 0 as output compare */ \
				TIM0TCTL2_OL0 = 0; /* TIM ch0 output toggle on Output compare */\
				TIM0TCTL2_OM0 = 0;\
				TIM0OCPD_OCPD0 = 0; /* Disconnect Output Compare 0 */

/* Prototypes */
void MCU_init(unsigned char CPMU_freq, unsigned char select);

#endif /* MCU_INIT_H_ */
