/*
 * PMF.c
 *
 *  Created on: Mar 12, 2015
 *      Author: B52932
 */

#include "PMF.h"
#include "derivative.h"


void init_PMF(int pwm_modulo, int dutycycle)
{
	
	PMFCFG0 |= PMFCFG0_EDGEA_MASK | PMFCFG0_EDGEB_MASK | PMFCFG0_EDGEC_MASK ; /* Edge aligned PWM mode */
	PMFCFG2_REV = 1;	/* PWM generator A generates reload event */
	
	PMFCFG3_VLMODE = 0x01;	/* Writing to value register zero also writes to value registers one to five */
	PMFFQCA_LDFQA = 0;	/* Reload every PWM cycle */
	PMFFQCA_PRSCA = 0;	/* PWM clock = Core frequency */
	
	PMFMODA = pwm_modulo;	/* Set PWM frequency */
	PMFVAL0 = dutycycle;	/* Set DC */
	
	
#if PMF_MODE == COMPLEMENTARY_UNIPOLAR_LS_FIX || PMF_MODE == PMF_OUTC_ONLY
	PMFDTMA = PWM_DEADTIME;	/* Load dead time for dead time generator A */
	PMFCFG0_INDEPx = 0; /* Complementary PWMs */
	PMFOUTB = 0x2A;		/* Low MOSFETs ON while SW control */
#elif PMF_MODE == COMPLEMENTARY_BIPOLAR
	PMFCFG0_INDEPx = 0; /* Complementary PWMs */
	PMFDTMA = PWM_DEADTIME;	/* Load dead time for dead time generator A */
#elif PMF_MODE == INDEPENDENT_LS_FIX  
	PMFCFG0 |= PMFCFG0_INDEPA_MASK | PMFCFG0_INDEPB_MASK |PMFCFG0_INDEPC_MASK; /* Independent PWMs */
	PMFOUTB = 0x2A;		/* Low MOSFETs ON while SW control */
#elif PMF_MODE == COMPLEMENTARY_UNIPOLAR_HS_FIX
	PMFDTMA = PWM_DEADTIME;	/* Load dead time for dead time generator A */
	PMFCFG0_INDEPx = 0; /* Complementary PWMs */
	PMFOUTB = 0x15;		/* High MOSFETs ON while SW control */
#elif PMF_MODE == INDEPENDENT_HS_FIX
	PMFCFG0 |= PMFCFG0_INDEPA_MASK | PMFCFG0_INDEPB_MASK |PMFCFG0_INDEPC_MASK; /* Independent PWMs */
	PMFOUTB = 0x15;		/* High MOSFETs ON while SW control */
#endif

	PMFCFG2_MSK = PMFCFG2_MSK_MASK; /* Mask all PWM outputs (DC = 0)*/
	PMFENCA_LDOKA = 1;	/* PMF external global load OK signal, reloads double buffered registers */	 
	PMFENCA_PWMRIEA = 1;	/* Reload Interrupt enabled */	
	PMFENCA_PWMENA = 1;	/* PWM generator A outputs enabled */
	PMFENCA_RSTRTA = 1; /* PWM restart at commutation event */
	
#if PMF_MODE != COMPLEMENTARY_BIPOLAR
	PMFCFG1_ENCE = 1;	/* Buffered PMFOUTC, PMFOUTB, SWAPx and MSKx change on commutation event */
	PMFENCA_GLDOKA = 1;	/* External Load OK controls buffered registers */ 
#endif
	
}

void init_GDU(void)
{
	
	GDUE_GCPE = 1;		/* Enable charge pump */
	GDUF = 0xFF;		/* Clear High & Low voltage Supply flags */
	GDUCLK2_GCPCD = 2; 	/* Set GDU charge pump clock divider to fbus / 32 */
	GDUCTR = 0x09;		/* Blanking time 14/12.5M = 1.1us, HD 0V threshold = 20V */
	GDUDSLVL = 0X77;	/* Desaturation level (1.35 V) */
	GDUE_GFDE = 1;		/* Enable FET pre-driver */
	GDUDSE = 0X77;		/* Clear desaturation error flags */
}
