/*
 * config_me.h
 *
 *  Created on: Mar 12, 2015
 *      Author: Manuel Rodriguez
 */

#ifndef CONFIG_ME_H_
#define CONFIG_ME_H_

/* GPIOs definitions */
#define HALL  ((PTIT_PTIT & 0b1110) >> 1) 	/* Hall sensor input */
#define SW2   PTE_PTE1					  	/* port PE1 = SW2 input */
#define SW3   PTE_PTE0						/* port PE0 = SW3 input */

/* Working modes */
#define INDEPENDENT_LS_FIX 		   			0
#define INDEPENDENT_HS_FIX   	   			1
#define PMF_OUTC_ONLY			   			3
#define COMPLEMENTARY_UNIPOLAR_LS_FIX	  	4
#define COMPLEMENTARY_UNIPOLAR_HS_FIX	  	5 /* Increase DC to work with motor */
#define COMPLEMENTARY_BIPOLAR	  			6 /* Increase Deadtime to work with motor */

/* Routing options */
#define GPIO					   0
#define MOTOR					   1

/* Rotation direction */
#define ClockWise				   0
#define CounterClockWise		   1

/* Parameters */
#define PWM_MODULO		  625		/* Set PWM to 20KHz Fcore/Fpwm -> 12.5MHz/20KHz = 625 */
#define DC 				  125		/* Set Duty cycle of 20% DC = (20 * pwm_modulo) / 100 */
#define PWM_DEADTIME 	  50		/* Dependent of switching characteristics of the mosfets (Turn-off delay + Turn-off fall)*/
									/* For the NVD4804 Turn-off delay time = 24ns, Fall time = 8ns */
									/* Any value higher than 32ns */
/* Configuration */
#define PMF_MODE INDEPENDENT_LS_FIX 	 /* Selects one of the working modes (INDEPENDENT, COMPLEMENTARY_BIPOLAR, COMPLEMENTARY_UNIPOLAR)*/
#define ROUTE 	 MOTOR			 		 /* Selects the routing of the PWM signals to MOTOR or GPIO */
#define rotdir	 CounterClockWise		 /* Selects Motor rotation ClockWise or CounterClockWise */

#endif /* CONFIG_ME_H_ */
