/*******************************************************************************
* NXP Semiconductors
* (c) Copyright 2016 NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without any 
warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be held
liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. 
IN NO EVENT SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THIS AGREEMENT. 
CUSTOMER agrees to hold NXP harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             main.c
* Owner             Lukas Zadrapa
* Version           1.0
* Date              Apr-20-2016
* Classification:   General Business Information
* Brief:            INTC initialization code
********************************************************************************
Revision History:
Ver  Date         Author            Description of Changes
1.0  Apr-20-2016  Lukas Zadrapa     Initial version
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "MPC5748G_310.h"

/*******************************************************************************
* Constants and macros
*******************************************************************************/

/*******************************************************************************
* External objects
*******************************************************************************/
extern const uint32_t IntcIsrVectorTable[];

/*******************************************************************************
* Global variables
*******************************************************************************/

/*******************************************************************************
* Local functions
*******************************************************************************/

/*******************************************************************************
* Global functions
*******************************************************************************/

/*******************************************************************************
Function Name : IVPR_Init
Engineer      : Lukas Zadrapa
Date          : Apr-20-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Initialization of IVPR register. __IVPR is defined in linker
                file as a beginning of .xptn_vectors section
Issues        : NONE
*******************************************************************************/
asm void IVPR_Init(void)
{
  e_lis r3, __IVPR@h
  e_or2i r3, __IVPR@l
  mtivpr r3
}

/*******************************************************************************
Function Name : INTC_Init
Engineer      : Lukas Zadrapa
Date          : Apr-20-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : INTC_Init function
Issues        : NONE
*******************************************************************************/
void INTC_Init(void)
{ 
  /* The Block Configuration Register is used to configure options of the INTC. 
     Initialize INTC for software vector mode */
  INTC.BCR.R = 0x00000000;       

  /* configure IVPR register */
  IVPR_Init();

  /* Set INTC ISR vector table base address */
  INTC.IACKR[0].R = (uint32_t) &IntcIsrVectorTable[0]; 

  /* Set lowest priority to enable interrupts */
  INTC.CPR[0].B.PRI = 0;

  /* Enable interrupts */
  asm(" wrteei 1");
}//INTC_Init
