/*******************************************************************************
* NXP Semiconductors
* (c) Copyright 2016 NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without any 
warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be held
liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. 
IN NO EVENT SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THIS AGREEMENT. 
CUSTOMER agrees to hold NXP harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             MPC5748G_IsrVecTab.c
* Owner:            Lukas Zadrapa
* Version:          1.0
* Date:             Apr-20-2016
* Classification:   General Business Information
* Brief:            ISR routines for INTC in HW or SW vector mode
********************************************************************************
********************************************************************************
* Detailed Description:
* ISR routines for MPC5748G
* 
********************************************************************************
Revision History:
Ver  Date         Author            Description of Changes
1.0  Apr-20-2016  Lukas Zadrapa     Initial version
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "INTC_Init.h"

/*******************************************************************************
* Local functions
*******************************************************************************/
void NonHandledINTCException();

/*******************************************************************************
* Global variables
*******************************************************************************/
extern void LINFlexD_2_RX_ISR(void);
extern void LINFlexD_2_TX_ISR(void);


// ****************************************************************************
//in case you are using SW interrupts and VLE is enabled use this
#pragma asm
  .macro ISRline value
  .long  value
  .endm    
#pragma endasm

//In case you are using HW use this 
//#pragma asm
//    .macro ISRline value
//    e_b  value
//	nop
//	nop
//	nop
//    .endm
//#pragma endasm

// ****************************************************************************
// ************************ Internal Constants and Variables ******************
// ****************************************************************************
/* Use next line with Green Hills compile */
#pragma ghs section rodata=".isrvectab"

// This table contains all ISR routines called when a peripheral interrupt occurs.
// The table is used only when INTC is configured to work in "SW vector mode"

#pragma asm
   
  .section  ".isrvectab", "vax"
  .vle

    
  .global IntcIsrVectorTable
IntcIsrVectorTable:

  ; #IRQ 000                               ;*** Source of interrupt: SOFTWARE ***   
  ISRline NonHandledINTCException          ;Vec 000, INTC SW settable Clear Flag 0 
  ISRline NonHandledINTCException          ;Vec 001, INTC SW settable Clear Flag 1 
  ISRline NonHandledINTCException          ;Vec 002, INTC SW settable Clear Flag 2 
  ISRline NonHandledINTCException          ;Vec 003, INTC SW settable Clear Flag 3 
  ISRline NonHandledINTCException          ;Vec 004, INTC SW settable Clear Flag 4 
  ISRline NonHandledINTCException          ;Vec 005, INTC SW settable Clear Flag 5 
  ISRline NonHandledINTCException          ;Vec 006, INTC SW settable Clear Flag 6 
  ISRline NonHandledINTCException          ;Vec 007, INTC SW settable Clear Flag 7 
  ISRline NonHandledINTCException          ;Vec 008, INTC SW settable Clear Flag 8 
  ISRline NonHandledINTCException          ;Vec 009, INTC SW settable Clear Flag 9 
  ISRline NonHandledINTCException          ;Vec 010, INTC SW settable Clear Flag 10
  ISRline NonHandledINTCException          ;Vec 011, INTC SW settable Clear Flag 11
  ISRline NonHandledINTCException          ;Vec 012, INTC SW settable Clear Flag 12
  ISRline NonHandledINTCException          ;Vec 013, INTC SW settable Clear Flag 13
  ISRline NonHandledINTCException          ;Vec 014, INTC SW settable Clear Flag 14
  ISRline NonHandledINTCException          ;Vec 015, INTC SW settable Clear Flag 15                                                                                                                           
  ISRline NonHandledINTCException          ;Vec 016, INTC SW settable Clear Flag 16 
  ISRline NonHandledINTCException          ;Vec 017, INTC SW settable Clear Flag 17
  ISRline NonHandledINTCException          ;Vec 018, INTC SW settable Clear Flag 18
  ISRline NonHandledINTCException          ;Vec 019, INTC SW settable Clear Flag 19
  ISRline NonHandledINTCException          ;Vec 020, INTC SW settable Clear Flag 20
  ISRline NonHandledINTCException          ;Vec 021, INTC SW settable Clear Flag 21
  ISRline NonHandledINTCException          ;Vec 022, INTC SW settable Clear Flag 22
  ISRline NonHandledINTCException          ;Vec 023, INTC SW settable Clear Flag 23
                                           ;*** Source of interrupt: Reserved ***
  ISRline NonHandledINTCException          ;Vec 024, Reserved
  ISRline NonHandledINTCException          ;Vec 025, Reserved
  ISRline NonHandledINTCException          ;Vec 026, Reserved
  ISRline NonHandledINTCException          ;Vec 027, Reserved
  ISRline NonHandledINTCException          ;Vec 028, Reserved
  ISRline NonHandledINTCException          ;Vec 029, Reserved
  ISRline NonHandledINTCException          ;Vec 030, Reserved
  ISRline NonHandledINTCException          ;Vec 031, Reserved
  
                                           ;*** Source of interrupt: Software watchdog timer ***
  ISRline NonHandledINTCException          ;Vec 032, Platform watchdog timer0
  ISRline NonHandledINTCException          ;Vec 033, Platform watchdog timer1
  ISRline NonHandledINTCException          ;Vec 034, Platform watchdog timer2
  ISRline NonHandledINTCException          ;Vec 035, Reserved for Platform watchdog timer3

                                           ;*** Source of interrupt: STM ***    
  ISRline NonHandledINTCException          ;Vec 036, On-Platform periodic timer 0_0              
  ISRline NonHandledINTCException          ;Vec 037, On-Platform periodic timer 0_1           
  ISRline NonHandledINTCException          ;Vec 038, On-Platform periodic timer 0_2           
  ISRline NonHandledINTCException          ;Vec 039, On-Platform periodic timer 0_3                                           
  ISRline NonHandledINTCException          ;Vec 040, On-Platform periodic timer 1_0              
  ISRline NonHandledINTCException          ;Vec 041, On-Platform periodic timer 1_1           
  ISRline NonHandledINTCException          ;Vec 042, On-Platform periodic timer 1_2           
  ISRline NonHandledINTCException          ;Vec 043, On-Platform periodic timer 1_3
  ISRline NonHandledINTCException          ;Vec 044, On-Platform periodic timer 2_0              
  ISRline NonHandledINTCException          ;Vec 045, On-Platform periodic timer 2_1           
  ISRline NonHandledINTCException          ;Vec 046, On-Platform periodic timer 2_2           
  ISRline NonHandledINTCException          ;Vec 047, On-Platform periodic timer 2_3  
                                           ;*** Source of interrupt: STM Reserved***
  ISRline NonHandledINTCException          ;Vec 048, Reserved (for Platform periodic timer 3_0)              
  ISRline NonHandledINTCException          ;Vec 049, Reserved (for Platform periodic timer 3_1)           
  ISRline NonHandledINTCException          ;Vec 050, Reserved (for Platform periodic timer 3_2)           
  ISRline NonHandledINTCException          ;Vec 051, Reserved (for Platform periodic timer 3_3)
  
                                           ;*** Source of interrupt: eDMA ***                   
  ISRline NonHandledINTCException          ;Vec 052, eDMA Combined Error                                                    
  ISRline NonHandledINTCException          ;Vec 053, eDMA Channel 0
  ISRline NonHandledINTCException          ;Vec 054, eDMA Channel 1
  ISRline NonHandledINTCException          ;Vec 055, eDMA Channel 2
  ISRline NonHandledINTCException          ;Vec 056, eDMA Channel 3
  ISRline NonHandledINTCException          ;Vec 057, eDMA Channel 4
  ISRline NonHandledINTCException          ;Vec 058, eDMA Channel 5
  ISRline NonHandledINTCException          ;Vec 059, eDMA Channel 6                                                  
  ISRline NonHandledINTCException          ;Vec 060, eDMA Channel 7                                                  
  ISRline NonHandledINTCException          ;Vec 061, eDMA Channel 8 
  ISRline NonHandledINTCException          ;Vec 062, eDMA Channel 9
  ISRline NonHandledINTCException          ;Vec 063, eDMA Channel 10
  ISRline NonHandledINTCException          ;Vec 064, eDMA Channel 11
  ISRline NonHandledINTCException          ;Vec 065, eDMA Channel 12
  ISRline NonHandledINTCException          ;Vec 066, eDMA Channel 13
  ISRline NonHandledINTCException          ;Vec 067, eDMA Channel 14
  ISRline NonHandledINTCException          ;Vec 068, eDMA Channel 15
  ISRline NonHandledINTCException          ;Vec 069, eDMA Channel 16
  ISRline NonHandledINTCException          ;Vec 070, eDMA Channel 17
  ISRline NonHandledINTCException          ;Vec 071, eDMA Channel 18
  ISRline NonHandledINTCException          ;Vec 072, eDMA Channel 19
  ISRline NonHandledINTCException          ;Vec 073, eDMA Channel 20
  ISRline NonHandledINTCException          ;Vec 074, eDMA Channel 21
  ISRline NonHandledINTCException          ;Vec 075, eDMA Channel 22
  ISRline NonHandledINTCException          ;Vec 076, eDMA Channel 23 
  ISRline NonHandledINTCException          ;Vec 077, eDMA Channel 24 
  ISRline NonHandledINTCException          ;Vec 078, eDMA Channel 25
  ISRline NonHandledINTCException          ;Vec 079, eDMA Channel 26
  ISRline NonHandledINTCException          ;Vec 080, eDMA Channel 27
  ISRline NonHandledINTCException          ;Vec 081, eDMA Channel 28
  ISRline NonHandledINTCException          ;Vec 082, eDMA Channel 29
  ISRline NonHandledINTCException          ;Vec 083, eDMA Channel 30
  ISRline NonHandledINTCException          ;Vec 084, eDMA Channel 31
                                           ;*** Source of interrupt: eDMA Reserved ***
  ISRline NonHandledINTCException          ;Vec 085, Reserved for eDMA Channel 32 
  ISRline NonHandledINTCException          ;Vec 086, Reserved for eDMA Channel 33
  ISRline NonHandledINTCException          ;Vec 087, Reserved for eDMA Channel 34
  ISRline NonHandledINTCException          ;Vec 088, Reserved for eDMA Channel 35
  ISRline NonHandledINTCException          ;Vec 089, Reserved for eDMA Channel 36
  ISRline NonHandledINTCException          ;Vec 090, Reserved for eDMA Channel 37
  ISRline NonHandledINTCException          ;Vec 091, Reserved for eDMA Channel 38
  ISRline NonHandledINTCException          ;Vec 092, Reserved for eDMA Channel 39
  ISRline NonHandledINTCException          ;Vec 093, Reserved for eDMA Channel 40
  ISRline NonHandledINTCException          ;Vec 094, Reserved for eDMA Channel 41
  ISRline NonHandledINTCException          ;Vec 095, Reserved for eDMA Channel 42
  ISRline NonHandledINTCException          ;Vec 096, Reserved for eDMA Channel 43
  ISRline NonHandledINTCException          ;Vec 097, Reserved for eDMA Channel 44
  ISRline NonHandledINTCException          ;Vec 098, Reserved for eDMA Channel 45
  ISRline NonHandledINTCException          ;Vec 099, Reserved for eDMA Channel 46
  ISRline NonHandledINTCException          ;Vec 100, Reserved for eDMA Channel 47
  ISRline NonHandledINTCException          ;Vec 101, Reserved for eDMA Channel 48
  ISRline NonHandledINTCException          ;Vec 102, Reserved for eDMA Channel 49                                                    
  ISRline NonHandledINTCException          ;Vec 103, Reserved for eDMA Channel 50
  ISRline NonHandledINTCException          ;Vec 104, Reserved for eDMA Channel 51  
  ISRline NonHandledINTCException          ;Vec 105, Reserved for eDMA Channel 52
  ISRline NonHandledINTCException          ;Vec 106, Reserved for eDMA Channel 53  
  ISRline NonHandledINTCException          ;Vec 107, Reserved for eDMA Channel 54  
  ISRline NonHandledINTCException          ;Vec 108, Reserved for eDMA Channel 55  
  ISRline NonHandledINTCException          ;Vec 109, Reserved for eDMA Channel 56
  ISRline NonHandledINTCException          ;Vec 110, Reserved for eDMA Channel 57  
  ISRline NonHandledINTCException          ;Vec 111, Reserved for eDMA Channel 58
  ISRline NonHandledINTCException          ;Vec 112, Reserved for eDMA Channel 59  
  ISRline NonHandledINTCException          ;Vec 113, Reserved for eDMA Channel 60  
  ISRline NonHandledINTCException          ;Vec 114, Reserved for eDMA Channel 61  
  ISRline NonHandledINTCException          ;Vec 115, Reserved for eDMA Channel 62
  ISRline NonHandledINTCException          ;Vec 116, Reserved for eDMA Channel 63 
  ISRline NonHandledINTCException          ;Vec 117, Reserved for eDMA Channel 64
  ISRline NonHandledINTCException          ;Vec 118, Reserved for eDMA Channel 65  
  ISRline NonHandledINTCException          ;Vec 119, Reserved for eDMA Channel 66
  ISRline NonHandledINTCException          ;Vec 120, Reserved for eDMA Channel 67
  ISRline NonHandledINTCException          ;Vec 121, Reserved for eDMA Channel 68
  ISRline NonHandledINTCException          ;Vec 122, Reserved for eDMA Channel 69
  ISRline NonHandledINTCException          ;Vec 123, Reserved for eDMA Channel 70
  ISRline NonHandledINTCException          ;Vec 124, Reserved for eDMA Channel 71
  ISRline NonHandledINTCException          ;Vec 125, Reserved for eDMA Channel 72
  ISRline NonHandledINTCException          ;Vec 126, Reserved for eDMA Channel 73
  ISRline NonHandledINTCException          ;Vec 127, Reserved for eDMA Channel 74
  ISRline NonHandledINTCException          ;Vec 128, Reserved for eDMA Channel 75
  ISRline NonHandledINTCException          ;Vec 129, Reserved for eDMA Channel 76
  ISRline NonHandledINTCException          ;Vec 130, Reserved for eDMA Channel 77
  ISRline NonHandledINTCException          ;Vec 131, Reserved for eDMA Channel 78
  ISRline NonHandledINTCException          ;Vec 132, Reserved for eDMA Channel 79
  ISRline NonHandledINTCException          ;Vec 133, Reserved for eDMA Channel 80
  ISRline NonHandledINTCException          ;Vec 134, Reserved for eDMA Channel 81
  ISRline NonHandledINTCException          ;Vec 135, Reserved for eDMA Channel 82
  ISRline NonHandledINTCException          ;Vec 136, Reserved for eDMA Channel 83
  ISRline NonHandledINTCException          ;Vec 137, Reserved for eDMA Channel 84
  ISRline NonHandledINTCException          ;Vec 138, Reserved for eDMA Channel 85
  ISRline NonHandledINTCException          ;Vec 139, Reserved for eDMA Channel 86
  ISRline NonHandledINTCException          ;Vec 140, Reserved for eDMA Channel 87
  ISRline NonHandledINTCException          ;Vec 141, Reserved for eDMA Channel 88
  ISRline NonHandledINTCException          ;Vec 142, Reserved for eDMA Channel 89
  ISRline NonHandledINTCException          ;Vec 143, Reserved for eDMA Channel 90
  ISRline NonHandledINTCException          ;Vec 144, Reserved for eDMA Channel 91
  ISRline NonHandledINTCException          ;Vec 145, Reserved for eDMA Channel 92
  ISRline NonHandledINTCException          ;Vec 146, Reserved for eDMA Channel 93
  ISRline NonHandledINTCException          ;Vec 147, Reserved for eDMA Channel 94
  ISRline NonHandledINTCException          ;Vec 148, Reserved for eDMA Channel 95
  ISRline NonHandledINTCException          ;Vec 149, Reserved for eDMA Channel 96
  ISRline NonHandledINTCException          ;Vec 150, Reserved for eDMA Channel 97
  ISRline NonHandledINTCException          ;Vec 151, Reserved for eDMA Channel 98
  ISRline NonHandledINTCException          ;Vec 152, Reserved for eDMA Channel 99
  ISRline NonHandledINTCException          ;Vec 153, Reserved for eDMA Channel 100 
  ISRline NonHandledINTCException          ;Vec 154, Reserved for eDMA Channel 101  
  ISRline NonHandledINTCException          ;Vec 155, Reserved for eDMA Channel 102  
  ISRline NonHandledINTCException          ;Vec 156, Reserved for eDMA Channel 103  
  ISRline NonHandledINTCException          ;Vec 157, Reserved for eDMA Channel 104  
  ISRline NonHandledINTCException          ;Vec 158, Reserved for eDMA Channel 105
  ISRline NonHandledINTCException          ;Vec 159, Reserved for eDMA Channel 106  
  ISRline NonHandledINTCException          ;Vec 160, Reserved for eDMA Channel 107  
  ISRline NonHandledINTCException          ;Vec 161, Reserved for eDMA Channel 108  
  ISRline NonHandledINTCException          ;Vec 162, Reserved for eDMA Channel 109  
  ISRline NonHandledINTCException          ;Vec 163, Reserved for eDMA Channel 110  
  ISRline NonHandledINTCException          ;Vec 164, Reserved for eDMA Channel 111  
  ISRline NonHandledINTCException          ;Vec 165, Reserved for eDMA Channel 112  
  ISRline NonHandledINTCException          ;Vec 166, Reserved for eDMA Channel 113  
  ISRline NonHandledINTCException          ;Vec 167, Reserved for eDMA Channel 114  
  ISRline NonHandledINTCException          ;Vec 168, Reserved for eDMA Channel 115  
  ISRline NonHandledINTCException          ;Vec 169, Reserved for eDMA Channel 116
  ISRline NonHandledINTCException          ;Vec 170, Reserved for eDMA Channel 117  
  ISRline NonHandledINTCException          ;Vec 171, Reserved for eDMA Channel 118  
  ISRline NonHandledINTCException          ;Vec 172, Reserved for eDMA Channel 119  
  ISRline NonHandledINTCException          ;Vec 173, Reserved for eDMA Channel 120  
  ISRline NonHandledINTCException          ;Vec 174, Reserved for eDMA Channel 121  
  ISRline NonHandledINTCException          ;Vec 175, Reserved for eDMA Channel 122  
  ISRline NonHandledINTCException          ;Vec 176, Reserved for eDMA Channel 123
  ISRline NonHandledINTCException          ;Vec 177, Reserved for eDMA Channel 124  
  ISRline NonHandledINTCException          ;Vec 178, Reserved for eDMA Channel 125  
  ISRline NonHandledINTCException          ;Vec 179, Reserved for eDMA Channel 126  
  ISRline NonHandledINTCException          ;Vec 180, Reserved for eDMA Channel 127
  
                                           ;*** Source of interrupt: MEMU Reserved ***
  ISRline NonHandledINTCException          ;Vec 181, Reserved for MEMU (Platform error reporting)
  ISRline NonHandledINTCException          ;Vec 182, Reserved for MEMU (Platform error reporting)   
  ISRline NonHandledINTCException          ;Vec 183, Reserved for MEMU (Platform error reporting)   
  ISRline NonHandledINTCException          ;Vec 184, Reserved for MEMU (Platform error reporting)  
     
                                           ;*** Source of interrupt: Platform flash controller ***
  ISRline NonHandledINTCException          ;Vec 185, Flash controller Prog/Erase/Suspend IRQ_0                                            
                                           ;*** Source of interrupt: Platform flash controller Reserved***
  ISRline NonHandledINTCException          ;Vec 186, Reserved for flash controller IRQs  
  ISRline NonHandledINTCException          ;Vec 187, Reserved for flash controller IRQs  
  ISRline NonHandledINTCException          ;Vec 188, Reserved for flash controller IRQs
  
                                           ;*** Source of interrupt: reserved ***
  ISRline NonHandledINTCException          ;Vec 189, Reserved  
  
                                           ;*** Source of interrupt: Switch Interrupt Group ***
  ISRline NonHandledINTCException          ;Vec 190, Switch Interrupt Group0  
  ISRline NonHandledINTCException          ;Vec 191, Switch Interrupt Group1
  ISRline NonHandledINTCException          ;Vec 192, Switch Interrupt Group2  
  ISRline NonHandledINTCException          ;Vec 193, Switch Interrupt Group3
   
                                           ;*** Source of interrupt: reserved ***
  ISRline NonHandledINTCException          ;Vec 194, Reserved                                            
  ISRline NonHandledINTCException          ;Vec 195, Reserved  
  ISRline NonHandledINTCException          ;Vec 196, Reserved  
  ISRline NonHandledINTCException          ;Vec 197, Reserved 
  ISRline NonHandledINTCException          ;Vec 198, Reserved                                          
  ISRline NonHandledINTCException          ;Vec 199, Reserved
  ISRline NonHandledINTCException          ;Vec 200, Reserved
  
                                           ;*** Source of interrupt: ENET_1 Interrupt ***
  ISRline NonHandledINTCException          ;Vec 201, ENET 1 Interrupt Group0
  ISRline NonHandledINTCException          ;Vec 202, ENET 1 Interrupt Group1
  ISRline NonHandledINTCException          ;Vec 203, ENET 1 Interrupt Group2
  ISRline NonHandledINTCException          ;Vec 204, ENET 1 Interrupt Group3
  ISRline NonHandledINTCException          ;Vec 205, ENET 1 Interrupt Group4
  ISRline NonHandledINTCException          ;Vec 206, ENET 1 Interrupt Group5
  ISRline NonHandledINTCException          ;Vec 207, ENET 1 Interrupt Group6
  ISRline NonHandledINTCException          ;Vec 208, ENET 1 Interrupt Group7
  ISRline NonHandledINTCException          ;Vec 209, ENET 1 Interrupt Group8
  
                                           ;*** Source of interrupt: ENET_0 Interrupt ***
  ISRline NonHandledINTCException          ;Vec 210, ENET 0 Interrupt Group0 
  ISRline NonHandledINTCException          ;Vec 211, ENET 0 Interrupt Group1 
  ISRline NonHandledINTCException          ;Vec 212, ENET 0 Interrupt Group2 
  ISRline NonHandledINTCException          ;Vec 213, ENET 0 Interrupt Group3 
  ISRline NonHandledINTCException          ;Vec 214, ENET 0 Interrupt Group4 
  ISRline NonHandledINTCException          ;Vec 215, ENET 0 Interrupt Group5 
  ISRline NonHandledINTCException          ;Vec 216, ENET 0 Interrupt Group6
  ISRline NonHandledINTCException          ;Vec 217, ENET 0 Interrupt Group7
  ISRline NonHandledINTCException          ;Vec 218, ENET 0 Interrupt Group8
  
                                           ;*** Source of interrupt: ENET Reserved ***
  ISRline NonHandledINTCException          ;Vec 219, Error/Generic IRQ1 Ethernet 0                                               
  ISRline NonHandledINTCException          ;Vec 220, Reserved for Ethernet_0_2          
  ISRline NonHandledINTCException          ;Vec 221, Reserved for Ethernet_1_0            
  ISRline NonHandledINTCException          ;Vec 222, Reserved for Ethernet_1_1            
  ISRline NonHandledINTCException          ;Vec 223, Reserved for Ethernet_1_2
  
                                           ;*** Source of interrupt: RTC Interrupt *** 
  ISRline NonHandledINTCException          ;Vec 224, Reserved for Real Time Counter (RTC)
  
                                           ;*** Source of interrupt: API Interrupt ***
  ISRline NonHandledINTCException          ;Vec 225, Autonomous Periodic Interrupt (API)
  
                                           ;*** Source of interrupt: PIT ***
  ISRline NonHandledINTCException	   ;Vec 226, Periodic Interrupt Timer (PIT) channel 0        
  ISRline NonHandledINTCException          ;Vec 227, Periodic Interrupt Timer (PIT) channel 1        
  ISRline NonHandledINTCException          ;Vec 228, Periodic Interrupt Timer (PIT) channel 2
  ISRline NonHandledINTCException          ;Vec 229, Periodic Interrupt Timer (PIT) channel 3                  
  ISRline NonHandledINTCException          ;Vec 230, Periodic Interrupt Timer (PIT) channel 4
  ISRline NonHandledINTCException          ;Vec 231, Periodic Interrupt Timer (PIT) channel 5
  ISRline NonHandledINTCException          ;Vec 232, Periodic Interrupt Timer (PIT) channel 6
  ISRline NonHandledINTCException          ;Vec 233, Periodic Interrupt Timer (PIT) channel 7
  ISRline NonHandledINTCException          ;Vec 234, Periodic Interrupt Timer (PIT) channel 8
  ISRline NonHandledINTCException          ;Vec 235, Periodic Interrupt Timer (PIT) channel 9
  ISRline NonHandledINTCException          ;Vec 236, Periodic Interrupt Timer (PIT) channel 10
  ISRline NonHandledINTCException          ;Vec 237, Periodic Interrupt Timer (PIT) channel 11
  ISRline NonHandledINTCException          ;Vec 238, Periodic Interrupt Timer (PIT) channel 12
  ISRline NonHandledINTCException          ;Vec 239, Periodic Interrupt Timer (PIT) channel 13                                           
  ISRline NonHandledINTCException          ;Vec 240, Periodic Interrupt Timer (PIT) channel 14
  ISRline NonHandledINTCException          ;Vec 241, Periodic Interrupt Timer (PIT) channel 15
  ISRline NonHandledINTCException          ;Vec 242, PIT_RTI
  
                                           ;*** Source of interrupt: SIUL2 ***
  ISRline NonHandledINTCException          ;Vec 243, SIUL2 External Interrupt_0                               
  ISRline NonHandledINTCException          ;Vec 244, SIUL2 External Interrupt_1
  ISRline NonHandledINTCException          ;Vec 245, SIUL2 External Interrupt_2
  ISRline NonHandledINTCException          ;Vec 246, SIUL2 External Interrupt_3                               
                                           ;*** Source of interrupt: SIUL2 Reserved ***  
  ISRline NonHandledINTCException          ;Vec 247, SIUL2 External Interrupt_4
  ISRline NonHandledINTCException          ;Vec 248, SIUL2 External Interrupt_5
  ISRline NonHandledINTCException          ;Vec 249, SIUL2 External Interrupt_6
  ISRline NonHandledINTCException          ;Vec 250, SIUL2 External Interrupt_7

                                           ;*** Source of interrupt: MC_ME ***  
  ISRline NonHandledINTCException          ;Vec 251, Safe Mode Interrupt
  ISRline NonHandledINTCException          ;Vec 252, Mode Transition Interrupt
  ISRline NonHandledINTCException          ;Vec 253, Invalid Mode Interrupt
  ISRline NonHandledINTCException          ;Vec 254, Invalid Mode Config
  
                                           ;*** Source of interrupt: MC_RGM ***
  ISRline NonHandledINTCException          ;Vec 255, Functional and destructive reset alternate event interrupt
                                           
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 256, Reserved
  
                                           ;*** Source of interrupt: FXOSC Counter ***
  ISRline NonHandledINTCException          ;Vec 257, Fast XOSC Counter
                  
                                           ;*** Source of interrupt: FXOSC Counter ***
  ISRline NonHandledINTCException          ;Vec 258, Slow XOSC Counter  
  
                                           ;*** Source of interrupt: DSPI0 ***
  ISRline NonHandledINTCException          ;Vec 259, DSPI_0_SR[TFUF] | DSPI_0_SR[RFOF] | DSPI_0_SR[TFIWF]                              
  ISRline NonHandledINTCException          ;Vec 260, DSPI_0_SR[EOQF]
  ISRline NonHandledINTCException          ;Vec 261, DSPI_0_SR[TFFF]
  ISRline NonHandledINTCException          ;Vec 262, DSPI_0_SR[TCF]
  ISRline NonHandledINTCException          ;Vec 263, DSPI_0_SR[RFDF]                                           
  ISRline NonHandledINTCException          ;Vec 264, DSPI_0_SR[SPITCF] | DSPI_0_SR[CMD_TCF]                               
  ISRline NonHandledINTCException          ;Vec 265, DSPI_0_SR[DSITCF] | DSPI_0_SR[CMDFFF]
  ISRline NonHandledINTCException          ;Vec 266, DSPI_0_SR[SPEF] | DSPI_0_SR[DPEF]
  ISRline NonHandledINTCException          ;Vec 267, DSPI_0_SR[DDIF]
  
                                           ;*** Source of interrupt: DSPI1 ***
  ISRline NonHandledINTCException          ;Vec 268, DSPI_1_SR[TFUF] | DSPI_1_SR[RFOF] | DSPI_1_SR[TFIWF]                                
  ISRline NonHandledINTCException          ;Vec 269, DSPI_1_SR[EOQF]                                    
  ISRline NonHandledINTCException          ;Vec 270, DSPI_1_SR[TFFF]                                    
  ISRline NonHandledINTCException          ;Vec 271, DSPI_1_SR[TCF]                                     
  ISRline NonHandledINTCException          ;Vec 272, DSPI_1_SR[RFDF]                                    
  ISRline NonHandledINTCException          ;Vec 273, DSPI_1_SR[SPITCF] | DSPI_1_SR[CMD_TCF]             
  ISRline NonHandledINTCException          ;Vec 274, DSPI_1_SR[DSITCF] | DSPI_1_SR[CMDFFF]              
  ISRline NonHandledINTCException          ;Vec 275, DSPI_1_SR[SPEF] | DSPI_1_SR[DPEF]                  
  ISRline NonHandledINTCException          ;Vec 276, DSPI_1_SR[DDIF]                                    
  
                                           ;*** Source of interrupt: DSPI2 ***
  ISRline NonHandledINTCException          ;Vec 277, DSPI_2_SR[TFUF] | DSPI_2_SR[RFOF] | DSPI_2_SR[TFIWF]                                
  ISRline NonHandledINTCException          ;Vec 278, DSPI_2_SR[EOQF]                                      
  ISRline NonHandledINTCException          ;Vec 279, DSPI_2_SR[TFFF]                                      
  ISRline NonHandledINTCException          ;Vec 280, DSPI_2_SR[TCF]                                       
  ISRline NonHandledINTCException          ;Vec 281, DSPI_2_SR[RFDF]                                                               
  ISRline NonHandledINTCException          ;Vec 282, DSPI_2_SR[SPITCF] | DSPI_2_SR[CMD_TCF]                                     
  ISRline NonHandledINTCException          ;Vec 283, DSPI_2_SR[DSITCF] | DSPI_2_SR[CMDFFF]                
  ISRline NonHandledINTCException          ;Vec 284, DSPI_2_SR[SPEF] | DSPI_2_SR[DPEF]                    
  ISRline NonHandledINTCException          ;Vec 285, DSPI_2_SR[DDIF]                                      
  
                                           ;*** Source of interrupt: DSPI3 ***
  ISRline NonHandledINTCException          ;Vec 286, DSPI_3_SR[TFUF] | DSPI_3_SR[RFOF] | DSPI_3_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 287, DSPI_3_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 288, DSPI_3_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 289, DSPI_3_SR[TCF]                                      
  ISRline NonHandledINTCException          ;Vec 290, DSPI_3_SR[RFDF]                                                                
  ISRline NonHandledINTCException          ;Vec 291, DSPI_3_SR[SPITCF] | DSPI_3_SR[CMD_TCF]                                    
  ISRline NonHandledINTCException          ;Vec 292, DSPI_3_SR[DSITCF] | DSPI_3_SR[CMDFFF]               
  ISRline NonHandledINTCException          ;Vec 293, DSPI_3_SR[SPEF] | DSPI_3_SR[DPEF]                   
  ISRline NonHandledINTCException          ;Vec 294, DSPI_3_SR[DDIF]                                     
  
                                           ;*** Source of interrupt: DSPI4 ***
  ISRline NonHandledINTCException          ;Vec 295, DSPI_4_SR[TFUF] | DSPI_4_SR[RFOF] | DSPI_4_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 296, DSPI_4_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 297, DSPI_4_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 298, DSPI_4_SR[TCF]                                         
  ISRline NonHandledINTCException          ;Vec 299, DSPI_4_SR[RFDF]                                                                    
  ISRline NonHandledINTCException          ;Vec 300, DSPI_4_SR[CMD_TCF]              
  ISRline NonHandledINTCException          ;Vec 301, DSPI_4_SR[CMDFFF]              
  ISRline NonHandledINTCException          ;Vec 302, DSPI_4_SR[SPEF]                  
  ISRline NonHandledINTCException          ;Vec 303, Reserved for DSPI4_8                                        
  
                                           ;*** Source of interrupt: DSPI5 ***
  ISRline NonHandledINTCException          ;Vec 304, DSPI_5_SR[TFUF] | DSPI_5_SR[RFOF] | DSPI_5_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 305, DSPI_5_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 306, DSPI_5_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 307, DSPI_5_SR[TCF]                                         
  ISRline NonHandledINTCException          ;Vec 308, DSPI_5_SR[RFDF]                                                                    
  ISRline NonHandledINTCException          ;Vec 309, DSPI_5_SR[CMD_TCF]                                  
  ISRline NonHandledINTCException          ;Vec 310, DSPI_5_SR[CMDFFF]                                   
  ISRline NonHandledINTCException          ;Vec 311, DSPI_5_SR[SPEF]                                     
  ISRline NonHandledINTCException          ;Vec 312, Reserved for DSPI5_8                                 
  
                                           ;*** Source of interrupt: DSPI6 ***
  ISRline NonHandledINTCException          ;Vec 313, DSPI_6_SR[TFUF] | DSPI_6_SR[RFOF] | DSPI_6_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 314, DSPI_6_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 315, DSPI_6_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 316, DSPI_6_SR[TCF]                                         
  ISRline NonHandledINTCException          ;Vec 317, DSPI_6_SR[RFDF]                                                                    
  ISRline NonHandledINTCException          ;Vec 318, DSPI_6_SR[SPITCF] | DSPI_6_SR[CMD_TCF]              
  ISRline NonHandledINTCException          ;Vec 319, DSPI_6_SR[DSITCF] | DSPI_6_SR[CMDFFF]               
  ISRline NonHandledINTCException          ;Vec 320, DSPI_6_SR[SPEF] | DSPI_6_SR[DPEF]                   
  ISRline NonHandledINTCException          ;Vec 321, Reserved for DSPI6_8                                        
  
                                           ;*** Source of interrupt: DSPI7 ***
  ISRline NonHandledINTCException          ;Vec 322, DSPI_7_SR[TFUF] | DSPI_7_SR[RFOF] | DSPI_7_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 323, DSPI_7_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 324, DSPI_7_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 325, DSPI_7_SR[TCF]                                         
  ISRline NonHandledINTCException          ;Vec 326, DSPI_7_SR[RFDF]                                                                    
  ISRline NonHandledINTCException          ;Vec 327, Reserved for DSPI7_5                                  
  ISRline NonHandledINTCException          ;Vec 328, Reserved for DSPI7_6                                   
  ISRline NonHandledINTCException          ;Vec 329, DSPI_7_SR[SPEF]                                     
  ISRline NonHandledINTCException          ;Vec 330, Reserved for DSPI7_8                                   

                                           ;*** Source of interrupt: DSPI8 ***
  ISRline NonHandledINTCException          ;Vec 331, DSPI_8_SR[TFUF] | DSPI_8_SR[RFOF] | DSPI_8_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 332, DSPI_8_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 333, DSPI_8_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 334, DSPI_8_SR[TCF]                                         
  ISRline NonHandledINTCException          ;Vec 335, DSPI_8_SR[RFDF]                                                                    
  ISRline NonHandledINTCException          ;Vec 336, Reserved for DSPI8_5                                
  ISRline NonHandledINTCException          ;Vec 337, Reserved for DSPI8_6                                
  ISRline NonHandledINTCException          ;Vec 338, DSPI_8_SR[SPEF]                                     
  ISRline NonHandledINTCException          ;Vec 339, Reserved for DSPI8_8                                      
  
                                           ;*** Source of interrupt: DSPI9 ***
  ISRline NonHandledINTCException          ;Vec 340, DSPI_9_SR[TFUF] | DSPI_9_SR[RFOF] | DSPI_9_SR[TFIWF]                               
  ISRline NonHandledINTCException          ;Vec 341, DSPI_9_SR[EOQF]                                     
  ISRline NonHandledINTCException          ;Vec 342, DSPI_9_SR[TFFF]                                     
  ISRline NonHandledINTCException          ;Vec 343, DSPI_9_SR[TCF]                                         
  ISRline NonHandledINTCException          ;Vec 344, DSPI_9_SR[RFDF]                                                                    
  ISRline NonHandledINTCException          ;Vec 345, Reserved for DSPI9_5                                
  ISRline NonHandledINTCException          ;Vec 346, Reserved for DSPI9_6                                
  ISRline NonHandledINTCException          ;Vec 347, DSPI_9_SR[SPEF]                                     
  ISRline NonHandledINTCException          ;Vec 348, Reserved for DSPI9_8                                  
  
                                           ;*** Source of interrupt: DSPI10 Reserved ***
  ISRline NonHandledINTCException          ;Vec 349, Reserved for DSPI10_0                               
  ISRline NonHandledINTCException          ;Vec 350, Reserved for DSPI10_1
  ISRline NonHandledINTCException          ;Vec 351, Reserved for DSPI10_2
  ISRline NonHandledINTCException          ;Vec 352, Reserved for DSPI10_3   
  ISRline NonHandledINTCException          ;Vec 353, Reserved for DSPI10_4                               
  ISRline NonHandledINTCException          ;Vec 354, Reserved for DSPI10_5
  ISRline NonHandledINTCException          ;Vec 355, Reserved for DSPI10_6
  ISRline NonHandledINTCException          ;Vec 356, Reserved for DSPI10_7
  ISRline NonHandledINTCException          ;Vec 357, Reserved for DSPI10_8
  
                                           ;*** Source of interrupt: DSPI11 Reserved ***
  ISRline NonHandledINTCException          ;Vec 358, Reserved for DSPI11_0                               
  ISRline NonHandledINTCException          ;Vec 359, Reserved for DSPI11_1
  ISRline NonHandledINTCException          ;Vec 360, Reserved for DSPI11_2
  ISRline NonHandledINTCException          ;Vec 361, Reserved for DSPI11_3   
  ISRline NonHandledINTCException          ;Vec 362, Reserved for DSPI11_4                               
  ISRline NonHandledINTCException          ;Vec 363, Reserved for DSPI11_5
  ISRline NonHandledINTCException          ;Vec 364, Reserved for DSPI11_6
  ISRline NonHandledINTCException          ;Vec 365, Reserved for DSPI11_7
  ISRline NonHandledINTCException          ;Vec 366, Reserved for DSPI11_8 
  
                                           ;*** Source of interrupt: DSPI12 Reserved ***
  ISRline NonHandledINTCException          ;Vec 367, Reserved for DSPI12_0                               
  ISRline NonHandledINTCException          ;Vec 368, Reserved for DSPI12_1
  ISRline NonHandledINTCException          ;Vec 369, Reserved for DSPI12_2
  ISRline NonHandledINTCException          ;Vec 370, Reserved for DSPI12_3   
  ISRline NonHandledINTCException          ;Vec 371, Reserved for DSPI12_4
  
                                           ;*** Source of interrupt: BCTU ***
  ISRline NonHandledINTCException          ;Vec 372, LIST0_LAST | LIST1_LAST
  ISRline NonHandledINTCException          ;Vec 373, NDATA0 | NDATA1 | DATA_OVR0 | DATA_OVR1 | Trigger
  
                                           ;*** Source of interrupt: Reserved ***
  ISRline NonHandledINTCException          ;Vec 374, Reserved
  ISRline NonHandledINTCException          ;Vec 375, Reserved
    
                                           ;*** Source of interrupt: LINFlex_0 ***
  ISRline NonHandledINTCException          ;Vec 376, LINFlex_0_RXI                               
  ISRline NonHandledINTCException          ;Vec 377, LINFlex_0_TXI
  ISRline NonHandledINTCException          ;Vec 378, LINFlex_0_ERR
   
                                           ;*** Source of interrupt: LINFlex_1 ***
  ISRline NonHandledINTCException          ;Vec 379, LINFlex_1_RXI                               
  ISRline NonHandledINTCException          ;Vec 380, LINFlex_1_TXI
  ISRline NonHandledINTCException          ;Vec 381, LINFlex_1_ERR
  
                                           ;*** Source of interrupt: LINFlex_2 ***
  ISRline LINFlexD_2_RX_ISR 	           ;Vec 382, LINFlex_2_RXI
  ISRline LINFlexD_2_TX_ISR	           ;Vec 383, LINFlex_2_TXI

  ISRline NonHandledINTCException          ;Vec 384, LINFlex_2_ERR
    
                                           ;*** Source of interrupt: LINFlex_3 ***
  ISRline NonHandledINTCException          ;Vec 385, LINFlex_3_RXI
  ISRline NonHandledINTCException          ;Vec 386, LINFlex_3_TXI
  ISRline NonHandledINTCException          ;Vec 387, LINFlex_3_ERR  
                                                     
                                           ;*** Source of interrupt: LINFlex_4 ***
  ISRline NonHandledINTCException          ;Vec 388, LINFlex_4_RXI
  ISRline NonHandledINTCException          ;Vec 389, LINFlex_4_TXI
  ISRline NonHandledINTCException          ;Vec 390, LINFlex_4_ERR
       
                                           ;*** Source of interrupt: LINFlex_5 ***
  ISRline NonHandledINTCException          ;Vec 391, LINFlex_5_RXI
  ISRline NonHandledINTCException          ;Vec 392, LINFlex_5_TXI
  ISRline NonHandledINTCException          ;Vec 393, LINFlex_5_ERR
      
                                           ;*** Source of interrupt: LINFlex_6 ***
  ISRline NonHandledINTCException          ;Vec 394, LINFlex_6_RXI
  ISRline NonHandledINTCException          ;Vec 395, LINFlex_6_TXI
  ISRline NonHandledINTCException          ;Vec 396, LINFlex_6_ERR
      
                                             ;*** Source of interrupt: LINFlex_7 ***
  ISRline NonHandledINTCException          ;Vec 397, LINFlex_7_RXI
  ISRline NonHandledINTCException          ;Vec 398, LINFlex_7_TXI
  ISRline NonHandledINTCException          ;Vec 399, LINFlex_7_ERR   
  
                                           ;*** Source of interrupt: LINFlex_8 ***
  ISRline NonHandledINTCException          ;Vec 400, LINFlex_8_RXI
  ISRline NonHandledINTCException          ;Vec 401, LINFlex_8_TXI
  ISRline NonHandledINTCException          ;Vec 402, LINFlex_8_ERR      
  
                                           ;*** Source of interrupt: LINFlex_9 ***
  ISRline NonHandledINTCException          ;Vec 403, LINFlex_9_RXI
  ISRline NonHandledINTCException          ;Vec 404, LINFlex_9_TXI
  ISRline NonHandledINTCException          ;Vec 405, LINFlex_9_ERR    
  
                                           ;*** Source of interrupt: LINFlex_10 ***
  ISRline NonHandledINTCException          ;Vec 406, LINFlex_10_RXI
  ISRline NonHandledINTCException          ;Vec 407, LINFlex_10_TXI
  ISRline NonHandledINTCException          ;Vec 408, LINFlex_10_ERR
       
                                           ;*** Source of interrupt: LINFlex_11 ***
  ISRline NonHandledINTCException          ;Vec 409, LINFlex_11_RXI
  ISRline NonHandledINTCException          ;Vec 410, LINFlex_11_TXI
  ISRline NonHandledINTCException          ;Vec 411, LINFlex_11_ERR      
  
                                           ;*** Source of interrupt: LINFlex_12 ***
  ISRline NonHandledINTCException          ;Vec 412, LINFlex_12_RXI
  ISRline NonHandledINTCException          ;Vec 413, LINFlex_12_TXI
  ISRline NonHandledINTCException          ;Vec 414, LINFlex_12_ERR
    
                                           ;*** Source of interrupt: LINFlex_13 ***
  ISRline NonHandledINTCException          ;Vec 415, LINFlex_13_RXI
  ISRline NonHandledINTCException          ;Vec 416, LINFlex_13_TXI
  ISRline NonHandledINTCException          ;Vec 417, LINFlex_13_ERR
       
                                           ;*** Source of interrupt: LINFlex_14 ***
  ISRline NonHandledINTCException          ;Vec 418, LINFlex_14_RXI
  ISRline NonHandledINTCException          ;Vec 419, LINFlex_14_TXI
  ISRline NonHandledINTCException          ;Vec 420, LINFlex_14_ERR    
  
                                           ;*** Source of interrupt: LINFlex_15 ***
  ISRline NonHandledINTCException          ;Vec 421, LINFlex_15_RXI
  ISRline NonHandledINTCException          ;Vec 422, LINFlex_15_TXI
  ISRline NonHandledINTCException          ;Vec 423, LINFlex_15_ERR

                                           ;*** Source of interrupt: LINFlex_16 ***
  ISRline NonHandledINTCException          ;Vec 424, LINFlex_16_RXI
  ISRline NonHandledINTCException          ;Vec 425, LINFlex_16_TXI
  ISRline NonHandledINTCException          ;Vec 426, LINFlex_16_ERR

                                           ;*** Source of interrupt: LINFlex_17 ***
  ISRline NonHandledINTCException          ;Vec 427, LINFlex_17_RXI
  ISRline NonHandledINTCException          ;Vec 428, LINFlex_17_TXI
  ISRline NonHandledINTCException          ;Vec 429, LINFlex_17_ERR
  
                                           ;*** Source of interrupt: Reserved ***
  ISRline NonHandledINTCException          ;Vec 430, Reserved
  ISRline NonHandledINTCException          ;Vec 431, Reserved
  ISRline NonHandledINTCException          ;Vec 432, Reserved
  ISRline NonHandledINTCException          ;Vec 433, Reserved
  ISRline NonHandledINTCException          ;Vec 434, Reserved
  ISRline NonHandledINTCException          ;Vec 435, Reserved
  ISRline NonHandledINTCException          ;Vec 436, Reserved
  ISRline NonHandledINTCException          ;Vec 437, Reserved
  ISRline NonHandledINTCException          ;Vec 438, Reserved
  ISRline NonHandledINTCException          ;Vec 339, Reserved
  
                                            ;*** Source of interrupt: IIC_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 440, I2C0_SR[IBAL] | I2C0_SR[TCF] | I2C0_SR[IAAS]
  ISRline NonHandledINTCException          ;Vec 441, Reserved for IIC_0_1
  
                                           ;*** Source of interrupt: IIC_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 442, I2C1_SR[IBAL] | I2C1_SR[TCF] | I2C1_SR[IAAS]
  ISRline NonHandledINTCException          ;Vec 443, Reserved for IIC_1_1
  
                                           ;*** Source of interrupt: IIC_2 Reserved ***
  ISRline NonHandledINTCException          ;Vec 444, I2C2_SR[IBAL] | I2C2_SR[TCF] | I2C2_SR[IAAS]
  ISRline NonHandledINTCException          ;Vec 445, Reserved for IIC_2_1
 
                                           ;*** Source of interrupt: IIC_3 Reserved ***
  ISRline NonHandledINTCException          ;Vec 446, I2C3_SR[IBAL] | I2C3_SR[TCF] | I2C3_SR[IAAS]
  ISRline NonHandledINTCException          ;Vec 447, Reserved for IIC_3_1
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 448, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 449, Reserved for future use                                           
  ISRline NonHandledINTCException          ;Vec 450, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 451, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 452, Reserved for future use    
    
                                           ;*** Source of interrupt: FlexRay_0 ***
  ISRline NonHandledINTCException          ;Vec 453, LRNEIF | DRNEIF
  ISRline NonHandledINTCException          ;Vec 454, LRCEIF | DRCEIF
  ISRline NonHandledINTCException          ;Vec 455, FNEAIF
  ISRline NonHandledINTCException          ;Vec 456, FNEBIF
  ISRline NonHandledINTCException          ;Vec 457, WUPIF
  ISRline NonHandledINTCException          ;Vec 458, PRIF
  ISRline NonHandledINTCException          ;Vec 459, CHIF
  ISRline NonHandledINTCException          ;Vec 460, TBIF
  ISRline NonHandledINTCException          ;Vec 461, RBIF
  ISRline NonHandledINTCException          ;Vec 462, MIF
                                           ;*** Source of interrupt: FlexRay_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 463, Reserved for FlexRay_0_10
  ISRline NonHandledINTCException          ;Vec 464, Reserved for FlexRay_0_11
  
                                           ;*** Source of interrupt: FlexRay_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 465, Reserved for FlexRay_1_0
  ISRline NonHandledINTCException          ;Vec 466, Reserved for FlexRay_1_1
  ISRline NonHandledINTCException          ;Vec 467, Reserved for FlexRay_1_2
  ISRline NonHandledINTCException          ;Vec 468, Reserved for FlexRay_1_3
  ISRline NonHandledINTCException          ;Vec 469, Reserved for FlexRay_1_4
  ISRline NonHandledINTCException          ;Vec 470, Reserved for FlexRay_1_5
  ISRline NonHandledINTCException          ;Vec 471, Reserved for FlexRay_1_6
  ISRline NonHandledINTCException          ;Vec 472, Reserved for FlexRay_1_7
  ISRline NonHandledINTCException          ;Vec 473, Reserved for FlexRay_1_8
  ISRline NonHandledINTCException          ;Vec 474, Reserved for FlexRay_1_9        
  ISRline NonHandledINTCException          ;Vec 475, Reserved for FlexRay_1_10
  ISRline NonHandledINTCException          ;Vec 476, Reserved for FlexRay_1_11
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 477, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 478, Reserved for future use                                           
  ISRline NonHandledINTCException          ;Vec 479, Reserved for future use
  
                                           ;*** Source of interrupt: PMU Reserved ***
  ISRline NonHandledINTCException          ;Vec 477, Reserved for Power Monitor Unit
  ISRline NonHandledINTCException          ;Vec 478, Reserved for Power management Unit (temp sensor)
  
                                           ;*** Source of interrupt: CMU Reserved ***
  ISRline NonHandledINTCException          ;Vec 479, Reserved for Clock Monitor Unit    
  
                                           ;*** Source of interrupt: PLL_0 ***
  ISRline NonHandledINTCException          ;Vec 480, Loss-of-lock interrupt request for PLL
                                           ;*** Source of interrupt: PLL_0 Reserved ***
  ISRline NonHandledINTCException          ;Vec 481, Reserved for PLL_0
  
                                           ;*** Source of interrupt: PLL_1 Reserved ***
  ISRline NonHandledINTCException          ;Vec 482, Reserved for PLL_1
  ISRline NonHandledINTCException          ;Vec 483, Reserved for PLL_1
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 484, Reserved for ipi_int_ext_pd1_done
  ISRline NonHandledINTCException          ;Vec 485, Reserved for ipi_int_ext_pd2_done                                           
  ISRline NonHandledINTCException          ;Vec 486, Reserved for ipi_int_pll1_clk_sw
  ISRline NonHandledINTCException          ;Vec 487, Reserved for ipi_int_pll2_clk_sw
      
                                           ;*** Source of interrupt: FCCU ***
  ISRline NonHandledINTCException          ;Vec 488, Alarm Interrupt (ALRM)
  ISRline NonHandledINTCException          ;Vec 489, Configuration Time-out (CFG_TO)
  ISRline NonHandledINTCException          ;Vec 490, EOUT interrupt
                                           ;*** Source of interrupt: FCCU Reserved ***
  ISRline NonHandledINTCException          ;Vec 491, Reserved for FCCU
  ISRline NonHandledINTCException          ;Vec 492, Reserved for FCCU_4
  ISRline NonHandledINTCException          ;Vec 493, Reserved for FCCU_5
  ISRline NonHandledINTCException          ;Vec 494, Reserved for FCCU_6
  ISRline NonHandledINTCException          ;Vec 495, Reserved for FCCU_7  
    
                                           ;*** Source of interrupt: Hardware Security Module 0 ***
  ISRline NonHandledINTCException          ;Vec 496, HSM2HTIE[0]
  
                                           ;*** Source of interrupt: Hardware Security Module 1 ***
  ISRline NonHandledINTCException          ;Vec 497, HSM2HTIE[1]
  
                                           ;*** Source of interrupt: Hardware Security Module 2 ***
  ISRline NonHandledINTCException          ;Vec 498, HSM2HTIE[2]  
  
                                           ;*** Source of interrupt: Hardware Security Module 3 ***
  ISRline NonHandledINTCException          ;Vec 499, HSM2HTIE[3]  
  
                                           ;*** Source of interrupt: Hardware Security Module 4 ***
  ISRline NonHandledINTCException          ;Vec 500, HSM2HTIE[4]  
  
                                           ;*** Source of interrupt: Hardware Security Module 5 ***
  ISRline NonHandledINTCException          ;Vec 501, HSM2HTIE[5]
    
                                           ;*** Source of interrupt: Hardware Security Module 6 ***
  ISRline NonHandledINTCException          ;Vec 502, HSM2HTIE[6]
  
                                           ;*** Source of interrupt: Hardware Security Module 7 ***
  ISRline NonHandledINTCException          ;Vec 503, HSM2HTIE[7]
  
                                           ;*** Source of interrupt: Hardware Security Module 8 ***
  ISRline NonHandledINTCException          ;Vec 504, HSM2HTIE[8]
  
                                           ;*** Source of interrupt: Hardware Security Module 9 ***
  ISRline NonHandledINTCException          ;Vec 505, HSM2HTIE[9]
  
                                           ;*** Source of interrupt: Hardware Security Module 10 ***
  ISRline NonHandledINTCException          ;Vec 506, HSM2HTIE[10]
  
                                           ;*** Source of interrupt: Hardware Security Module 11 ***
  ISRline NonHandledINTCException          ;Vec 507, HSM2HTIE[11]
  
                                           ;*** Source of interrupt: Hardware Security Module 12 ***
  ISRline NonHandledINTCException          ;Vec 508, HSM2HTIE[12]
  
                                           ;*** Source of interrupt: Hardware Security Module 13 ***
  ISRline NonHandledINTCException          ;Vec 509, HSM2HTIE[13]
  
                                           ;*** Source of interrupt: Hardware Security Module 14 ***
  ISRline NonHandledINTCException          ;Vec 510, HSM2HTIE[14]                                   
  
                                           ;*** Source of interrupt: Hardware Security Module 15 ***
  ISRline NonHandledINTCException          ;Vec 511, HSM2HTIE[15]
  
                                           ;*** Source of interrupt: Hardware Security Module 16 ***
  ISRline NonHandledINTCException          ;Vec 512, HSM2HTIE[16]
  
                                           ;*** Source of interrupt: Hardware Security Module 17 ***
  ISRline NonHandledINTCException          ;Vec 513, HSM2HTIE[17]
                 
                                           ;*** Source of interrupt: Hardware Security Module 18 ***
  ISRline NonHandledINTCException          ;Vec 514, HSM2HTIE[18]

                                           ;*** Source of interrupt: Hardware Security Module 19 ***
  ISRline NonHandledINTCException          ;Vec 515, HSM2HTIE[19]
  
                                           ;*** Source of interrupt: Hardware Security Module 20 ***
  ISRline NonHandledINTCException          ;Vec 516, HSM2HTIE[20]

                                           ;*** Source of interrupt: Hardware Security Module 21 ***
  ISRline NonHandledINTCException          ;Vec 517, HSM2HTIE[21]
  
                                           ;*** Source of interrupt: Hardware Security Module 22 ***
  ISRline NonHandledINTCException          ;Vec 518, HSM2HTIE[22]
  
                                           ;*** Source of interrupt: Hardware Security Module 23 ***
  ISRline NonHandledINTCException          ;Vec 519, HSM2HTIE[23]
  
                                           ;*** Source of interrupt: Hardware Security Module 24 ***
  ISRline NonHandledINTCException          ;Vec 520, HSM2HTIE[24]
  
                                           ;*** Source of interrupt: Hardware Security Module 25 ***
  ISRline NonHandledINTCException          ;Vec 521, HSM2HTIE[25]
  
                                           ;*** Source of interrupt: Hardware Security Module 26 ***
  ISRline NonHandledINTCException          ;Vec 522, HSM2HTIE[26]
  
                                           ;*** Source of interrupt: Hardware Security Module 27 ***
  ISRline NonHandledINTCException          ;Vec 523, HSM2HTIE[27]
  
                                           ;*** Source of interrupt: Hardware Security Module 28 ***
  ISRline NonHandledINTCException          ;Vec 524, HSM2HTIE[28]
  
                                           ;*** Source of interrupt: Hardware Security Module 29 ***
  ISRline NonHandledINTCException          ;Vec 525, HSM2HTIE[29]
  
                                           ;*** Source of interrupt: Hardware Security Module 30 ***
  ISRline NonHandledINTCException          ;Vec 526, HSM2HTIE[30]
  
                                           ;*** Source of interrupt: Hardware Security Module 31 ***
  ISRline NonHandledINTCException          ;Vec 527, HSM2HTIE[31]                                                      

                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 528, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 529, Reserved for future use                                           
  ISRline NonHandledINTCException          ;Vec 530, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 531, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 532, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 533, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 534, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 535, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 536, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 537, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 538, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 539, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 540, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 541, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 542, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 543, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 544, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 545, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 546, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 547, Reserved for future use
  
                                           ;*** Source of interrupt: ADC_0 ***   
  ISRline NonHandledINTCException          ;Vec 548, ADC_0_EOC 
  ISRline NonHandledINTCException          ;Vec 549, ADC_0_ER                                                                                    
  ISRline NonHandledINTCException          ;Vec 550, ADC_0_WD
  
                                             ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 551, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 552, Reserved for future use                                           
  ISRline NonHandledINTCException          ;Vec 553, Reserved for future use

                                           ;*** Source of interrupt: ADC_1 ***
  ISRline NonHandledINTCException          ;Vec 554, ADC_EOC
  ISRline NonHandledINTCException          ;Vec 555, ADC_ER 
  ISRline NonHandledINTCException          ;Vec 556, ADC_WD
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 557, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 558, Reserved for future use                                           
  ISRline NonHandledINTCException          ;Vec 559, Reserved for future use
  
                                           ;*** Source of interrupt: Analogue Comparator Module 0 ***                                          
  ISRline NonHandledINTCException          ;Vec 560, CMP0  
  
                                           ;*** Source of interrupt: Analogue Comparator Module 1 ***                                          
  ISRline NonHandledINTCException          ;Vec 561, CMP1
  
                                           ;*** Source of interrupt: Analogue Comparator Module 2 ***                                          
  ISRline NonHandledINTCException          ;Vec 562, CMP2        
  
                                            ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 563, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 564, Reserved for future use                                           

                                           ;*** Source of interrupt: FlexCAN_0 ***
  ISRline NonHandledINTCException          ;Vec 565, FlexCAN0_PN                                                                                     
  ISRline NonHandledINTCException          ;Vec 566, FLEXCAN_0_ESR[ERR_INT] | FLEXCAN_0_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 567, FLEXCAN_0_ESR_BOFF | FLEXCAN_0_ESR_BOFF_DONE | FLEXCAN_0_Transmit_Warning | FLEXCAN_0_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 568, FlexCAN0_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 569, FlexCAN0_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 570, FlexCAN0_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 571, FlexCAN0_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 572, FlexCAN0_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 573, FlexCAN0_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 574, FlexCAN0_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_0 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 575, Reserved
  ISRline NonHandledINTCException          ;Vec 576, Reserved
  ISRline NonHandledINTCException          ;Vec 577, Reserved
  
                                           ;*** Source of interrupt: FlexCAN_1 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 578, FLEXCAN_1_ESR[ERR_INT] | FLEXCAN_1_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 579, FLEXCAN_1_ESR_BOFF | FLEXCAN_1_ESR_BOFF_DONE | FLEXCAN_1_Transmit_Warning | FLEXCAN_1_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 580, FlexCAN1_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 581, FlexCAN1_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 582, FlexCAN1_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 583, FlexCAN1_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 584, FlexCAN1_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 585, FlexCAN1_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 586, FlexCAN1_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_1 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 587, Reserved
  ISRline NonHandledINTCException          ;Vec 588, Reserved
  ISRline NonHandledINTCException          ;Vec 589, Reserved  

                                           ;*** Source of interrupt: FlexCAN_2 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 590, FLEXCAN_2_ESR[ERR_INT] | FLEXCAN_2_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 591, FLEXCAN_2_ESR_BOFF | FLEXCAN_2_ESR_BOFF_DONE | FLEXCAN_2_Transmit_Warning | FLEXCAN_2_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 592, FlexCAN2_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 593, FlexCAN2_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 594, FlexCAN2_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 595, FlexCAN2_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 596, FlexCAN2_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 597, FlexCAN2_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 598, FlexCAN2_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_2 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 599, Reserved
  ISRline NonHandledINTCException          ;Vec 600, Reserved
  ISRline NonHandledINTCException          ;Vec 601, Reserved  

                                           ;*** Source of interrupt: FlexCAN_3 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 602, FLEXCAN_3_ESR[ERR_INT] | FLEXCAN_3_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 603, FLEXCAN_3_ESR_BOFF | FLEXCAN_3_ESR_BOFF_DONE | FLEXCAN_3_Transmit_Warning | FLEXCAN_3_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 604, FlexCAN3_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 605, FlexCAN3_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 606, FlexCAN3_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 607, FlexCAN3_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 608, FlexCAN3_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 609, FlexCAN3_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 610, FlexCAN3_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_3 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 611, Reserved
  ISRline NonHandledINTCException          ;Vec 612, Reserved
  ISRline NonHandledINTCException          ;Vec 613, Reserved  

                                           ;*** Source of interrupt: FlexCAN_4 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 614, FLEXCAN_4_ESR[ERR_INT] | FLEXCAN_4_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 615, FLEXCAN_4_ESR_BOFF | FLEXCAN_4_ESR_BOFF_DONE | FLEXCAN_4_Transmit_Warning | FLEXCAN_4_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 616, FlexCAN4_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 617, FlexCAN4_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 618, FlexCAN4_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 619, FlexCAN4_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 620, FlexCAN4_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 621, FlexCAN4_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 622, FlexCAN4_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_4 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 623, Reserved
  ISRline NonHandledINTCException          ;Vec 624, Reserved
  ISRline NonHandledINTCException          ;Vec 625, Reserved  

                                           ;*** Source of interrupt: FlexCAN_5 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 626, FLEXCAN_5_ESR[ERR_INT] | FLEXCAN_5_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 627, FLEXCAN_5_ESR_BOFF | FLEXCAN_5_ESR_BOFF_DONE | FLEXCAN_5_Transmit_Warning | FLEXCAN_5_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 628, FlexCAN5_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 629, FlexCAN5_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 630, FlexCAN5_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 631, FlexCAN5_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 632, FlexCAN5_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 633, FlexCAN5_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 634, FlexCAN5_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_5 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 635, Reserved
  ISRline NonHandledINTCException          ;Vec 636, Reserved
  ISRline NonHandledINTCException          ;Vec 637, Reserved  

                                           ;*** Source of interrupt: FlexCAN_6 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 638, FLEXCAN_6_ESR[ERR_INT] | FLEXCAN_6_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 639, FLEXCAN_6_ESR_BOFF | FLEXCAN_6_ESR_BOFF_DONE | FLEXCAN_6_Transmit_Warning | FLEXCAN_6_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 640, FlexCAN6_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 641, FlexCAN6_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 642, FlexCAN6_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 643, FlexCAN6_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 644, FlexCAN6_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 645, FlexCAN6_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 646, FlexCAN6_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_6 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 647, Reserved
  ISRline NonHandledINTCException          ;Vec 648, Reserved
  ISRline NonHandledINTCException          ;Vec 649, Reserved  

                                           ;*** Source of interrupt: FlexCAN_7 ***                                                                                     
  ISRline NonHandledINTCException          ;Vec 650, FLEXCAN_7_ESR[ERR_INT] | FLEXCAN_7_FD_ERROR
  ISRline NonHandledINTCException          ;Vec 651, FLEXCAN_7_ESR_BOFF | FLEXCAN_7_ESR_BOFF_DONE | FLEXCAN_7_Transmit_Warning | FLEXCAN_7_Receive_Warning
  ISRline NonHandledINTCException          ;Vec 652, FlexCAN7_BUF_00_03
  ISRline NonHandledINTCException          ;Vec 653, FlexCAN7_BUF_04_07
  ISRline NonHandledINTCException          ;Vec 654, FlexCAN7_BUF_08_11
  ISRline NonHandledINTCException          ;Vec 655, FlexCAN7_BUF_12_15
  ISRline NonHandledINTCException          ;Vec 656, FlexCAN7_BUF_16_31
  ISRline NonHandledINTCException          ;Vec 657, FlexCAN7_BUF_32_63
  ISRline NonHandledINTCException          ;Vec 658, FlexCAN7_BUF_64_95
                                           ;*** Source of interrupt: FlexCAN_7 Reserved ***                 
  ISRline NonHandledINTCException          ;Vec 659, Reserved
  ISRline NonHandledINTCException          ;Vec 660, Reserved
  ISRline NonHandledINTCException          ;Vec 661, Reserved  
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 662, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 663, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 664, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 665, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 666, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 667, Reserved for future use
                    
                                           ;*** Source of interrupt: Wakeup Unit ***
  ISRline NonHandledINTCException          ;Vec 668, WKPU_IRQ_0
  ISRline NonHandledINTCException          ;Vec 669, WKPU_IRQ_1
  ISRline NonHandledINTCException          ;Vec 670, WKPU_IRQ_2
  ISRline NonHandledINTCException          ;Vec 671, WKPU_IRQ_3
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 672, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 673, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 674, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 675, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 676, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 677, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 678, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 679, Reserved for future use
  
                                           ;*** Source of interrupt: SDIO (SDHC) 0 ***
  ISRline NonHandledINTCException          ;Vec 680, SDHC0  
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 681, Reserved for future use
  
                                           ;*** Source of interrupt: USB ***
  ISRline NonHandledINTCException          ;Vec 682, USB OTG
  ISRline NonHandledINTCException          ;Vec 683, USB SPH    
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 684, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 685, Reserved for future use
  
                                           ;*** Source of interrupt: MLB ***
  ISRline NonHandledINTCException          ;Vec 686, MLB block interrupt
  ISRline NonHandledINTCException          ;Vec 687, MLB Channel Interrupts 0-15 Combined      
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 688, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 689, Reserved for future use
  
                                           ;*** Source of interrupt: SAI 0 ***
  ISRline NonHandledINTCException          ;Vec 690, SAI0_TX_FIFO_IRQ
  ISRline NonHandledINTCException          ;Vec 691, SAI0_RX_FIFO_IRQ        
  
                                           ;*** Source of interrupt: SAI 1 ***
  ISRline NonHandledINTCException          ;Vec 692, SAI1_TX_FIFO_IRQ
  ISRline NonHandledINTCException          ;Vec 693, SAI1_RX_FIFO_IRQ          
  
                                           ;*** Source of interrupt: SAI 2 ***
  ISRline NonHandledINTCException          ;Vec 694, SAI2_TX_FIFO_IRQ
  ISRline NonHandledINTCException          ;Vec 695, SAI2_RX_FIFO_IRQ 
  
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 696, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 697, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 698, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 699, Reserved for future use
  ISRline NonHandledINTCException          ;Vec 700, Reserved for future use           

                                           ;*** Source of interrupt: JDC ***
  ISRline NonHandledINTCException          ;Vec 701, JDC           
  
                                           ;*** Source of interrupt: MEMU 1 ***
  ISRline NonHandledINTCException          ;Vec 702, Correctable errors in LPU mode           
 
                                           ;*** Source of interrupt: Not defined Reserved ***
  ISRline NonHandledINTCException          ;Vec 703, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 704, Reserved for future use  
  ISRline NonHandledINTCException          ;Vec 705, Reserved for future use   
 
                                           ;*** Source of interrupt: eMIOS 0 ***
  ISRline NonHandledINTCException          ;Vec 706, EMIOS_GFR[F0,F1]  
  ISRline NonHandledINTCException          ;Vec 707, EMIOS_GFR[F2,F3]  
  ISRline NonHandledINTCException          ;Vec 708, EMIOS_GFR[F4,F5]
  ISRline NonHandledINTCException          ;Vec 709, EMIOS_GFR[F6,F7]  
  ISRline NonHandledINTCException          ;Vec 710, EMIOS_GFR[F8,F9]  
  ISRline NonHandledINTCException          ;Vec 711, EMIOS_GFR[F10,F11]
  ISRline NonHandledINTCException          ;Vec 712, EMIOS_GFR[F12,F13]  
  ISRline NonHandledINTCException          ;Vec 713, EMIOS_GFR[F14,F15]
  ISRline NonHandledINTCException          ;Vec 714, EMIOS_GFR[F16,F17]  
  ISRline NonHandledINTCException          ;Vec 715, EMIOS_GFR[F18,F19]
  ISRline NonHandledINTCException          ;Vec 716, EMIOS_GFR[F20,F21]  
  ISRline NonHandledINTCException          ;Vec 717, EMIOS_GFR[F22,F23]
  ISRline NonHandledINTCException          ;Vec 718, EMIOS_GFR[F24,F25]
  ISRline NonHandledINTCException          ;Vec 719, EMIOS_GFR[F26,F27]  
  ISRline NonHandledINTCException          ;Vec 720, EMIOS_GFR[F28,F29]
  ISRline NonHandledINTCException          ;Vec 721, EMIOS_GFR[F30,F31]
  
                                           ;*** Source of interrupt: eMIOS 1 ***
  ISRline NonHandledINTCException          ;Vec 722, EMIOS_GFR[F32,F33]
  ISRline NonHandledINTCException          ;Vec 723, EMIOS_GFR[F34,F35]
  ISRline NonHandledINTCException          ;Vec 724, EMIOS_GFR[F36,F37]  
  ISRline NonHandledINTCException          ;Vec 725, EMIOS_GFR[F38,F39] 
  ISRline NonHandledINTCException          ;Vec 726, EMIOS_GFR[F40,F41]
  ISRline NonHandledINTCException          ;Vec 727, EMIOS_GFR[F42,F43]  
  ISRline NonHandledINTCException          ;Vec 728, EMIOS_GFR[F44,F45]
  ISRline NonHandledINTCException          ;Vec 729, EMIOS_GFR[F46,F47]
  ISRline NonHandledINTCException          ;Vec 730, EMIOS_GFR[F48,F49]  
  ISRline NonHandledINTCException          ;Vec 731, EMIOS_GFR[F50,F51]
  ISRline NonHandledINTCException          ;Vec 732, EMIOS_GFR[F52,F53]  
  ISRline NonHandledINTCException          ;Vec 733, EMIOS_GFR[F54,F55]
  ISRline NonHandledINTCException          ;Vec 734, EMIOS_GFR[F56,F57]  
  ISRline NonHandledINTCException          ;Vec 735, EMIOS_GFR[F58,F59]
  ISRline NonHandledINTCException          ;Vec 736, EMIOS_GFR[F60,F61]  
  ISRline NonHandledINTCException          ;Vec 737, EMIOS_GFR[F62,F63]
  
                                           ;*** Source of interrupt: eMIOS 2 ***
  ISRline NonHandledINTCException          ;Vec 738, EMIOS_GFR[F64,F65]
  ISRline NonHandledINTCException          ;Vec 739, EMIOS_GFR[F66,F67]  
  ISRline NonHandledINTCException          ;Vec 740, EMIOS_GFR[F68,F69]
  ISRline NonHandledINTCException          ;Vec 741, EMIOS_GFR[F70,F71]  
  ISRline NonHandledINTCException          ;Vec 742, EMIOS_GFR[F72,F73]
  ISRline NonHandledINTCException          ;Vec 743, EMIOS_GFR[F74,F75]  
  ISRline NonHandledINTCException          ;Vec 744, EMIOS_GFR[F76,F77]
  ISRline NonHandledINTCException          ;Vec 745, EMIOS_GFR[F78,F79]
  ISRline NonHandledINTCException          ;Vec 746, EMIOS_GFR[F80,F81]  
  ISRline NonHandledINTCException          ;Vec 747, EMIOS_GFR[F82,F83]
  ISRline NonHandledINTCException          ;Vec 748, EMIOS_GFR[F84,F85]  
  ISRline NonHandledINTCException          ;Vec 749, EMIOS_GFR[F86,F87]
  ISRline NonHandledINTCException          ;Vec 750, EMIOS_GFR[F88,F89]  
  ISRline NonHandledINTCException          ;Vec 751, EMIOS_GFR[F90,F91]
  ISRline NonHandledINTCException          ;Vec 752, EMIOS_GFR[F92,F93]  
  ISRline NonHandledINTCException          ;Vec 753, EMIOS_GFR[F94,F95]

  // interrupt vectors: 754-1023 Reserved  
                           
#pragma endasm

#pragma ghs section rodata=default
      
// ****************************************************************************
// ***************************** Functions ************************************
// ****************************************************************************
       
//default code for unused ISR
void NonHandledINTCException(){
    while(1);
}//NonHandledINTCException
