
MEMORY {
// Memory map for the MPC5748G

// Flash blocks. UTEST starts at 0x00400000.
// First boot header at 0x00f8c000
    flash_rsvd1  : ORIGIN = 0x00400000, LENGTH = 0x00b8c000
    flash_memory : ORIGIN = 0x00f8c000,	LENGTH = 0x005f4000
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0 

// 768K of system SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x100 // reserved for interrupt vectors
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = 768K-0x100
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0
}
DEFAULTS {
    stack_reserve = 32k
    stack_reserve1 = 32k
    stack_reserve2 = 32k
    heap_reserve = 32k
}
//
// Program layout for starting in ROM, copying text and data to RAM,
// and then running out of RAM.
//

SECTIONS
{
//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	            		    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .

    .boottext : {
	  // All .text which is reachable between
	  // _start and __ghs_ind_crt1 needs to be
	  // pulled into .boottext and left
	  // uncompressed.
	  crt0.o(.text, .vletext)
	  libstartup.a(*)(.text, .vletext)
	  libsys.a(ind_crt1.o)(.text, .vletext)
	  libboardinit.a(*)(.text, .vletext)
     }                                                    > dram_memory
    .syscall						: > .
    .text 			        	        : > dram_memory
    .vletext 			        	        : > .
   
    .sdabase 		       		       ALIGN(16): > .
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .ghcovfz 					  CLEAR : > .
    .ghcovcz 					  CLEAR	: > .
    .ghcovdz 					  CLEAR	: > .

    .heap                  ALIGN(16) PAD(heap_reserve)  : > dram_memory
    .stack_core1          ALIGN(16) PAD(stack_reserve1) : > .
    .stack_core2          ALIGN(16) PAD(stack_reserve2) : > .
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// ROM SECTIONS
//

    .boot_header					: > flash_memory
    .ROM.boottext  	                 ROM(.boottext)	: > flash_memory
    .ROM.syscall 	          	 ROM(.syscall)	: > .
    
    .rodata 						: > flash_memory
    .toc 				     SHFLAGS(2)	: > .

    .sdata2 						: > .
    .opd 				     SHFLAGS(2)	: > .

    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	          	   CROM(.sdata)	: > .
    .CROM.data 	          		    CROM(.data) : > .
    .CROM.text  	      		    CROM(.text)	: > .
    .CROM.vletext  	      		 CROM(.vletext)	: > flash_memory

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = ADDR(.boottext);
    __ghs_rambootcodeend    = ENDADDR(.stack);	
    __ghs_rombootcodestart  = ADDR(.ROM.boottext);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

//
// This special symbol marks the the first address executed after the
// ROM to RAM copy is complete.  It is used by the MULTI debugger.
//
    __ghs_after_romcopy = __ghs_ind_crt1;
}
