PRIMARY_SERVICE(service_gatt, gBleSig_GenericAttributeProfile_d)
        CHARACTERISTIC(char_service_changed, gBleSig_GattServiceChanged_d, (gGattCharPropRead_c | gGattCharPropNotify_c) )
            VALUE(value_service_changed, gBleSig_GattServiceChanged_d, (gPermissionNone_c), 4, 0x00, 0x00, 0x00, 0x00)
            CCCD(cccd_service_changed)

PRIMARY_SERVICE(service_gap, gBleSig_GenericAccessProfile_d)
    CHARACTERISTIC(char_device_name, gBleSig_GapDeviceName_d, (gGattCharPropRead_c) )
        VALUE(value_device_name, gBleSig_GapDeviceName_d, (gPermissionFlagReadable_c), 6, "NXP_FD")

PRIMARY_SERVICE_UUID128(service_led_control, uuid_service_led_control)
    CHARACTERISTIC_UUID128(char_led_status, uuid_characteristic_led_status, (gGattCharPropRead_c))
        VALUE_UUID128(value_led_status, uuid_characteristic_led_status, (gPermissionFlagReadable_c), 1, 0x00)
    CHARACTERISTIC_UUID128(char_led_control, uuid_characteristic_led_control, (gGattCharPropWrite_c))
        VALUE_UUID128(value_led_control, uuid_characteristic_led_control, (gPermissionFlagWritable_c), 2, 0x00, 0x00)
          
PRIMARY_SERVICE_UUID128(service_input_report, uuid_service_input_report)
    CHARACTERISTIC_UUID128(char_input_report, uuid_characteristic_input_report, (gGattCharPropRead_c | gGattCharPropNotify_c))
        VALUE_UUID128(value_report, uuid_characteristic_input_report, (gPermissionFlagReadable_c), 1, 0x00)
        CCCD(cccd_input_report)
           
PRIMARY_SERVICE_UUID128(service_buzzer_control, uuid_service_buzzer_control)
    CHARACTERISTIC_UUID128(char_buzzer, uuid_characteristic_buzzer, (gGattCharPropRead_c | gGattCharPropWrite_c))
        VALUE_UUID128(value_buzzer, uuid_characteristic_buzzer, (gPermissionFlagReadable_c | gPermissionFlagWritable_c), 1, 0x00)
          
PRIMARY_SERVICE_UUID128(service_chip_temperature, uuid_service_chip_temperature)
    CHARACTERISTIC(char_temperature, gBleSig_Temperature_d, (gGattCharPropRead_c | gGattCharPropNotify_c))
        VALUE(value_temperature, gBleSig_Temperature_d, (gPermissionFlagReadable_c), 2, 0x00, 0x00)
        CCCD(cccd_temperature)
          
PRIMARY_SERVICE_UUID128(service_potentiometer, uuid_service_potentiometer)
    CHARACTERISTIC_UUID128(char_potentiometer_relative_value, uuid_characteristic_potentiometer_relative_value, (gGattCharPropRead_c | gGattCharPropNotify_c))
        VALUE_UUID128(value_potentiometer_relative_value, uuid_characteristic_potentiometer_relative_value, (gPermissionFlagReadable_c ), 1, 0x00)
        CCCD(cccd_potentiometer)
        DESCRIPTOR(cpfd_potentiometer, gBleSig_CharPresFormatDescriptor_d, (gPermissionFlagReadable_c), 7, gCpfdUnsigned8BitInteger, 0x00, 
                   0xAD/*Unit precentage UUID in Little Endian (Lower byte)*/, 
                   0x27/*Unit precentage UUID in Little Endian (Higher byte)*/, 
                   0x01, 0x00, 0x00)
      
PRIMARY_SERVICE_UUID128(service_accelerometer, uuid_service_accelerometer)
    CHARACTERISTIC_UUID128(char_accelerometer_scale, uuid_characteristic_accelerometer_scale, (gGattCharPropRead_c | gGattCharPropWrite_c))
        VALUE_UUID128(value_accelerometer_scale, uuid_characteristic_accelerometer_scale, (gPermissionFlagReadable_c | gPermissionFlagWritable_c), 1, 0x00)
    CHARACTERISTIC_UUID128(char_accelerometer_readings, uuid_characteristic_accelerometer_readings, (gGattCharPropRead_c | gGattCharPropNotify_c))
        VALUE_UUID128(value_accelerometer_readings, uuid_characteristic_accelerometer_readings, (gPermissionFlagReadable_c), 6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)
        CCCD(cccd_accelerometer_readings)
          
PRIMARY_SERVICE_UUID128(service_compass, uuid_service_compass)
    CHARACTERISTIC_UUID128(char_compass_heading, uuid_characteristic_compass_heading, (gGattCharPropRead_c | gGattCharPropNotify_c))
        VALUE_UUID128(value_compass_heading, uuid_characteristic_compass_heading, (gPermissionFlagReadable_c), 2, 0x00, 0x00)
        CCCD(cccd_compass_heading)
        DESCRIPTOR(cpfd_compass_heading, gBleSig_CharPresFormatDescriptor_d, (gPermissionFlagReadable_c), 7, gCpfdUnsigned16BitInteger, 0x00, 
                   0x63/*Unit plane angle (degree) UUID in Little Endian (Lower byte)*/, 
                   0x27/*Unit plane angle (degree) UUID in Little Endian (Higher byte)*/, 
                   0x01, 0x00, 0x00)
       
PRIMARY_SERVICE_UUID128(service_remote_controller, uuid_service_remote_controller)
    CHARACTERISTIC_UUID128(char_controller_command, uuid_characteristic_controller_command, (gGattCharPropWrite_c))
        VALUE_UUID128(value_controller_command, uuid_characteristic_controller_command, (gPermissionFlagWritable_c), 1, 0x00)
    CHARACTERISTIC_UUID128(char_controller_configuration, uuid_characteristic_controller_configuration, (gGattCharPropRead_c | gGattCharPropWrite_c))
        VALUE_UUID128(value_controller_configuration, uuid_characteristic_controller_configuration, (gPermissionFlagReadable_c | gPermissionFlagWritable_c), 1, 0x00)

PRIMARY_SERVICE(service_device_info, gBleSig_DeviceInformationService_d)
    CHARACTERISTIC(char_manuf_name, gBleSig_ManufacturerNameString_d, (gGattCharPropRead_c) )
        VALUE(value_manuf_name, gBleSig_ManufacturerNameString_d, (gPermissionFlagReadable_c), 17, "NXP Semiconductor")
    CHARACTERISTIC(char_model_no, gBleSig_ModelNumberString_d, (gGattCharPropRead_c) )
        VALUE(value_model_no, gBleSig_ModelNumberString_d, (gPermissionFlagReadable_c), 15, "FRDM-KW40Z Demo")
    CHARACTERISTIC(char_serial_no, gBleSig_SerialNumberString_d, (gGattCharPropRead_c) )
        VALUE(value_serial_no, gBleSig_SerialNumberString_d, (gPermissionFlagReadable_c), 7, "BLESN01")
    CHARACTERISTIC(char_hw_rev, gBleSig_HardwareRevisionString_d, (gGattCharPropRead_c) )
        VALUE(value_hw_rev, gBleSig_HardwareRevisionString_d, (gPermissionFlagReadable_c), sizeof(BOARD_NAME), BOARD_NAME)
    CHARACTERISTIC(char_fw_rev, gBleSig_FirmwareRevisionString_d, (gGattCharPropRead_c) )
        VALUE(value_fw_rev, gBleSig_FirmwareRevisionString_d, (gPermissionFlagReadable_c), 5, "1.1.1")
    CHARACTERISTIC(char_sw_rev, gBleSig_SoftwareRevisionString_d, (gGattCharPropRead_c) )
        VALUE(value_sw_rev, gBleSig_SoftwareRevisionString_d, (gPermissionFlagReadable_c), 5, "1.1.4")
