/*!
* \addtogroup ir_controller
* @{
*******************************************************************************/
/*!
* @file controller_parameter_list.h
*
* @author  
*
* @version 1.0
*
* @date Mar-14-2016
*
* @brief 
*
********************************************************************************
*
* Copyright (c) 2016, Freescale Semiconductor.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _CONTROLLER_PARAMETER_LIST_H_
#define _CONTROLLER_PARAMETER_LIST_H_

/*!
* \defgroup ir_controller_parameters IR Controller Parameters
* @{
*
* This module includes the definition of time parameters and command codes
* for different TVs
*/

/*******************************************************************************
* Header Files
*******************************************************************************/
#include "EmbeddedTypes.h"
#include "ir_controller.h"

/*******************************************************************************
* Type Definitions
*******************************************************************************/
/*!
* @brief TV Controller parameter structure
*/
typedef struct ControllerParameterList{
  ir_controller_parameters_t controllerTimingParameters;        //!< Timing parameters (see @ref ir_controller_parameters_t).
  uint32_t controllerCommands[6];                               /*!< Controller command codes for these functions:
                                                                     1. On/Off
                                                                     2. Mute
                                                                     3. Volume +
                                                                     4. Volume -
                                                                     5. Channel +
                                                                     6. Channel - 
                                                                 @note The command codes must be left-aligned
                                                                */
  uint8_t bitsPerCommand;                                       //!< Size of the command in bytes (see controller specification)
  uint8_t commandRepeatTimes;                                   //!< Number of times a command must be repeated to be valid (see controller specification)
}controller_parameter_list_t;

/*******************************************************************************
* List of controller parameters
*******************************************************************************/
/*!
* @brief List of controller parameters of type @ref controller_parameter_list_t
* supported in this driver.
*/
extern controller_parameter_list_t controllerParameterList [3];

/*!
* @} End of ir_controller_parameters
*/

/*!
* @} End of ir_controller
*/

#endif /*end of _CONTROLLER_PARAMETER_LIST_H_ */