/*!
 * \defgroup led_control LED Control
 * @{
 * This module provides the functions to control the FRDM-KW40Z board LED functionality. The available actions are:
 *
 * - Initialize the LED module
 * - Turn the LEDs On/Off
 * - Toggle the LEDs
 ******************************************************************************/
/*!
* @file led_control.h
*
* @author  
*
* @version 1.0
*
* @date Mar-14-2016
*
* @brief 
*
********************************************************************************
*
* Copyright (c) 2016, Freescale Semiconductor.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _LED_CONTROL_H_
#define _LED_CONTROL_H_

/*************************************************************************************
**************************************************************************************
* Public macros
**************************************************************************************
*************************************************************************************/
#define LED_CONTROL_NUMBER_OF_LEDS       3      /*!< Number of LEDs on the board */

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */


/************************************************************************************
*************************************************************************************
* Type definitions
*************************************************************************************
************************************************************************************/
/*!
 *  Enumeration of all possible return status for the LED Control functions
 */
typedef enum ledControlStatus{
  kStatusOk,                            /*!< No errors */
  kStatusLedNumberOutOfRange,           /*!< LED number is out of range */
  kStatusInvalidCommand,                /*!< Invalid Command */
  kStatusUnexpectedError,               /*!< Unexpected error */
}led_control_status_t;

/*!
 *  Enumeration of all available commands
 */
typedef enum ledControlCommand{
  kLedControlOff,                        /*!< Turn off the LED */
  kLedControlOn,                         /*!< Turn on the LED */
  kLedControlToggle,                     /*!< Toggle the LED */
  kLedControlInvalidCommand              /*!< Invalid command */
}led_control_command_t;

#ifdef __cplusplus
extern "C" {
#endif

/*!*********************************************************************************
 * \brief Initializes all hardware required for the LED control
 * 
 * \param[in]   Void
 *
 * \return      Void
 **********************************************************************************/
void led_control_init (void);

/*!*********************************************************************************
 * \brief Updates the LED with the provided data
 * 
 * \param[in]   ledNumber       The number of LEDs to update
 * \param[in]   command         The action to apply
 *
 * \return      @ref led_control_status_t Error status for the operation.
 **********************************************************************************/
led_control_status_t led_control_update_led (uint8_t ledNumber, led_control_command_t command);


#ifdef __cplusplus
}
#endif 

/*! 
 * @} End of led_control
 */

#endif /* _LED_CONTROL_H_ */

/*! *********************************************************************************
 * @}
 ********************************************************************************** */
