/*!
* \defgroup potentiometer Potentiometer
* @{
* Potentiometer module implements functions to obtain the relative position in
* a scale from 0% to 100% 
******************************************************************************/
/*!
* @file potentiometer_driver.h
*
* @author  
*
* @version 1.0
*
* @date Apr-01-2016
*
* @brief Driver for Potentiometer interface
*
********************************************************************************
*
* Copyright (c) 2016, Freescale Semiconductor.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _POTENTIOMETER_DRIVER_H_
#define _POTENTIOMETER_DRIVER_H_

/******************************************************************************
* Header files
******************************************************************************/
// Stack header files
#include "EmbeddedTypes.h"

/******************************************************************************
* User definitions
*******************************************************************************/
#define POTENTIOMETER_ADC_INSTANCE         0            //!< ADC instance for the potentiometer input
#define POTENTIOMETER_ADC_RESOLUTION       32767        //!< Expanded ADC resolution (2^n)

/******************************************************************************
* Type definitions
******************************************************************************/

/*! Potentiometer driver status */
typedef enum potentiometerStatus{
  kPotentiometerOk,                                 /*!< No error */
  kPotentiometerInitError,                          /*!< Initialization error */
  kPotentiometerConversionStartError = 0xFFFF,      /*!< Error starting the channel conversion */
}potentiometer_status_t;

/******************************************************************************
* Globals
*******************************************************************************/

/******************************************************************************
* Configuration options
******************************************************************************/

/******************************************************************************
* Public Function prototypes
*******************************************************************************/

/*!***************************************************************************
* \brief        Initializes the Potentiometer driver
*
* \param[in]    None
*
* \return       @ref potentiometer_status_t Error status
****************************************************************************/
potentiometer_status_t potentiometer_init (void);

/*!***************************************************************************
* \brief        Returns the current potentiometer position in percentage
*
* \param[in]    None
*
* \return      Potentiometer position in percentage (from 0 % to 100 %)
****************************************************************************/
uint8_t potentiometer_get_position (void);

/*!
 * @} End of potentiometer
 */


#endif
/* End of file */
