/** ###################################################################
**     Filename    : Events.h
**     Project     : AsMaster
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 10:32, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "AM1.h"
#include "TEST1.h"

void AM1_OnRxChar(void);
/*
** ===================================================================
**     Event       :  AM1_OnRxChar (module Events)
**
**     Component   :  AM1 [AsynchroMaster]
**     Description :
**         This event is called after a correct character is
**         received.
**         The event is available only when the <Interrupt
**         service/event> property is enabled and either the
**         <Receiver> property is enabled or the <SCI output mode>
**         property (if supported) is set to Single-wire mode.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void AM1_OnTxChar(void);
/*
** ===================================================================
**     Event       :  AM1_OnTxChar (module Events)
**
**     Component   :  AM1 [AsynchroMaster]
**     Description :
**         This event is called after a character is transmitted.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void AM1_OnBreak(void);
/*
** ===================================================================
**     Event       :  AM1_OnBreak (module Events)
**
**     Component   :  AM1 [AsynchroMaster]
**     Description :
**         This event is called when a break occurs on the input channel.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/


void AM1_OnError(void);
/*
** ===================================================================
**     Event       :  AM1_OnError (module Events)
**
**     Component   :  AM1 [AsynchroMaster]
**     Description :
**         This event is called when a channel error occurs (except the
**         error returned by a given method). The errors can be read
**         using <GetError> method.
**         The event is available only when the <Interrupt
**         service/event> property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void AM1_OnFreeTxBuf(void);
/*
** ===================================================================
**     Event       :  AM1_OnFreeTxBuf (module Events)
**
**     Component   :  AM1 [AsynchroMaster]
**     Description :
**         This event is called after the last character in output
**         buffer is transmitted.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
