/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : ASl1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroSlave
**     Version     : Component 02.215, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:08, # CodeGen: 17
**     Abstract    :
**         This component "AsynchroSlave" implements SLAVE part of asynchronous
**         serial master-slave communication.
**     Settings    :
**         Asynchro type               : SLAVE
**         Slave ID                    : 1
**
**         Serial channel              : QSCI1
**
**         Protocol
**             Init baud rate          : 9600baud
**             Width                   : 9 bits
**             Stop bits               : 0
**             Parity                  : hardware wake-up
**             Breaks                  : Enabled
**             Input buffer size       : 120
**             Output buffer size      : 12
**
**         Registers
**             Input buffer            : QSCI1_DATA [E094]
**             Output buffer           : QSCI1_DATA [E094]
**             Control register        : QSCI1_CTRL1 [E091]
**             Mode register           : QSCI1_CTRL1 [E091]
**             Baud setting reg.       : QSCI1_RATE [E090]
**
**         Input interrupt
**             Vector name             : INT_QSCI1_RCV
**             Priority                : 1
**
**         Output interrupt
**             Vector name             : INT_QSCI1_TDRE
**             Priority                : 1
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     59               |  GPIOC12/CANRX/SDA1/RXD1
**            Output  |     58               |  GPIOC11/CANTX/SCL1/TXD1
**         ----------------------------------------------------------
**
**     Contents    :
**         RecvChar        - byte ASl1_RecvChar(ASl1_TComData *Chr);
**         SendChar        - byte ASl1_SendChar(ASl1_TComData Chr);
**         RecvBlock       - byte ASl1_RecvBlock(ASl1_TComData *Ptr, word Size, word *Rcv);
**         SendBlock       - byte ASl1_SendBlock(ASl1_TComData *Ptr, word Size, word *Snd);
**         ClearRxBuf      - byte ASl1_ClearRxBuf(void);
**         ClearTxBuf      - byte ASl1_ClearTxBuf(void);
**         GetCharsInRxBuf - word ASl1_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word ASl1_GetCharsInTxBuf(void);
**         GetBreak        - byte ASl1_GetBreak(bool *Brk);
**         SetBreak        - byte ASl1_SetBreak(void);
**         Selected        - byte ASl1_Selected(bool *Sel);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE ASl1. */

#include "ASl1.h"
#include "Events.h"


#define OVERRUN_ERR      0x01U         /* Overrun error flag bit   */
#define FRAMING_ERR      0x02U         /* Framing error flag bit   */
#define PARITY_ERR       0x04U         /* Parity error flag bit    */
#define CHAR_IN_RX       0x08U         /* Char is in RX buffer     */
#define FULL_TX          0x10U         /* Full transmit buffer     */
#define RUNINT_FROM_TX   0x20U         /* Interrupt is in progress */
#define FULL_RX          0x40U         /* Full receive buffer      */
#define NOISE_ERR        0x80U         /* Noise erorr flag bit     */
#define IDLE_ERR         0x0100U       /* Idle character flag bit  */
#define BREAK_ERR        0x0200U       /* Break detect             */
#define COMMON_ERR       0x0400U       /* Common error of RX       */

static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error (not used in this bean) */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Running int from TX */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */
static word ErrFlag;                   /* Error flags mirror of SerFlag */
static word InpLen;                    /* Length of input buffer's content */
static ASl1_TComData *InpPtrR;         /* Pointer for reading from input buffer */
static ASl1_TComData *InpPtrW;         /* Pointer for writing to input buffer */
static ASl1_TComData InpBuffer[ASl1_INP_BUF_SIZE]; /* Input buffer for SCI communication */
static word OutLen;                    /* Length of output bufer's content */
static ASl1_TComData *OutPtrR;         /* Pointer for reading from output buffer */
static ASl1_TComData *OutPtrW;         /* Pointer for writing to output buffer */
static ASl1_TComData OutBuffer[ASl1_OUT_BUF_SIZE]; /* Output buffer for SCI communication */
static byte SelSlave;                  /* Device is selected */

/*
** ===================================================================
**     Method      :  HWEnDi (component AsynchroSlave)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  getReg(QSCI1_STAT);                  /* Reset interrupt request flags */
  setRegBits(QSCI1_CTRL1, (QSCI1_CTRL1_TE_MASK | QSCI1_CTRL1_RE_MASK | QSCI1_CTRL1_RFIE_MASK | QSCI1_CTRL1_REIE_MASK)); /* Enable device */
}

/*
** ===================================================================
**     Method      :  ASl1_RecvChar (component AsynchroSlave)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/
byte ASl1_RecvChar(ASl1_TComData *Chr)
{
  register byte Result = ERR_OK;       /* Return error code */

  if (InpLen > 0x00U) {                /* Is number of received chars greater than 0? */
    EnterCritical();                   /* Disable global interrupts */
    InpLen--;                          /* Decrease number of received chars */
    *Chr = *(InpPtrR++);               /* Received char */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
    if (InpPtrR >= (InpBuffer + ASl1_INP_BUF_SIZE)) { /* Is the pointer out of the receive buffer? */
      InpPtrR = InpBuffer;             /* Set pointer to the first item into the receive buffer */
    }
    /*lint -restore Enable MISRA rule (17.2) checking. */
    ExitCritical();                    /* Enable global interrupts */
  } else {
    return ERR_RXEMPTY;                /* Receiver is empty */
  }
  return Result;                       /* Return error code */
}

/*
** ===================================================================
**     Method      :  ASl1_SendChar (component AsynchroSlave)
**
**     Description :
**         Sends one character to the channel. This method is available
**         only if the transmitter property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
**                           ERR_NOTAVAIL - Slave is not selected yet
** ===================================================================
*/
byte ASl1_SendChar(ASl1_TComData Chr)
{
  if (SelSlave == 0x00U) {
    return ERR_NOTAVAIL;
  }
  if (OutLen == ASl1_OUT_BUF_SIZE) {   /* Is number of chars in buffer is the same as a size of the transmit buffer */
    return ERR_TXFULL;                 /* If yes then error */
  }
  EnterCritical();                     /* Disable global interrupts */
  OutLen++;                            /* Increase number of bytes in the transmit buffer */
  *(OutPtrW++) = Chr;                  /* Store char to buffer */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
  if (OutPtrW >= (OutBuffer + ASl1_OUT_BUF_SIZE)) { /* Is the pointer out of the transmit buffer? */
    OutPtrW = OutBuffer;               /* Set pointer to the first item in the transmit buffer */
  }
    /*lint -restore Enable MISRA rule (17.2) checking. */
  setRegBit(QSCI1_CTRL1, TEIE);        /* Enable transmit interrupt */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_RecvBlock (component AsynchroSlave)
**
**     Description :
**         If any data is received, this method returns the block of
**         the data and its length (and incidental error), otherwise it
**         returns an error code (it does not wait for data).
**         This method is available only if non-zero length of input
**         buffer is defined.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of received data
**         Size            - Size of the block
**       * Rcv             - Pointer to real number of the received data
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - The receive buffer didn't
**                           contain the requested number of data. Only
**                           available data has been returned.
**                           ERR_COMMON - common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/
byte ASl1_RecvBlock(ASl1_TComData *Ptr,word Size,word *Rcv)
{
  register word count;                 /* Number of received chars */
  register byte result = ERR_OK;       /* Last error */

  for (count = 0x00U; count < Size; count++) {
    switch (ASl1_RecvChar(Ptr++)) {    /* Receive data and test the return value*/
    case ERR_RXEMPTY:                  /* No data in the buffer */
      if (result == ERR_OK) {          /* If no receiver error reported */
        result = ERR_RXEMPTY;          /* Return info that requested number of data is not available */
      }
     *Rcv = count;                     /* Return number of received chars */
      return result;
    case ERR_COMMON:                   /* Receiver error reported */
      result = ERR_COMMON;             /* Return info that an error was detected */
      break;
    default:
      break;
    }
  }
  *Rcv = count;                        /* Return number of received chars */
  return result;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_SendBlock (component AsynchroSlave)
**
**     Description :
**         Sends a block of characters to the channel.
**         This method is available only if non-zero length of output
**         buffer is defined.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of data to send
**         Size            - Size of the block
**       * Snd             - Pointer to number of data that are sent
**                           (moved to buffer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - It was not possible to send
**                           requested number of bytes
** ===================================================================
*/
byte ASl1_SendBlock(ASl1_TComData *Ptr,word Size,word *Snd)
{
  register word count;                 /* Number of sent chars */
  register byte result = ERR_OK;       /* Last error */
  register ASl1_TComData *tmpPtr = Ptr;

  for (count = 0x00U; count < Size; count++) {
    result = ASl1_SendChar(*tmpPtr++);
    if (result != ERR_OK) {            /* Sending given number of chars */
      *Snd = count;                    /* Return number of sent chars */
      return result;                   /* Return last error */
    }
  }
  *Snd = count;                        /* Return number of sended chars */
  return result;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_ClearRxBuf (component AsynchroSlave)
**
**     Description :
**         Clears the receive buffer.
**         This method is available only if non-zero length of the input
**         buffer is defined and the receiver property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte ASl1_ClearRxBuf(void)
{
  EnterCritical();                     /* Disable global interrupts */
  InpLen = 0x00U;                      /* Set number of chars in the transmit buffer to 0 */
  InpPtrW = InpBuffer;                 /* Set pointers on the first item in the transmit buffer */
  InpPtrR = InpBuffer;
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_ClearTxBuf (component AsynchroSlave)
**
**     Description :
**         Clears the transmit buffer.
**         This method is available only if non-zero length of output
**         buffer is defined.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte ASl1_ClearTxBuf(void)
{
  EnterCritical();                     /* Disable global interrupts */
  OutLen = 0x00U;                      /* Set number of chars in the receive buffer to 0 */
  OutPtrW = OutBuffer;                 /* Set pointers on the first item in the receive buffer */
  OutPtrR = OutBuffer;
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_GetCharsInRxBuf (component AsynchroSlave)
**
**     Description :
**         Returns the number of characters in the input buffer if the
**         Interrupt service is enabled. In pooling mode this method
**         returns true when a character is received, therefore the
**         RecvChar method should be called subsequently (see the
**         typical usage example).
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/
word ASl1_GetCharsInRxBuf(void)
{
  return InpLen;                       /* Return number of chars in receive buffer */
}

/*
** ===================================================================
**     Method      :  ASl1_GetCharsInTxBuf (component AsynchroSlave)
**
**     Description :
**         Returns the number of characters in the output buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/
word ASl1_GetCharsInTxBuf(void)
{
  return OutLen;                       /* Return number of chars in the transmitter buffer */
}

/*
** ===================================================================
**     Method      :  ASl1_GetBreak (component AsynchroSlave)
**
**     Description :
**         Tests the internal input break flag, returns it (whether the
**         break has occurred or not) and clears it. This method is
**         available only if property <Break signal> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Brk             - Pointer to the returned internal break flag
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte ASl1_GetBreak(bool *Brk)
{
  EnterCritical();                     /* Disable global interrupts */
  *Brk = (bool)(((SerFlag & BREAK_ERR) != 0U)? TRUE : FALSE); /* If was break signal? */
  SerFlag &= (word)(~(word)(BREAK_ERR)); /* Reset break signal flag */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_SetBreak (component AsynchroSlave)
**
**     Description :
**         Sends the break sequence to the output line. This method is
**         available only if <Break signal> property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in the active speed mode
**                           ERR_DISABLED - This component is disabled by user
** ===================================================================
*/
byte ASl1_SetBreak(void)
{
  EnterCritical();                     /* Disable global interrupts */
  setRegBit(QSCI1_CTRL1, SBK);         /* Send break signal */
  clrRegBit(QSCI1_CTRL1, SBK);         /* Send break signal */
  OutPtrW = OutBuffer;                 /* Set pointers to first item in the the receive buffer */
  OutPtrR = OutBuffer;
  OutLen = 0x00U;                      /* Set number of chars in the the receive buffer to 0 */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_Selected (component AsynchroSlave)
**
**     Description :
**         Return boolean value if slave is selected or not (if it is
**         not selected, send/received methods return error value).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Sel             - Pointer to boolean flag (is the slave
**                           selected ?)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte ASl1_Selected(bool *Sel)
{
  *Sel = SelSlave;                     /* Result in case that slave is selected */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  ASl1_AsynchroSeSl (component AsynchroSlave)
**
**     Description :
**         Selects or unselects an asynchronous slave device.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_ERROR      0x01U
#define ON_FULL_RX    0x02U
#define ON_RX_CHAR    0x04U
#define ON_SELECT     0x08U
#define ON_UNSELECT   0x10U
static void AsynchroSeSl(byte Num)
{
  if (Num == 0x01U) {                  /* Is Num parametr equal as address of slave? */
    SelSlave = 1U;                     /* Slave is selected */
  } else {
    SelSlave = 0U;                     /* Slave is not selected */
  }
}

/*
** ===================================================================
**     Method      :  ASl1_InterruptRx (component AsynchroSlave)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_ERROR    0x01U
#define ON_FULL_RX  0x02U
#define ON_RX_CHAR  0x04U
#pragma interrupt alignsp saveall
void ASl1_InterruptRx(void)
{
  word OnFlags = 0x00U;                /* Temporary variable for flags */
  register word StatReg = getReg(QSCI1_STAT); /* Read status register */
  register word Data = getReg(QSCI1_DATA); /* Read data from the receiver */

  if((StatReg & (QSCI1_STAT_FE_MASK)) != 0x00U) { /* Is HW framing error detected? */
    return;
  }
  if((StatReg & (QSCI1_STAT_OR_MASK)) != 0x00U) { /* Is HW overrun error detected? */
    setReg(QSCI1_STAT, 0U);            /* Reset error request flags */
    SerFlag |= OVERRUN_ERR;            /* Set flag OVERRUN_ERR */
  }
    if ((Data & 0x0100U) != 0x00U) {
      AsynchroSeSl((ASl1_TComData)(Data & 0xFFU));
    } else {
      if (SelSlave != 0x00U) {
        if (InpLen < ASl1_INP_BUF_SIZE) { /* Is number of bytes in the receive buffer lower than size of buffer? */
          InpLen++;                    /* Increase number of chars in the receive buffer */
          *(InpPtrW++) = (ASl1_TComData)(Data & 0xFFU); /* Save received char to the receive buffer */
          /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
          if (InpPtrW >= (InpBuffer + ASl1_INP_BUF_SIZE)) { /* Is the pointer out of the receive buffer? */
            InpPtrW = InpBuffer;       /* Set pointer on the first item into the receive buffer */
          }
          /*lint -restore Enable MISRA rule (17.2) checking. */
          OnFlags |= ON_RX_CHAR;       /* Set flag "OnRXChar" */
        } else {
          SerFlag |= FULL_RX;          /* If yes then set flag buffer overflow */
        }
      }
    }
  if ((OnFlags & ON_RX_CHAR) != 0x00U) { /* Is OnRxChar flag set? */
    ASl1_OnRxChar();                   /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  ASl1_InterruptTx (component AsynchroSlave)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_FREE_TX  0x01U
#define ON_TX_CHAR  0x02U
#pragma interrupt alignsp saveall
void ASl1_InterruptTx(void)
{
  register word OnFlags = 0x00U;       /* Temporary variable for flags */

  if ((SerFlag & RUNINT_FROM_TX) != 0x00U) { /* Is flag "running int from TX" set? */
    OnFlags |= ON_TX_CHAR;             /* Set flag "OnTxChar" */
  }
  SerFlag &= (word)(~(word)(RUNINT_FROM_TX)); /* Reset flag "running int from TX" */
  if (OutLen > 0x00U) {                /* Is number of bytes in the transmit buffer greater then 0? */
    OutLen--;                          /* Decrease number of chars in the transmit buffer */
    SerFlag |= RUNINT_FROM_TX;         /* Set flag "running int from TX"? */
    getReg(QSCI1_STAT);                /* Reset interrupt request flags */
    QSCI1_DATA = (ASl1_TComData)*(OutPtrR++); /* Store char to transmitter register */
    /*lint -save  -e946 Disable MISRA rule (17.2) checking. */
    if (OutPtrR >= (OutBuffer + ASl1_OUT_BUF_SIZE)) { /* Is the pointer out of the transmit buffer? */
      OutPtrR = OutBuffer;             /* Set pointer on the first item into the transmit buffer */
    }
    /*lint -restore Enable MISRA rule (17.2) checking. */
  } else {
    OnFlags |= ON_FREE_TX;             /* Set flag "OnFreeTxBuf" */
    clrRegBit(QSCI1_CTRL1, TEIE);      /* Disable transmit interrupt */
  }
  if ((OnFlags & ON_TX_CHAR) != 0x00U) { /* Is flag "OnTxChar" set? */
    ASl1_OnTxChar();                   /* If yes then invoke user event */
  }
  if ((OnFlags & ON_FREE_TX) != 0x00U) { /* Is flag "OnFreeTxBuf" set? */
    ASl1_OnFreeTxBuf();                /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  ASl1_InterruptError (component AsynchroSlave)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void ASl1_InterruptError(void)
{
  register word StatReg = getReg(QSCI1_STAT); /* Read status register */
  register word Data = getReg(QSCI1_DATA); /* Read data from the receiver */
  register word OnFlags = 0x00U;       /* Temporary variable for flags */

  setReg(QSCI1_STAT, 0x00U);           /* Reset error request flags */
  if ((StatReg & QSCI1_STAT_OR_MASK) != 0x00U) { /* Is overrun error flag set? */
    OnFlags |= OVERRUN_ERR;            /* If yes then set the flag */
  }
  if ((StatReg & QSCI1_STAT_NF_MASK) != 0x00U) { /* Is noise error flag set? */
    OnFlags |= NOISE_ERR;              /* If yes then set the flag */
  }
  if ((StatReg & QSCI1_STAT_FE_MASK) != 0x00U) { /* Is framing error flag set? */
    if (Data == 0x00U) {               /* When a zero character is received */
      OnFlags |= BREAK_ERR;            /* When a zero character is received and framing error ocurred the break character is received */
    } else {
      OnFlags |= FRAMING_ERR;
    }
  }
  SerFlag |= OnFlags;                  /* Copy flags status to SerFlag status variable */
  ErrFlag |= OnFlags;                  /* Copy flags status to ErrFlag status variable */
  if ((SerFlag & (OVERRUN_ERR|FRAMING_ERR|PARITY_ERR|NOISE_ERR|BREAK_ERR)) != 0x00U) { /* Was any error set? */
    if ((SerFlag & BREAK_ERR) != 0x00U) {
      ASl1_OnBreak();                  /* If yes then invoke user event */
      return;
    }
  }
}

/*
** ===================================================================
**     Method      :  ASl1_Init (component AsynchroSlave)
**
**     Description :
**         Initializes the associated peripheral(s) and internal 
**         variables of the bean. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void ASl1_Init(void)
{
  SelSlave = 0x00U;                    /* Reset all flags */
  SerFlag = 0x00U;
  /* QSCI1_CTRL1: LOOP=1,SWAI=0,RSRC=0,M=1,WAKE=0,POL=0,PE=0,PT=0,TEIE=0,TIIE=0,RFIE=0,REIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  setReg(QSCI1_CTRL1, 0x9000);         /* Set the SCI configuration */
  InpLen = 0x00U;                      /* No char in the receive buffer */
  InpPtrR = InpBuffer;                 /* Set pointer on the first item in the receive buffer */
  InpPtrW = InpBuffer;
  OutLen = 0x00U;                      /* No char in the transmit buffer */
  OutPtrR = OutBuffer;                 /* Set pointer on the first item in the transmit buffer */
  OutPtrW = OutBuffer;
  /* QSCI1_RATE: SBR=0x0516,FRAC_SBR=1 */
  setReg(QSCI1_RATE, 0x28B1);          /* Set prescaler bits */
  HWEnDi();                            /* Enable/disable device according to status flags */
}


/* END ASl1. */


/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
