/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : ASl1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : AsynchroSlave
**     Version     : Component 02.215, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:08, # CodeGen: 17
**     Abstract    :
**         This component "AsynchroSlave" implements SLAVE part of asynchronous
**         serial master-slave communication.
**     Settings    :
**         Asynchro type               : SLAVE
**         Slave ID                    : 1
**
**         Serial channel              : QSCI1
**
**         Protocol
**             Init baud rate          : 9600baud
**             Width                   : 9 bits
**             Stop bits               : 0
**             Parity                  : hardware wake-up
**             Breaks                  : Enabled
**             Input buffer size       : 120
**             Output buffer size      : 12
**
**         Registers
**             Input buffer            : QSCI1_DATA [E094]
**             Output buffer           : QSCI1_DATA [E094]
**             Control register        : QSCI1_CTRL1 [E091]
**             Mode register           : QSCI1_CTRL1 [E091]
**             Baud setting reg.       : QSCI1_RATE [E090]
**
**         Input interrupt
**             Vector name             : INT_QSCI1_RCV
**             Priority                : 1
**
**         Output interrupt
**             Vector name             : INT_QSCI1_TDRE
**             Priority                : 1
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     59               |  GPIOC12/CANRX/SDA1/RXD1
**            Output  |     58               |  GPIOC11/CANTX/SCL1/TXD1
**         ----------------------------------------------------------
**
**     Contents    :
**         RecvChar        - byte ASl1_RecvChar(ASl1_TComData *Chr);
**         SendChar        - byte ASl1_SendChar(ASl1_TComData Chr);
**         RecvBlock       - byte ASl1_RecvBlock(ASl1_TComData *Ptr, word Size, word *Rcv);
**         SendBlock       - byte ASl1_SendBlock(ASl1_TComData *Ptr, word Size, word *Snd);
**         ClearRxBuf      - byte ASl1_ClearRxBuf(void);
**         ClearTxBuf      - byte ASl1_ClearTxBuf(void);
**         GetCharsInRxBuf - word ASl1_GetCharsInRxBuf(void);
**         GetCharsInTxBuf - word ASl1_GetCharsInTxBuf(void);
**         GetBreak        - byte ASl1_GetBreak(bool *Brk);
**         SetBreak        - byte ASl1_SetBreak(void);
**         Selected        - byte ASl1_Selected(bool *Sel);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __ASl1
#define __ASl1

/* MODULE ASl1. */

#include "Cpu.h"


#ifndef __BWUserType_ASl1_TError
#define __BWUserType_ASl1_TError
  typedef union {
    byte err;
    struct {
      /*lint -save  -e46 Disable MISRA rule (6.4) checking. */
      bool OverRun  : 1;               /* Overrun error flag */
      bool Framing  : 1;               /* Framing error flag */
      bool Parity   : 1;               /* Parity error flag */
      bool RxBufOvf : 1;               /* Rx buffer full error flag */
      bool Noise    : 1;               /* Noise error flag */
      bool Break    : 1;               /* Break detect */
      bool LINSync  : 1;               /* LIN synchronization error */
      /*lint -restore Enable MISRA rule (6.4) checking. */
    } errName;
  } ASl1_TError;                       /* Error flags. For languages which don't support bit access is byte access only to error flags possible. */
#endif

#ifndef __BWUserType_ASl1_TComData
#define __BWUserType_ASl1_TComData
  typedef byte ASl1_TComData;          /* User type for communication. Size of this type depends on the communication data witdh. */
#endif

#define ASl1_INP_BUF_SIZE  0x78U       /* Length of the RX buffer */

#define ASl1_OUT_BUF_SIZE  0x0CU       /* Length of the TX buffer */

byte ASl1_RecvChar(ASl1_TComData *Chr);
/*
** ===================================================================
**     Method      :  ASl1_RecvChar (component AsynchroSlave)
**
**     Description :
**         If any data is received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data). This method is enabled only if the receiver property
**         is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence the
**         information about an exception in interrupt mode is returned
**         only if there is a valid character ready to be read.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service> property
**                           is disabled and the <Break signal> property
**                           is enabled)
**                           ERR_COMMON - common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/

byte ASl1_SendChar(ASl1_TComData Chr);
/*
** ===================================================================
**     Method      :  ASl1_SendChar (component AsynchroSlave)
**
**     Description :
**         Sends one character to the channel. This method is available
**         only if the transmitter property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
**                           ERR_NOTAVAIL - Slave is not selected yet
** ===================================================================
*/

byte ASl1_RecvBlock(ASl1_TComData *Ptr,word Size,word *Rcv);
/*
** ===================================================================
**     Method      :  ASl1_RecvBlock (component AsynchroSlave)
**
**     Description :
**         If any data is received, this method returns the block of
**         the data and its length (and incidental error), otherwise it
**         returns an error code (it does not wait for data).
**         This method is available only if non-zero length of input
**         buffer is defined.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of received data
**         Size            - Size of the block
**       * Rcv             - Pointer to real number of the received data
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - The receive buffer didn't
**                           contain the requested number of data. Only
**                           available data has been returned.
**                           ERR_COMMON - common error occurred (the
**                           GetError method can be used for error
**                           specification)
** ===================================================================
*/

byte ASl1_SendBlock(ASl1_TComData *Ptr,word Size,word *Snd);
/*
** ===================================================================
**     Method      :  ASl1_SendBlock (component AsynchroSlave)
**
**     Description :
**         Sends a block of characters to the channel.
**         This method is available only if non-zero length of output
**         buffer is defined.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of data to send
**         Size            - Size of the block
**       * Snd             - Pointer to number of data that are sent
**                           (moved to buffer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - It was not possible to send
**                           requested number of bytes
** ===================================================================
*/

byte ASl1_ClearRxBuf(void);
/*
** ===================================================================
**     Method      :  ASl1_ClearRxBuf (component AsynchroSlave)
**
**     Description :
**         Clears the receive buffer.
**         This method is available only if non-zero length of the input
**         buffer is defined and the receiver property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte ASl1_ClearTxBuf(void);
/*
** ===================================================================
**     Method      :  ASl1_ClearTxBuf (component AsynchroSlave)
**
**     Description :
**         Clears the transmit buffer.
**         This method is available only if non-zero length of output
**         buffer is defined.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

word ASl1_GetCharsInRxBuf(void);
/*
** ===================================================================
**     Method      :  ASl1_GetCharsInRxBuf (component AsynchroSlave)
**
**     Description :
**         Returns the number of characters in the input buffer if the
**         Interrupt service is enabled. In pooling mode this method
**         returns true when a character is received, therefore the
**         RecvChar method should be called subsequently (see the
**         typical usage example).
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the input
**                           buffer.
** ===================================================================
*/

word ASl1_GetCharsInTxBuf(void);
/*
** ===================================================================
**     Method      :  ASl1_GetCharsInTxBuf (component AsynchroSlave)
**
**     Description :
**         Returns the number of characters in the output buffer.
**     Parameters  : None
**     Returns     :
**         ---             - The number of characters in the output
**                           buffer.
** ===================================================================
*/

byte ASl1_GetBreak(bool *Brk);
/*
** ===================================================================
**     Method      :  ASl1_GetBreak (component AsynchroSlave)
**
**     Description :
**         Tests the internal input break flag, returns it (whether the
**         break has occurred or not) and clears it. This method is
**         available only if property <Break signal> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Brk             - Pointer to the returned internal break flag
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte ASl1_SetBreak(void);
/*
** ===================================================================
**     Method      :  ASl1_SetBreak (component AsynchroSlave)
**
**     Description :
**         Sends the break sequence to the output line. This method is
**         available only if <Break signal> property is enabled.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in the active speed mode
**                           ERR_DISABLED - This component is disabled by user
** ===================================================================
*/

byte ASl1_Selected(bool *Sel);
/*
** ===================================================================
**     Method      :  ASl1_Selected (component AsynchroSlave)
**
**     Description :
**         Return boolean value if slave is selected or not (if it is
**         not selected, send/received methods return error value).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Sel             - Pointer to boolean flag (is the slave
**                           selected ?)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

void ASl1_InterruptRx(void);
/*
** ===================================================================
**     Method      :  ASl1_InterruptRx (component AsynchroSlave)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void ASl1_InterruptTx(void);
/*
** ===================================================================
**     Method      :  ASl1_InterruptTx (component AsynchroSlave)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void ASl1_InterruptError(void);
/*
** ===================================================================
**     Method      :  ASl1_InterruptError (component AsynchroSlave)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void ASl1_Init(void);
/*
** ===================================================================
**     Method      :  ASl1_Init (component AsynchroSlave)
**
**     Description :
**         Initializes the associated peripheral(s) and internal 
**         variables of the bean. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/



/* END ASl1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/

#endif /* ifndef __ASl1 */
