/** ###################################################################
**     Filename    : Events.c
**     Project     : AsSlave
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 10:49, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

extern volatile byte OnTxCharNum;
extern volatile byte OnRxCharNum;

/*
** ===================================================================
**     Event       :  ASl1_OnRxChar (module Events)
**
**     Component   :  ASl1 [AsynchroSlave]
**     Description :
**         This event is called after a correct character is
**         received.
**         The event is available only when the <Interrupt
**         service/event> property is enabled and either the
**         <Receiver> property is enabled or the <SCI output mode>
**         property (if supported) is set to Single-wire mode.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void ASl1_OnRxChar(void)
{
  OnRxCharNum++;
}

/*
** ===================================================================
**     Event       :  ASl1_OnTxChar (module Events)
**
**     Component   :  ASl1 [AsynchroSlave]
**     Description :
**         This event is called after a character is transmitted.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void ASl1_OnTxChar(void)
{
  OnTxCharNum++;
}

/*
** ===================================================================
**     Event       :  ASl1_OnBreak (module Events)
**
**     Component   :  ASl1 [AsynchroSlave]
**     Description :
**         This event is called when a break occurs on the input
**         channel.
**         The event is available only when both <Interrupt
**         service/event> and <Break signal> properties are enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void ASl1_OnBreak(void)
{
  /* Write your code here ... */
}

/*
** ===================================================================
**     Event       :  ASl1_OnFreeTxBuf (module Events)
**
**     Component   :  ASl1 [AsynchroSlave]
**     Description :
**         This event is called after the last character in output
**         buffer is transmitted.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void ASl1_OnFreeTxBuf(void)
{
  /* Write your code here ... */
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
