/******************************************************************************
* 
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      GFLIB_AtanYXShiftedAsm.h
*
* @author    r59400
* 
* @version   1.0.10.0
* 
* @date      Jun-9-2009
* 
* @brief     Function AtanYXShifted
*
*           Special Issues: 
*                           The function requires the saturation mode to be set.
*
*******************************************************************************
*
* Function AtanYXShifted.
*
******************************************************************************/
#ifndef _GFLIB_ATANYXSHIFTEDASM_H_
#define _GFLIB_ATANYXSHIFTEDASM_H_

/******************************************************************************
* Includes
******************************************************************************/
#include "56800E_types.h"
#include "GFLIB_AtanYXAsmDef.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define GFLIB_ATANYXSHIFTED_DEFAULT {32767, 32767, 0, 0, 0}

#define GFLIB_AtanYXShiftedAsm(f16ArgY, f16ArgX, pudtAtanYXCoeff)\
           GFLIB_AtanYXShiftedFAsm(f16ArgY, f16ArgX, &gudtAtanYXTabAddr, pudtAtanYXCoeff)

/******************************************************************************
* Types
******************************************************************************/
typedef struct
{
   Frac16       f16Ky;      
   Frac16       f16Kx;      
   Int16        i16Ny;      
   Int16        i16Nx;      
   Frac16       f16ThetaAdj;
}GFLIB_ATANYXSHIFTED_T;

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/
extern asm Frac16 GFLIB_AtanYXShiftedFAsm
(
	register Frac16 f16ValY,
	register Frac16 f16ValX,
	GFLIB_ATANYX_COEFFICIENTS_ADDR_T *pudtAtanYXPoly,
	GFLIB_ATANYXSHIFTED_T *pudtAtanYXCoeff
);

/******************************************************************************
* Inline functions
******************************************************************************/

#endif /* _GFLIB_ATANYXSHIFTEDASM_H_ */

