/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: ADC12_test.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "ADC12_config.h"

/***************************************************************************//*!
*
* @brief   ADC Cyclic Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void ADC12_Init(void)
{
	/* set GPIO_B as ADC inputs */
	SIM_PCE0 |= SIM_PCE0_GPIOB; // Enable GPIOB clock
	GPIOB_PER = GPIOB_PER_PE_0;       // PER Enable for GPIOB 0
	
	SIM_PCE2 |= SIM_PCE2_CYCADC; // enable clock to ADC modules
		
	/* ADC registers */
	ADC12_CTRL1  = ADC12_CTRL1_SMODE_2 | ADC12_CTRL1_SYNC0;   //SMODE - triggered sequential, SYNC0 - enabled
	ADC12_CTRL2  = ADC12_CTRL2_DIV0_2; // Sequential mode; DIV0 = 4 
	ADC12_CLIST1 = 0x0008U; //  SAMPLE0 - ANB0
	ADC12_SDIS   = 0xFFFEU; // enable ADC channel 0 -> ANB0 (pin 33)
	ADC12_PWR 	 = 0x01A0U; // power-up delay set to 26 clocks
	ADC12_PWR2	 = 0x0405U; // ADCA Speed <=10MHz; ADCB Speed<=10MHz; DIV1 = 2

	XBARA_SEL6 = 0x0014U; //trigger signal connected to PWMB0 trigger - XBAR_IN20

}


/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/