/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: PWM_A_config.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "PWM_A_config.h"

/***************************************************************************//*!
*
* @brief   PWMA Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_A_Init(PWMA_REG_UPDATE *ptr)
{
	/* set GPIOE pins 0-5 as PWM_A outputs  */
	SIM_PCE0 	|= SIM_PCE0_GPIOE; // Enable GPIOE clock
	GPIOE_PER 	|= (GPIOE_PER_PE_0 | GPIOE_PER_PE_1 | GPIOE_PER_PE_2 | GPIOE_PER_PE_3 | GPIOE_PER_PE_4 | GPIOE_PER_PE_5); 	// Enabled PWM peripheral on GPIO_E
	
	GPIOE_DDR |= GPIOE_DDR_DD_8 | GPIOE_DDR_DD_9;  //debug pins to check ISR functionality
	
	/* enable PWMA clock to SM0, SM1, SM2 */
	SIM_PCE3 	|= (SIM_PCE3_PWMACH0 | SIM_PCE3_PWMACH1 | SIM_PCE3_PWMACH2); // Enable PWM Module Clock
	
	/***************************************************************************************/
	/* SM0 Module */
	PWMA_SM0CTRL 	= PWMA_SM0CTRL_FULL;  // full reload cycle
	PWMA_SM0CTRL2 	= PWMA_SM0CTRL2_FORCE_SEL_1; // Local Reload signal from this submodule 
	
	/* set 16kHz PWM period --> 62.5us = 10ns * (6249 + 1)   */
	PWMA_SM0INIT = 0; 
	PWMA_SM0VAL0 = 0;	
	PWMA_SM0VAL1 = 6249;  
		
	PWMA_SM0VAL2 = 0; 	 //0% duty cycle
	PWMA_SM0VAL3 = 0;    //0% duty cycle

	PWMA_SM0VAL4 = 0;    //0% duty cycle
	PWMA_SM0VAL5 = 0;    //0% duty cycle
	
	/* dead time = 1us */
	PWMA_SM0DTCNT0 = 100;
	PWMA_SM0DTCNT1 = 100;
	
	/* PWM A output set to low polarity due to MC33937 MOSFET driver inputs */
	PWMA_SM0OCTRL |= PWMA_SM0OCTRL_POLA | PWMA_SM0OCTRL_PWMAFS_0;
	
	/* disable all faults */
	PWMA_SM0DISMAP0 = 0xF011;	// enable FAULT0
	PWMA_SM0DISMAP1 = 0;
	
	/* trigger signal 0 used to synchronize ADC via XBAR */
	PWMA_SM0TCTRL |= PWMA_SM0TCTRL_OUT_TRIG_EN_0;
	
	/***************************************************************************************/	
	/* SM1 Module */
	PWMA_SM1CTRL 	= PWMA_SM1CTRL_FULL;  // full reload cycle
	/* Local Reload signal from this submodule
	 * Clock from SM0
	 * Reload from SM0
	 * Sync from SM0 */
	PWMA_SM1CTRL2 	= PWMA_SM1CTRL2_FORCE_SEL_1 | PWMA_SM1CTRL2_CLK_SEL_1 | PWMA_SM1CTRL2_RELOAD_SEL | PWMA_SM1CTRL2_INIT_SEL_1;  
	
	/* set 16kHz PWM period --> 62.5us = 10ns * (6249 + 1)   */
	PWMA_SM1INIT = 0; 
	PWMA_SM1VAL0 = 0;	
	PWMA_SM1VAL1 = 6249;  
		
	PWMA_SM1VAL2 = 0; 	 //0% duty cycle
	PWMA_SM1VAL3 = 0;    //0% duty cycle

	PWMA_SM1VAL4 = 0;    //0% duty cycle
	PWMA_SM1VAL5 = 0;    //0% duty cycle
		
	/* dead time = 1us */
	PWMA_SM1DTCNT0 = 100;
	PWMA_SM1DTCNT1 = 100;
		
	/* PWM A output set to low polarity due to MC33937 MOSFET driver inputs */
	PWMA_SM1OCTRL |= PWMA_SM1OCTRL_POLA | PWMA_SM1OCTRL_PWMAFS_0;
		
	/* disable all faults */
	PWMA_SM1DISMAP0 = 0xF011;	// enable FAULT0
	PWMA_SM1DISMAP1 = 0;
	
	/***************************************************************************************/	
	/* SM2 Module */
	PWMA_SM2CTRL 	= PWMA_SM2CTRL_FULL;  // full reload cycle
	/* Local Reload signal from this submodule
	 * Clock from SM0
	 * Reload from SM0
	 * Sync from SM0 */
	PWMA_SM2CTRL2 	= PWMA_SM2CTRL2_FORCE_SEL_1 | PWMA_SM2CTRL2_CLK_SEL_1 | PWMA_SM2CTRL2_RELOAD_SEL | PWMA_SM2CTRL2_INIT_SEL_1;  
	
	/* set 16kHz PWM period --> 62.5us = 10ns * (6249 + 1)   */
	PWMA_SM2INIT = 0; 
	PWMA_SM2VAL0 = 0;	
	PWMA_SM2VAL1 = 6249;  
			
	PWMA_SM2VAL2 = 0; 	 //0% duty cycle
	PWMA_SM2VAL3 = 0;    //0% duty cycle

	PWMA_SM2VAL4 = 0;    //0% duty cycle
	PWMA_SM2VAL5 = 0;    //0% duty cycle
			
	/* dead time = 1us */
	PWMA_SM2DTCNT0 = 100;
	PWMA_SM2DTCNT1 = 100;
			
	/* PWM A output set to low polarity due to MC33937 MOSFET driver inputs */
	PWMA_SM2OCTRL |= PWMA_SM1OCTRL_POLA | PWMA_SM2OCTRL_PWMAFS_0;
			
	/* disable all faults */
	PWMA_SM2DISMAP0 = 0xF011;	// enable FAULT0
	PWMA_SM2DISMAP1 = 0;
	
	/***************************************************************************************/	
	/* Master Control Register Setting */	
	PWMA_MCTRL |= PWMA_MCTRL_CLDOK; // Clear LDOK bit 
	PWMA_MCTRL |= PWMA_MCTRL_LDOK; // LDOK
	PWMA_MCTRL |= PWMA_MCTRL_RUN; // Enable clock 
	
	/***************************************************************************************/	
	/* PWM Fault 0 setting */
	SIM_PCE0 |= SIM_PCE0_GPIOC;  // enable GPIO_C clock
	SIM_GPSCL |= SIM_GPSCL_C2_1; // set XB_IN2 on GPIOC_2
	GPIOC_PER |= GPIOC_PER_PE_2; // set GPIOC_2 as peripheral
	XBARA_SEL14 = 0x0200U; 		 // input fault signal XB_IN2 connected to PWMA Fault 0 - XBAR_IN2
	SIM_IPS0 |= SIM_IPS0_PWMAF0; // select XBAR_OUT29 as PWMA_FAULT0 input
	PWMA_FCTRL0 = PWMA_FCTRL0_FLVL_0 | PWMA_FCTRL0_FAUTO_0; //logic 1 indicates fault, automatic clearing
	PWMA_FFILT0 = PWMA_FFILT0_FILT_PER_5; // set input fault filter
	PWMA_FSTS0  = 0x10; // full cycle re-enable
	
	
	
		
}

/***************************************************************************//*!
*
* @brief   PWMA Module Value Register Update
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_A_Update(PWMA_REG_UPDATE *ptr)
{
	/* Module SM0 */
	PWMA_SM0INIT = ptr->SM0.pwmsminit;
	PWMA_SM0VAL1 = ptr->SM0.pwmsmval1;
	PWMA_SM0VAL2 = ptr->SM0.pwmsmval2;
	PWMA_SM0VAL3 = ptr->SM0.pwmsmval3;
	
	/* Module SM1 */
	PWMA_SM1INIT = ptr->SM1.pwmsminit;
	PWMA_SM1VAL1 = ptr->SM1.pwmsmval1;
	PWMA_SM1VAL2 = ptr->SM1.pwmsmval2;
	PWMA_SM1VAL3 = ptr->SM1.pwmsmval3;
	
	/* Module SM1 */
	PWMA_SM2INIT = ptr->SM2.pwmsminit;
	PWMA_SM2VAL1 = ptr->SM2.pwmsmval1;
	PWMA_SM2VAL2 = ptr->SM2.pwmsmval2;
	PWMA_SM2VAL3 = ptr->SM2.pwmsmval3;
	
	/* load new values to PWM registers */
	PWMA_MCTRL |= PWMA_MCTRL_LDOK_0 | PWMA_MCTRL_LDOK_1 | PWMA_MCTRL_LDOK_2; // LDOK
	
}
/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/