/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: Timer_config.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "Timer_config.h"


/***************************************************************************//*!
*
* @brief   Timer A0 and A1 Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void Timer_Init(void)
{
	/* set GPIOC pins 0-2 as TMRA inputs  */
	SIM_PCE0 	|= SIM_PCE0_GPIOC; // Enable GPIOE clock
	GPIOC_PER 	|= (GPIOC_PER_PE_3 | GPIOC_PER_PE_4 | GPIOC_PER_PE_6);	// Enabled TMRA inputs on GPIOC
	
	SIM_PCE0 |= SIM_PCE0_TA0 | SIM_PCE0_TA1 | SIM_PCE0_TA2 | SIM_PCE0_TA3; /* enable clock to all TA */
	
	/***************************************************************************************/
	/* Timer A0 Module */
	/* clock IPB clock / 128, counting mode, count rising edges of primary source, input Pin 0 */
	TMRA_0_CTRL = TMRA_0_CTRL_PCS | TMRA_0_CTRL_CM_0; 
  
	/* capture both edges, enable input edge interrupt */
	TMRA_0_SCTRL = TMRA_0_SCTRL_CAPTURE_MODE | TMRA_0_SCTRL_IEFIE;
  
	/* input filter - 2 timer clocks and 4 consecutive samples */
	TMRA_0_FILT = TMRA_0_FILT_FILT_PER_1 | TMRA_0_FILT_FILT_CNT_0;
	
	/***************************************************************************************/
	/* Timer A1 Module */
	/* clock IPB clock / 128, counting mode, count rising edges of primary source, input pin 1 */
	TMRA_1_CTRL = TMRA_1_CTRL_PCS | TMRA_1_CTRL_CM_0 | TMRA_1_CTRL_SCS_0; 
	 
	/* capture both edges, enable input edge interrupt */
	TMRA_1_SCTRL = TMRA_1_SCTRL_CAPTURE_MODE | TMRA_1_SCTRL_IEFIE;
	 
	/* input filter - 2 timer clocks and 4 consecutive samples */
	TMRA_1_FILT = TMRA_1_FILT_FILT_PER_1 | TMRA_1_FILT_FILT_CNT_0;
	
	/***************************************************************************************/
	/* Timer A2 Module */
	/* clock IPB clock / 128, counting mode, count rising edges of primary source, input pin2 */
	TMRA_2_CTRL = TMRA_2_CTRL_PCS | TMRA_2_CTRL_CM_0 | TMRA_2_CTRL_SCS_1; 
	 
	/* capture both edges, enable input edge interrupt */
	TMRA_2_SCTRL = TMRA_2_SCTRL_CAPTURE_MODE | TMRA_2_SCTRL_IEFIE;
	 
	/* input filter - 2 timer clocks and 4 consecutive samples */
	TMRA_2_FILT = TMRA_2_FILT_FILT_PER_1 | TMRA_2_FILT_FILT_CNT_0;
	
	/***************************************************************************************/
	/* Timer A3 Module */
	/* clock IPB clock / 16, counting mode, count rising edges of primary source, count until compare */
	TMRA_3_CTRL = TMRA_3_CTRL_PCS_2 | TMRA_3_CTRL_PCS_3 | TMRA_3_CTRL_CM_0 | TMRA_3_CTRL_LENGTH; 
		 
	/* timer overflow interrupt */
	TMRA_3_SCTRL =  TMRA_2_SCTRL_TCFIE;
		 
	/* Compare value 6249 -> 1ms */
	TMRA_3_COMP1 = 6249;
	
	/* enable all Timer A channels */
	TMRA_0_ENBL = TMRA_0_ENBL_ENBL;
	
	/* TMRA 0-2 - priority 1, TMRA3 priority 2 */
	//INTC_IPR2 |= INTC_IPR2_TMRA_0_1 | INTC_IPR2_TMRA_1_1 | INTC_IPR2_TMRA_2_1 | INTC_IPR2_TMRA_3;
	INTC_IPR2 |= INTC_IPR2_TMRA_0_1 | INTC_IPR2_TMRA_1_1 | INTC_IPR2_TMRA_2_1 | INTC_IPR2_TMRA_3;

  
}
/* END Timer_Init. */


