/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bit1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : BitIO
**     Version     : Component 02.075, Driver 01.20, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:20, # CodeGen: 10
**     Abstract    :
**         This component "BitIO" implements an one-bit input/output.
**         It uses one bit/pin of a port.
**         Methods of this component are mostly implemented as a macros
**         (if supported by target language and compiler).
**     Settings    :
**         Used pin                    :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       17            |  GPIOA7/ANA7/ANC11
**             ----------------------------------------------------
**
**         Port name                   : GPIOA_Low
**
**         Bit number (in port)        : 7
**         Bit mask of the port        : 0080
**
**         Initial direction           : Input (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0
**         Initial pull option         : off
**
**         Port data register          : GPIOA_DR  [E201]
**         Port control register       : GPIOA_DDR [E202]
**         Port function register      : GPIOA_PER [E203]
**
**         Optimization for            : speed
**     Contents    :
**         SetDir - void Bit1_SetDir(bool Dir);
**         GetVal - bool Bit1_GetVal(void);
**         PutVal - void Bit1_PutVal(bool Val);
**         ClrVal - void Bit1_ClrVal(void);
**         SetVal - void Bit1_SetVal(void);
**         NegVal - void Bit1_NegVal(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __Bit1_H
#define __Bit1_H

/* MODULE Bit1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


#define Bit1_PIN_MASK           ((byte)0x80) /* Pin mask */


/*
** ===================================================================
**     Method      :  Bit1_GetVal (component BitIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pin and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)

** ===================================================================
*/
#define Bit1_GetVal() ((bool)(getRegBits(GPIOA_DR,Bit1_PIN_MASK)))

/*
** ===================================================================
**     Method      :  Bit1_PutVal (component BitIO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val             - Output value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
**     Returns     : Nothing
** ===================================================================
*/
void Bit1_PutVal(bool Val);

/*
** ===================================================================
**     Method      :  Bit1_SetDir (component BitIO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bit1_SetDir(bool Dir);

/*
** ===================================================================
**     Method      :  Bit1_ClrVal (component BitIO)
**
**     Description :
**         This method clears (sets to zero) the output value.
**           a) direction = Input  : sets the output value to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Bit1_ClrVal() ((Shadow_GPIOA_DR &= (word)~(word)Bit1_PIN_MASK), (clrRegBits(GPIOA_DR,Bit1_PIN_MASK)))

/*
** ===================================================================
**     Method      :  Bit1_SetVal (component BitIO)
**
**     Description :
**         This method sets (sets to one) the output value.
**           a) direction = Input  : sets the output value to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Bit1_SetVal() ((Shadow_GPIOA_DR |= Bit1_PIN_MASK), (setRegBits(GPIOA_DR,Bit1_PIN_MASK)))

/*
** ===================================================================
**     Method      :  Bit1_NegVal (component BitIO)
**
**     Description :
**         This method negates (inverts) the output value.
**           a) direction = Input  : inverts the output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Bit1_NegVal() ((Shadow_GPIOA_DR ^= Bit1_PIN_MASK),(changeRegBits(GPIOA_DR,Bit1_PIN_MASK)))


/* END Bit1. */

#endif /* __Bit1_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
