/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bit2.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : BitIO
**     Version     : Component 02.075, Driver 01.20, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:20, # CodeGen: 10
**     Abstract    :
**         This component "BitIO" implements an one-bit input/output.
**         It uses one bit/pin of a port.
**         Methods of this component are mostly implemented as a macros
**         (if supported by target language and compiler).
**     Settings    :
**         Used pin                    :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       27            |  GPIOC5/DACO/XB_IN7
**             ----------------------------------------------------
**
**         Port name                   : GPIOC_Low
**
**         Bit number (in port)        : 5
**         Bit mask of the port        : 0020
**
**         Initial direction           : Input (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0
**         Initial pull option         : off
**
**         Port data register          : GPIOC_DR  [E221]
**         Port control register       : GPIOC_DDR [E222]
**         Port function register      : GPIOC_PER [E223]
**
**         Optimization for            : speed
**     Contents    :
**         SetDir - void Bit2_SetDir(bool Dir);
**         GetVal - bool Bit2_GetVal(void);
**         PutVal - void Bit2_PutVal(bool Val);
**         ClrVal - void Bit2_ClrVal(void);
**         SetVal - void Bit2_SetVal(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Bit2. */

#include "Bit2.h"
/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


/*
** ===================================================================
**     Method      :  Bit2_GetVal (component BitIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pin and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)

** ===================================================================
*/
/*
bool Bit2_GetVal(void)

**  This method is implemented as a macro. See Bit2.h file.  **

*/

/*
** ===================================================================
**     Method      :  Bit2_PutVal (component BitIO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val             - Output value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
**     Returns     : Nothing
** ===================================================================
*/
void Bit2_PutVal(bool Val)
{
  if (Val) {                           /* Is it one to be written? */
    Shadow_GPIOC_DR |= Bit2_PIN_MASK;  /* Set bit in shadow variable */
    setRegBits(GPIOC_DR,Bit2_PIN_MASK); /* Set bit on port */
  }
  else {                               /* Is it zero to be written? */
    Shadow_GPIOC_DR &= (word)~(word)Bit2_PIN_MASK; /* Clear bit in shadow variable */
    clrRegBits(GPIOC_DR,Bit2_PIN_MASK); /* Clear bit on port */
  }
}

/*
** ===================================================================
**     Method      :  Bit2_SetVal (component BitIO)
**
**     Description :
**         This method sets (sets to one) the output value.
**           a) direction = Input  : sets the output value to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Bit2_SetVal(void)

**  This method is implemented as a macro. See Bit2.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bit2_ClrVal (component BitIO)
**
**     Description :
**         This method clears (sets to zero) the output value.
**           a) direction = Input  : sets the output value to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Bit2_ClrVal(void)

**  This method is implemented as a macro. See Bit2.h file.  **
*/

/*
** ===================================================================
**     Method      :  Bit2_SetDir (component BitIO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bit2_SetDir(bool Dir)
{
  if (Dir) {                           /* Is given direction output? */
    setReg(GPIOC_DR,((getReg(GPIOC_DR)) & (word)~(word)Bit2_PIN_MASK) | (Shadow_GPIOC_DR & Bit2_PIN_MASK)); /* Restore correct value of output from shadow variable */
    setRegBits(GPIOC_DDR,Bit2_PIN_MASK); /* Set direction to output */
  }
  else {                               /* Is given direction input? */
    clrRegBits(GPIOC_DDR,Bit2_PIN_MASK); /* Set direction to input */
  }
}

/* END Bit2. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
