/** ###################################################################
**     Filename  : Events.C
**     Processor : 56F82xx
**     Author    : Richy.Ye
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 03/05/2009
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**
**     (c) Copyright UNIS, a.s. 1997-2008
** ###################################################################*/
/* MODULE Events */

#include "Types.h"
//#include "Registers_Nevis.h"
#include "MC56F84789.h"
#include "Cpu.h"
#include "Events.h"


/*
** ===================================================================
**     Method      :  Cpu_Interrupt (bean 56F8023)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{

  setReg16Bits(INTC_CTRL, 0x20);		/*Disable all interrupts*/
  _EntryPoint();		/*Reset program*/

}

/*
** ===================================================================
**     Method      :  TI1_Interrupt (bean TimerInt)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void TI1_Interrupt(void)
{
  clrReg16Bits(TMRA_1_CSCTRL,0x10);    /* Clear interrupt request flag */
  invertReg16Bits(GPIOE_DR,0x01);	/* Toggle GPIOE0 output */	
}


/* END Events */

/*
** ###################################################################
**
**     This file is created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
