/** ###################################################################
**     Filename  : Main.H
**     Processor : 56F82xx
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 03/05/2009
**     Abstract  :
**         This file contains user's declaration for valiables and functions.
**     Settings  :
**     Contents  :
**         No public methods
** ###################################################################*/

#ifndef __Bootloader_cfg_H
#define __Bootloader_cfg_H

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "MC56F84789.h"
#include "Cpu.h"

/* Constant definition*/
// Dynamic or static bootloader
#define DYNAMIC_BOOT
//#define CLOCK_UNTRIMMED
// Selection of Nevis2 derivatives is done in Compiler settings dialog
#if	defined(MC56F8478x) || defined(MC56F8458x)
	// 256KB flash and 32/2 FlexNVM/FlexRAM
	// p-flash/primary flash address range
	#define PFLASH_START_ADDR  			 0				// p-flash/primary flash 
	#define PFLASH_END_ADDR				 0x001FFFFL		// user code end address
	#define PFLASH_ADDR_MASS_ERASE		 PFLASH_START_ADDR
	#define PFLASH_SECTOR_SIZE			 0x400			// 1k words (2K bytes)
	#define NO_PFLASH_PAGES_ERASE  		 ((PFLASH_END_ADDR-PFLASH_START_ADDR+1)/PFLASH_SECTOR_SIZE)	//
	
	// d-flash/secondary flash address range
	#define DFLASH_START_ADDR			 0x68000L
	#define DFLASH_END_ADDR			 	 (0x6B600L-1)  // user code/data end address, refer to LCF definition for user code
	#define DFLASH_ADDR_MASS_ERASE		 DFLASH_START_ADDR
	#define DFLASH_SECTOR_SIZE			 0x200			// 0.5K words (1K bytes)
	#define NO_DFLASH_PAGES_ERASE  		 ((DFLASH_END_ADDR-DFLASH_START_ADDR+1)/DFLASH_SECTOR_SIZE)	//
	
	// Vector table configuration
	#define VBA_BASE_ADDRESS   			 0
	#define INTC_VBA_BITS                13

	// SCI port definition
	#define USE_SCI0
	//#define USE_SCI1
	//#define USE_SCI2

	// UART bitrate
	//#define SCI_BAUDRATE				 9600L
	#define SCI_BAUDRATE				 57600L 
	
	// Bus clock definition
	#define BUS_CLOCK_HZ				 100000000L			// 100MHz
#elif defined(MC56F8476x) || defined(MC56F8456x)
	// 128KB flash and 32/2 FlexNVM/FlexRAM
	// p-flash/primary flash address range
	#define PFLASH_START_ADDR  			 0				// p-flash/primary flash 
	#define PFLASH_END_ADDR				 0x000FFFFL
	#define PFLASH_ADDR_MASS_ERASE		 PFLASH_START_ADDR
	#define PFLASH_SECTOR_SIZE			 0x400			// 1k words (2K bytes)
	#define NO_PFLASH_PAGES_ERASE  		 ((PFLASH_END_ADDR-PFLASH_START_ADDR+1)/PFLASH_SECTOR_SIZE)	//
	
	// d-flash/secondary flash address range
	#define DFLASH_START_ADDR			 0x68000L
	#define DFLASH_END_ADDR			 	 (0x6B600L-1)  // user code/data end address, refer to LCF definition for user code
	#define DFLASH_ADDR_MASS_ERASE		 DFLASH_START_ADDR
	#define DFLASH_SECTOR_SIZE			 0x200			// 0.5K words (1K bytes)
	#define NO_DFLASH_PAGES_ERASE  		 ((DFLASH_END_ADDR-DFLASH_START_ADDR+1)/DFLASH_SECTOR_SIZE)	//
	
	// Vector table configuration
	#define VBA_BASE_ADDRESS   			 0
	#define INTC_VBA_BITS                13
	
	// SCI port definition
	#define USE_SCI0
	// UART bitrate
	#define SCI_BAUDRATE				 9600L
	//#define SCI_BAUDRATE				 115200L 
	
	// Bus clock definition
	#define BUS_CLOCK_HZ				 100000000L			// 100MHz

#elif defined(MC56F8455x)|| defined(MC56F8445x)
	// 96KB flash and 32/2 FlexNVM/FlexRAM
	// p-flash/primary flash address range
	#define PFLASH_START_ADDR  			 0				// p-flash/primary flash 
	#define PFLASH_END_ADDR				 0x000BFFFL
	#define PFLASH_ADDR_MASS_ERASE		 PFLASH_START_ADDR
	#define PFLASH_SECTOR_SIZE			 0x400			// 1k words (2K bytes)
	#define NO_PFLASH_PAGES_ERASE  		 ((PFLASH_END_ADDR-PFLASH_START_ADDR+1)/PFLASH_SECTOR_SIZE)	//
	
	// d-flash/secondary flash address range
	#define DFLASH_START_ADDR			 0x68000L
	#define DFLASH_END_ADDR			 	 (0x6B600L-1)  // user code/data end address, refer to LCF definition for user code
	#define DFLASH_ADDR_MASS_ERASE		 DFLASH_START_ADDR
	#define DFLASH_SECTOR_SIZE			 0x200			// 0.5K words (1K bytes)
	#define NO_DFLASH_PAGES_ERASE  		 ((DFLASH_END_ADDR-DFLASH_START_ADDR+1)/DFLASH_SECTOR_SIZE)	//
	
	// Vector table configuration
	#define VBA_BASE_ADDRESS   			 0
	#define INTC_VBA_BITS                13
	
	// SCI port definition
	#define USE_SCI0
	// UART bitrate
	
	//#define SCI_BAUDRATE				 9600L
	#define SCI_BAUDRATE				 19200L
	
	// Bus clock definition
	#if defined(MC56F8445x)
		#define BUS_CLOCK_HZ				 60000000L			// 60MHz
	#else 
		#define BUS_CLOCK_HZ				 80000000L			// 80MHz
	//	#define BUS_CLOCK_HZ				100000000L			// 80MHz
	#endif

#elif defined(MC56F8454x) || defined(MC56F8444x)
	// 64KB flash and 0 FlexNVM/FlexRAM
	// p-flash/primary flash address range
	#define PFLASH_START_ADDR  			 0				// p-flash/primary flash 
	#define PFLASH_END_ADDR				 0x0075FFL 		//0x0007FFFL // reserve 0xA00 words for bootloader code
	#define PFLASH_ADDR_MASS_ERASE		 PFLASH_START_ADDR
	#define PFLASH_SECTOR_SIZE			 0x400			// 1k words (2K bytes)
	#define NO_PFLASH_PAGES_ERASE  		 ((PFLASH_END_ADDR-PFLASH_START_ADDR+1)/PFLASH_SECTOR_SIZE)	//
	
	// d-flash/secondary flash address range
	#define DFLASH_START_ADDR			 0
	#define DFLASH_END_ADDR			 	 0
	#define DFLASH_ADDR_MASS_ERASE		 0
	#define DFLASH_SECTOR_SIZE			 0			
	#define NO_DFLASH_PAGES_ERASE  		 0	//
	
	// Vector table configuration
	#define VBA_BASE_ADDRESS   			 0
	#define INTC_VBA_BITS                13
	
	// SCI port definition
	#define USE_SCI0
	// UART bitrate
	//#define SCI_BAUDRATE				 9600L
	#define SCI_BAUDRATE				 57600L
	
	// Bus clock definition
	#if defined(MC56F8444x)
		#define BUS_CLOCK_HZ				 60000000L			// 60MHz
	#else 
		#define BUS_CLOCK_HZ				 80000000L			// 80MHz
		//#define BUS_CLOCK_HZ				100000000L			// 100MHz
	#endif
#endif

#endif /* __Bootloader_cfg_H*/
