/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Byte2IO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 11:11, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Byte2IO */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Bt21.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;
  bool Err=FALSE;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Byte2IO test");
  TEST1_testComment(&testRec, "");
  TEST1_testComment(&testRec, "This project tests the basic method of the Byte2IO bean.");

  /* Method SetDir, GetDir */
  Bt21_SetDir(FALSE);                                      /* Set direction of the port (INPUT) */
  if(Bt21_GetDir()!=FALSE) {
    TEST1_testFailed(&testRec, "SetDir or GetDir method");
    Err=TRUE;
  } else {
    Bt21_SetDir(TRUE);                                     /* Set direction of the port (OUTPUT) */
    if(Bt21_GetDir()==FALSE) {
      TEST1_testFailed(&testRec, "SetDir or GetDir method");
      Err=TRUE;
    } else {
      TEST1_testComment(&testRec, "SetDir and GetDir method OK");
    }
  }
  /* If Err=FALSE, test will continue. */
  if(Err==FALSE){
    /* Method SetInput */
    Bt21_SetInput();                                       /* Set direction of the port (INPUT) */
    if(Bt21_GetDir()!=FALSE) {
      TEST1_testFailed(&testRec, "SetInput method");
    } else {
      TEST1_testComment(&testRec, "SetInput method OK");
    }
    /* Method SetOutput */
    Bt21_SetOutput();                                      /* Set direction of the port (OUTPUT) */
    if(Bt21_GetDir()==FALSE) {
      TEST1_testFailed(&testRec, "SetOutput method");
    } else {
      TEST1_testComment(&testRec, "SetOutput method OK");
    }
    /* Method PutVal, GetVal, GetRawVal */
    Bt21_PutVal(0xaaaa);                                   /* Set output to 0xaaaa */
    if((Bt21_GetVal()!=0xaaaa) & (Bt21_GetRawVal()!=0xaaaa)) {
      TEST1_testFailed(&testRec, "PutVal, GetVal or GetRawVal method");
    } else {
      Bt21_PutVal(0x5555);                                 /* Set output to 0x5555 */
      if((Bt21_GetVal()!=0x5555) & (Bt21_GetRawVal()!=0x5555)) {
        TEST1_testFailed(&testRec, "PutVal, GetVal or GetRawVal method");
      } else {
        TEST1_testComment(&testRec, "PutVal, GetVal and GetRawVal method OK");
      }
    }
    /* Method GetBit, PutBit, GetRawBit */
    Bt21_PutBit(0, FALSE);                                 /* Set output pin 0 to Low */
    if((Bt21_GetBit(0)!=FALSE) & (Bt21_GetRawBit(0)!=FALSE)){
      TEST1_testFailed(&testRec, "GetBit, PutBit or GetRawBit method");
      Err=TRUE;
    } else {
      Bt21_PutBit(0, TRUE);                                /* Set output pin 0 to High */
      if((Bt21_GetBit(0)==FALSE) & (Bt21_GetRawBit(0)==FALSE)){
        TEST1_testFailed(&testRec, "GetBit, PutBit or GetRawBit method");
        Err=TRUE;
      } else {
        TEST1_testComment(&testRec, "GetBit, PutBit and GetRawBit method OK");
      }
    }
    if(Err==FALSE){
      /* Method SetBit, ClrBit, NegBit */
      Bt21_PutVal(0);                                      /* Set output pins to Low */
      Bt21_SetBit(15);                                     /* Set output pin 15 to High */
      if(Bt21_GetBit(15)==FALSE) {
        TEST1_testFailed(&testRec, "SetBit method");
      } else {
        TEST1_testComment(&testRec, "SetBit method OK");
        Bt21_ClrBit(15);                                   /* Set output pin 15 to Low */
        if(Bt21_GetBit(15)!=FALSE) {
          TEST1_testFailed(&testRec, "ClrBit method");
        } else {
          TEST1_testComment(&testRec, "ClrBit method OK");
          Bt21_NegBit(15);                                 /* Negate output pin 15 to High */
          if(Bt21_GetBit(15)==FALSE) {
            TEST1_testFailed(&testRec, "NegBit method");
          } else {
            TEST1_testComment(&testRec, "NegBit method OK");
          }
        }
      }
    }
  }
  /* Test end */
  TEST1_testEnd(&testRec);
}


/* END demo_Byte2IO */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
