/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Byte3IO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-21, 11:18, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Byte3IO */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Bt31.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;
  bool Err=FALSE;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Byte3IO test");
  TEST1_testComment(&testRec, "");
  TEST1_testComment(&testRec, "This project tests the basic method of the Byte3IO bean.");

  /* Method SetDir, GetDir */
  Bt31_SetDir(FALSE);                                      /* Set direction of the port (INPUT) */
  if(Bt31_GetDir()!=FALSE) {
    TEST1_testFailed(&testRec, "SetDir or GetDir method");
    Err=TRUE;
  } else {
    Bt31_SetDir(TRUE);                                     /* Set direction of the port (OUTPUT) */
    if(Bt31_GetDir()==FALSE) {
      TEST1_testFailed(&testRec, "SetDir or GetDir method");
      Err=TRUE;
    } else {
      TEST1_testComment(&testRec, "SetDir and GetDir method OK");
    }
  }
  /* If Err=FALSE, test will continue. */
  if(Err==FALSE){
    /* Method SetInput */
    Bt31_SetInput();                                       /* Set direction of the port (INPUT) */
    if(Bt31_GetDir()!=FALSE) {
      TEST1_testFailed(&testRec, "SetInput method");
    } else {
      TEST1_testComment(&testRec, "SetInput method OK");
    }
    /* Method SetOutput */
    Bt31_SetOutput();                                      /* Set direction of the port (OUTPUT) */
    if(Bt31_GetDir()==FALSE) {
      TEST1_testFailed(&testRec, "SetOutput method");
    } else {
      TEST1_testComment(&testRec, "SetOutput method OK");
    }
    /* Method PutVal, GetVal, GetRawVal */
    Bt31_PutVal(0xaaaaaa);                                   /* Set output to 0xaaaa */
    if(((Bt31_GetVal() & 0xffffff)!=0xaaaaaa) & ((Bt31_GetRawVal() & 0xffffff)!=0xaaaaaa)) {
      TEST1_testFailed(&testRec, "PutVal, GetVal or GetRawVal method");
    } else {
      Bt31_PutVal(0x555555);                                 /* Set output to 0x5555 */
      if(((Bt31_GetVal() & 0xffffff)!=0x555555) & ((Bt31_GetRawVal() & 0xffffff)!=0x555555)) {
        TEST1_testFailed(&testRec, "PutVal, GetVal or GetRawVal method");
      } else {
        TEST1_testComment(&testRec, "PutVal, GetVal and GetRawVal method OK");
      }
    }
    /* Method GetBit, PutBit, GetRawBit */
    Bt31_PutBit(0, FALSE);                                 /* Set output pin 0 to Low */
    if((Bt31_GetBit(0)!=FALSE) & (Bt31_GetRawBit(0)!=FALSE)){
      TEST1_testFailed(&testRec, "GetBit, PutBit or GetRawBit method");
      Err=TRUE;
    } else {
      Bt31_PutBit(0, TRUE);                                /* Set output pin 0 to High */
      if((Bt31_GetBit(0)==FALSE) & (Bt31_GetRawBit(0)==FALSE)){
        TEST1_testFailed(&testRec, "GetBit, PutBit or GetRawBit method");
        Err=TRUE;
      } else {
        TEST1_testComment(&testRec, "GetBit, PutBit and GetRawBit method OK");
      }
    }
    if(Err==FALSE){
      /* Method SetBit, ClrBit, NegBit */
      Bt31_PutVal(0);                                      /* Set output pins to Low */
      Bt31_SetBit(23);                                     /* Set output pin 15 to High */
      if(Bt31_GetBit(23)==FALSE) {
        TEST1_testFailed(&testRec, "SetBit method");
      } else {
        TEST1_testComment(&testRec, "SetBit method OK");
        Bt31_ClrBit(23);                                   /* Set output pin 15 to Low */
        if(Bt31_GetBit(23)!=FALSE) {
          TEST1_testFailed(&testRec, "ClrBit method");
        } else {
          TEST1_testComment(&testRec, "ClrBit method OK");
          Bt31_NegBit(23);                                 /* Negate output pin 15 to High */
          if(Bt31_GetBit(23)==FALSE) {
            TEST1_testFailed(&testRec, "NegBit method");
          } else {
            TEST1_testComment(&testRec, "NegBit method OK");
          }
        }
      }
    }
  }
  /* Test end */
  TEST1_testEnd(&testRec);
}


/* END demo_Byte3IO */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
