/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Bt41.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Byte4IO
**     Version     : Component 02.056, Driver 01.20, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:29, # CodeGen: 8
**     Abstract    :
**         This component "Byte4IO" implements a four-byte input/output.
**         It uses four 8-bit ports.
**     Settings    :
**         This component uses four 8-bit ports. Their data registers need not be at
**         neighbouring addresses.
**
**         1st 8-bit port name (LSB)   : GPIOA_Low
**         2nd 8-bit port name         : GPIOB_Low
**         3rd 8-bit port name         : GPIOC_Low
**         4th 8-bit port name (MSB)   : GPIOE_Low
**
**         Initial direction           : Output (direction can be changed)
**         Safe mode                   : yes
**         Initial output value        : 0 = 000000000H
**         Initial pull option         : off
**
**         1st 8-bit data register     : GPIOA_DR  [E201]
**         2nd 8-bit data register     : GPIOB_DR  [E211]
**         3rd 8-bit data register     : GPIOC_DR  [E221]
**         4th 8-bit data register     : GPIOE_DR  [E241]
**         1st 8-bit control register  : GPIOA_DDR [E202]
**         2nd 8-bit control register  : GPIOB_DDR [E212]
**         3rd 8-bit control register  : GPIOC_DDR [E222]
**         4th 8-bit control register  : GPIOE_DDR [E242]
**         1st 8-bit function register : GPIOA_PER [E203]
**         2nd 8-bit function register : GPIOB_PER [E213]
**         3rd 8-bit function register : GPIOC_PER [E223]
**         4th 8-bit function register : GPIOE_PER [E243]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    22   |   GPIOA0/ANA0/CMPA_IN3/CMPC_O
**                    1      |    23   |   GPIOA1/ANA1/CMPA_IN0
**                    2      |    24   |   GPIOA2/ANA2/VREFHA/CMPA_IN1
**                    3      |    25   |   GPIOA3/ANA3/VREFLA/CMPA_IN2
**                    4      |    21   |   GPIOA4/ANA4/ANC8/CMPD_IN0
**                    5      |    20   |   GPIOA5/ANA5/ANC9
**                    6      |    19   |   GPIOA6/ANA6/ANC10
**                    7      |    17   |   GPIOA7/ANA7/ANC11
**                    8      |    33   |   GPIOB0/ANB0/CMPB_IN3
**                    9      |    34   |   GPIOB1/ANB1/CMPB_IN0
**                    10     |    36   |   GPIOB2/ANB2/CMPC_IN3
**                    11     |    42   |   GPIOB3/ANB3/VREFLB/CMPC_IN0
**                    12     |    30   |   GPIOB4/ANB4/ANC12/CMPC_IN1
**                    13     |    29   |   GPIOB5/ANB5/ANC13/CMPC_IN2
**                    14     |    28   |   GPIOB6/ANB6/ANC14/CMPB_IN1
**                    15     |    26   |   GPIOB7/ANB7/ANC15/CMPB_IN2
**                    16     |    3    |   GPIOC0/EXTAL/CLKIN0
**                    17     |    4    |   GPIOC1/XTAL
**                    18     |    5    |   GPIOC2/TXD0/TB0/XB_IN2/CLKO0
**                    19     |    11   |   GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**                    20     |    12   |   GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**                    21     |    27   |   GPIOC5/DACO/XB_IN7
**                    22     |    49   |   GPIOC6/TA2/XB_IN3/CMP_REF
**                    23     |    50   |   GPIOC7/SS0_B/TXD0
**                    24     |    68   |   GPIOE0/PWMA_0B
**                    25     |    69   |   GPIOE1/PWMA_0A
**                    26     |    74   |   GPIOE2/PWMA_1B
**                    27     |    75   |   GPIOE3/PWMA_1A
**                    28     |    82   |   GPIOE4/PWMA_2B/XB_IN2
**                    29     |    83   |   GPIOE5/PWMA_2A/XB_IN3
**                    30     |    84   |   GPIOE6/PWMA_3B/XB_IN4/PWMB_2B
**                    31     |    85   |   GPIOE7/PWMA_3A/XB_IN5/PWMB_2A
**             ----------------------------------------------------
**     Contents    :
**         GetDir    - bool Bt41_GetDir(void);
**         SetDir    - void Bt41_SetDir(bool Dir);
**         SetInput  - void Bt41_SetInput(void);
**         SetOutput - void Bt41_SetOutput(void);
**         GetVal    - dword Bt41_GetVal(void);
**         PutVal    - void Bt41_PutVal(dword Val);
**         GetBit    - bool Bt41_GetBit(byte Bit);
**         PutBit    - void Bt41_PutBit(byte Bit, bool Val);
**         SetBit    - void Bt41_SetBit(byte Bit);
**         ClrBit    - void Bt41_ClrBit(byte Bit);
**         NegBit    - void Bt41_NegBit(byte Bit);
**         GetRawVal - dword Bt41_GetRawVal(void);
**         GetRawBit - bool Bt41_GetRawBit(byte Bit);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __Bt41_H
#define __Bt41_H

/* MODULE Bt41. */

/*Including shared modules, which are used in the whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"


#define Bt41_PORT_0_MASK        ((byte)0xFF) /* Port 0 mask */
#define Bt41_PORT_1_MASK        ((byte)0xFF) /* Port 1 mask */
#define Bt41_PORT_2_MASK        ((byte)0xFF) /* Port 2 mask */
#define Bt41_PORT_3_MASK        ((byte)0xFF) /* Port 3 mask */

/*
** ===================================================================
**     Method      :  Bt41_GetVal (component Byte4IO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 2^32-1)
** ===================================================================
*/
#define Bt41_GetVal() ( \
/*lint -save  -e740 -e931 Disable MISRA rule (1.2) checking. Order of register access is not important for IO access. */\
  ((dword)((getReg(GPIOE_DR)) & Bt41_PORT_3_MASK) << 24) | ((dword)((getReg(GPIOC_DR)) & Bt41_PORT_2_MASK) << 16) | ((dword)((getReg(GPIOB_DR)) & Bt41_PORT_1_MASK) << 8) | (dword)((getReg(GPIOA_DR)) & Bt41_PORT_0_MASK) \
/*lint -restore Enable MISRA rule (1.2) checking. */\
)

/*
** ===================================================================
**     Method      :  Bt41_PutVal (component Byte4IO)
**
**     Description :
**         This method writes the new output value.
**           a) direction = Input  : sets the new output value;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes the value to the
**                                   appropriate pins
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 2^32-1)
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_PutVal(dword Val);

/*
** ===================================================================
**     Method      :  Bt41_GetBit (component Byte4IO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 31)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Bt41_GetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt41_PutBit (component Byte4IO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**           a) direction = Input  : sets the value of the specified
**                                   bit; this operation will be
**                                   shown on output after the
**                                   direction has been switched to
**                                   output (SetDir(TRUE);)
**           b) direction = Output : directly writes the value of the
**                                   bit to the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 31)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_PutBit(byte Bit, bool Val);

/*
** ===================================================================
**     Method      :  Bt41_SetBit (component Byte4IO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**           a) direction = Input  : sets the specified bit to "1";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "1" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_SetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt41_ClrBit (component Byte4IO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**           a) direction = Input  : sets the specified bit to "0";
**                                   this operation will be shown on
**                                   output after the direction has
**                                   beenswitched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly writes "0" to the
**                                   appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_ClrBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt41_NegBit (component Byte4IO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**           a) direction = Input  : inverts the specified bit;
**                                   this operation will be shown on
**                                   output after the direction has
**                                   been switched to output
**                                   (SetDir(TRUE);)
**           b) direction = Output : directly inverts the value
**                                   of the appropriate pin
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_NegBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bt41_SetDir (component Byte4IO)
**
**     Description :
**         This method sets direction of the component.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Dir        - Direction to set (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_SetDir(bool Val);

/*
** ===================================================================
**     Method      :  Bt41_SetInput (component Byte4IO)
**
**     Description :
**         This method sets direction of the component to input.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#define Bt41_SetInput() \
/*lint -save  -e505 -e522 -e961 Disable MISRA rule (14.2,12.1) checking. Order of register access is not important for IO access. */\
( \
  clrRegBits(GPIOA_DDR,Bt41_PORT_0_MASK), /* Set direction to input */ \
  clrRegBits(GPIOB_DDR,Bt41_PORT_1_MASK), /* Set direction to input */ \
  clrRegBits(GPIOC_DDR,Bt41_PORT_2_MASK), /* Set direction to input */ \
  clrRegBits(GPIOE_DDR,Bt41_PORT_3_MASK), /* Set direction to input */ \
  (void)0 \
) 
/*lint -restore Enable MISRA rule (14.2,12.1) checking. */

/*
** ===================================================================
**     Method      :  Bt41_SetOutput (component Byte4IO)
**
**     Description :
**         This method sets direction of the component to output.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bt41_SetOutput(void);

/*
** ===================================================================
**     Method      :  Bt41_GetDir (component Byte4IO)
**
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (FALSE or TRUE)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
#define Bt41_GetDir() ((bool)(getRegBits(GPIOA_DDR,0xFF)))

/*
** ===================================================================
**     Method      :  Bt41_GetRawVal (component Byte4IO)
**
**     Description :
**         Returns the value of the ports. The method uses raw data
**         input register, i.e., a register that always reads back
**         the status of the port regardless of the port direction.
**         The method is available only if raw data input is
**         supported by all selected ports. 
**     Parameters  : None
**     Returns     :
**         ---             - Input value
** ===================================================================
*/
#define Bt41_GetRawVal() (\
/*lint -save  -e740 -e931 Disable MISRA rule (1.2) checking. Order of register access is not important for IO access. */\
  ((dword)((getReg(GPIOE_RAWDATA)) & Bt41_PORT_3_MASK) << 24) | ((dword)((getReg(GPIOC_RAWDATA)) & Bt41_PORT_2_MASK) << 16) | ((dword)((getReg(GPIOB_RAWDATA)) & Bt41_PORT_1_MASK) << 8) | (dword)((getReg(GPIOA_RAWDATA)) & Bt41_PORT_0_MASK) \
/*lint -restore Enable MISRA rule (1.2) checking. */\
)

/*
** ===================================================================
**     Method      :  Bt41_GetRawBit (component Byte4IO)
**
**     Description :
**         Returns the value of the specified bit/pin. The method
**         uses raw data input register, i.e., a register that
**         always reads back the status of the port regardless of
**         the port direction. The method is available only if raw
**         data input is supported by all selected ports. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         Bit             - Bit/pin number to read.
**     Returns     :
**         ---             - Input value. Possible values:
**                           FALSE - logical "0" (Low level)
**                           TRUE - logical "1" (High level)
** ===================================================================
*/
bool Bt41_GetRawBit(byte Bit);

/* END Bt41. */

#endif /* __Bt41_H*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
