/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : CAN1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : FreescaleCAN
**     Version     : Component 02.360, Driver 01.01, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:31, # CodeGen: 20
**     Abstract    :
**         This component "FreescaleCAN" implements a CAN serial channel.
**     Settings    :
**         CAN channel                                     : CAN
**
**           Interrupt service/event                       : Enabled
**             Message buffers interrupt
**               Vector name                               : INT_MB_OR
**               Priority                                  : 1
**             Error interrupt
**               Vector name                               : INT_ERROR
**               Priority                                  : 1
**             Wakeup interrupt
**               Vector name                               : INT_WAKEUP
**               Priority                                  : 1
**             Bus Off interrupt
**               Vector name                               : INT_BUS_OFF
**               Priority                                  : 1
**             Tx warning interrupt
**               Vector name                               : INT_TX_WARN
**               Priority                                  : 1
**             Rx warning interrupt
**               Vector name                               : INT_RX_WARN
**               Priority                                  : 1
**
**          Settings                                       : 
**                Rx pin                                   : GPIOC12/CANRX/SDA1/RXD1
**                Rx pin signal                            : 
**                Tx pin                                   : GPIOC11/CANTX/SCL1/TXD1
**                Tx pin Signal                            : 
**
**            Global Acceptance Mask                       : yes
**            Message buffers                              : 2
**              Buffer0                                    : 
**                Buffer type                              : Transmit
**              Buffer1                                    : 
**                Buffer type                              : Receive
**                  Accept frames                          : Standard
**                  Message ID                             : 1
**                  Invidual Acceptance Mask               : Disabled
**
**            Timer synchronization                        : Disabled
**            Lowest buffer transmitted first              : Lowest ID
**            Debug mode                                   : no
**            Abort Transmission Mode                      : no
**            Remote Request Storing                       : Remote Request Frame is stored
**            Entire Frame Arbitration Field Comparison    : no
**            Self ReceptionEn                             : Enabled
**            Loop Mode                                    : yes
**            Bus-Off Recovery                             : Auto
**            Listen Only Mode                             : no
**            Wakeup                                       : Disabled
**
**         Protocol
**             Propagation segment                         : 0
**             Time segment 1                              : 4
**             Time segment 2                              : 7
**             RSJ                                         : 1
**             Samples per bit                             : One sample
**             Time quanta per bit                         : 15
**             Init baud rate                              : 100 kbit/s
**
**         Initialization
**             Enabled in init. code                       : yes
**             Events enabled in init.                     : yes
**
**         CPU clock/speed selection
**             High speed mode                             : This component enabled
**             Low speed mode                              : This component disabled
**             Slow speed mode                             : This component disabled
**
**     Contents    :
**         SetAcceptanceCode     - byte CAN1_SetAcceptanceCode(byte BufferNum, dword ID);
**         SetAcceptanceMask     - byte CAN1_SetAcceptanceMask(dword Mask);
**         SendFrame             - byte CAN1_SendFrame(byte BufferNum, dword MessageID, byte FrameType, byte...
**         ReadFrame             - byte CAN1_ReadFrame(byte BufferNum, dword *MessageID, byte *FrameType, byte...
**         GetStateTX            - word CAN1_GetStateTX(void);
**         GetStateRX            - word CAN1_GetStateRX(void);
**         SetBufferCode         - byte CAN1_SetBufferCode(byte BufferNum, byte BufferCode);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE CAN1. */

#include "CAN1.h"
#include "Events.h"

typedef dword ADDR_TYPE;

#define CAN_RX_BUFFER_MASK    0x02U    /* Bit mask for message buffers configured as receive */
#define CAN_TX_BUFFER_MASK    0x01U    /* Bit mask for message buffers configured as transmit */

#define CAN_MBUFFERS          0x02U    /* Number of message buffers */
#define CAN_MAXBUFF           (CAN_MBUFFERS-1U) /* Number of message buffers */
#define CAN_MAX_DATA_LEN      8U       /* Max number of data to be sent in one frame */
#define MB_CONTROL_SRR        0x0040U  /* Substitute Remote Request */
#define MB_CONTROL_IDE        0x0020U  /* ID Extended Bit */
#define MB_CONTROL_RTR        0x0010U  /* Remote Transmission Request */
#define MB_CS_CODE_MASK       0x0F00U

typedef struct {                       /* Message buffer structure */
          word TimeStamp;
          word Control;
          dword ID;
          word Data[4];
        } TMsgBuff;                    /* Message buffer structure */

static dword IntFlagReg;               /* Temporary content of the status register */
                                       /* Bits: 0 - Frame is in receive message buffer */
static const ADDR_TYPE MsgBuffer[CAN_MBUFFERS] = {
(ADDR_TYPE)&CAN_CS0,(ADDR_TYPE)&CAN_CS1
};                                     /* Message buffers addresses */

static const byte MbDataIndex[4] = {1U, 0U, 3U, 2U}; /* Message buffers data register indexes */

/*
** ===================================================================
**     Method      :  Idr2Id (component FreescaleCAN)
**
**     Description :
**         Converts value of the IDR register to the message ID. The 
**         method is called automatically as a part of several internal 
**         methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static dword Idr2Id(dword idr, word control)
{
  if((control & MB_CONTROL_IDE) != 0x00U) {
    return (dword)((idr & 0x1FFFFFFFUL) | CAN_EXTENDED_FRAME_ID); /* Extended frame */
  } else {
    return (dword)(idr >> 18);         /* Standard frame */
  }
}

/*
** ===================================================================
**     Method      :  Id2Idr (component FreescaleCAN)
**
**     Description :
**         Converts message ID to the value of the IDR register. The 
**         method is called automatically as a part of several internal 
**         methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static dword Id2Idr(dword id)
{
  if ((id & CAN_EXTENDED_FRAME_ID) != 0x00U) {
    return (dword)(id & 0x1FFFFFFFUL) ; /* Extended frame */
  } else {
    return (dword)((dword)((word)id & 0x7FFU) << 18); /* Standard frame */
  }
}

/*
** ===================================================================
**     Method      :  CAN1_SetAcceptanceCode (component FreescaleCAN)
**
**     Description :
**         Sets the message ID of the given message buffer. Buffer ID
**         is used for message filtering of incoming frames.
**     Parameters  :
**         NAME            - DESCRIPTION
**         BufferNum       - Number of the buffer.
**         ID              - Mask could be 11-bit for standard frame or
**                           29-bit for extended frame
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_VALUE - Some parameter is out of
**                           possible range
** ===================================================================
*/
byte CAN1_SetAcceptanceCode(byte BufferNum, dword ID)
{
  register TMsgBuff *MsgBuff;

  if (BufferNum > CAN_MAXBUFF) {       /* Is BufferNum greater than 2 or Length greater than 8?*/
    return ERR_VALUE;                  /* If yes then error */
  }
  MsgBuff = (TMsgBuff *)MsgBuffer[BufferNum];
  MsgBuff->ID = Id2Idr(ID);            /* Convert ID to the Idr register format, set the ID register */
  if ((ID & CAN_EXTENDED_FRAME_ID) != 0x00U) {
    MsgBuff->Control |= MB_CONTROL_IDE;
  } else {
    MsgBuff->Control &= (word)~((word)MB_CONTROL_IDE);
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  CAN1_SetBufferCode (component FreescaleCAN)
**
**     Description :
**         Sets up the message buffer code for the appropriate message
**         buffer. This method is always enabled because it is used
**         internally.
**     Parameters  :
**         NAME            - DESCRIPTION
**         BufferNum       - Number of the buffer.
**         BufferCode      - Message buffer code for the
**                           appropriate message buffer.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_VALUE - Some parameter is out of
**                           possible range
** ===================================================================
*/
byte CAN1_SetBufferCode(byte BufferNum, byte BufferCode)
{
  if (BufferNum > CAN_MAXBUFF) {       /* Is BufferNum greater than 2 or Length greater than 8?*/
    return ERR_VALUE;                  /* If yes then error */
  }
  ((TMsgBuff *)MsgBuffer[BufferNum])->Control = (word)((((TMsgBuff *)MsgBuffer[BufferNum])->Control & 0xF0FFU) | ((word)BufferCode << 8));
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  CAN1_GetStateRX (component FreescaleCAN)
**
**     Description :
**         Returns the value of the reception complete flags (register
**         FCIFLAG1).
**     Parameters  : None
**     Returns     :
**         ---             - Content of the receiver complete flag
**                           register.
** ===================================================================
*/
word CAN1_GetStateRX(void)
{
  return (word)(IntFlagReg & CAN_RX_BUFFER_MASK); /* Return the interrupt flag mask of the buffers configured as receive */
}

/*
** ===================================================================
**     Method      :  HWEnDi (component FreescaleCAN)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
    clrReg32Bits(CAN_MCR, CAN_MCR_HALT_MASK | CAN_MCR_FRZ_MASK); /* Enable FlexCAN device in normal mode */
    setReg32(CAN_IFLAG1, 0x03U);       /* Reset MB interrupt flags */
    setReg32(CAN_IMASK1, 0x03U);       /* Enable TxRx interrupt for all enabled message buffers */
    setReg32(CAN_ESR1, 0x00030007UL);  /* Reset interrupt flags */
}

/*
** ===================================================================
**     Method      :  CAN1_SendFrame (component FreescaleCAN)
**
**     Description :
**         Sends a frame via the CAN device. Using this method the user
**         can send own message to the CAN bus. This method allows to
**         specify CAN buffer number, message ID, data to be sent,
**         frame type (DATA_FRAME/REMOTE_FRAME) and whether the message
**         will be sent after the request comes.
**     Parameters  :
**         NAME            - DESCRIPTION
**         BufferNum       - Number of the buffer.
**         MessageID       - Identification of the message
**                           - ID. Message ID can be specified in the
**                           STANDARD format (default) or the EXTENDED
**                           format. Extended message ID is specified as
**                           (ID | CAN_EXTENDED_FRAME_ID).
**         FrameType       - Type of frame
**                           DATA_FRAME - data frame
**                           REMOTE_FRAME - remote frame
**         Length          - The length of the frame in bytes (0..
**                           8)
**       * Data            - Pointer to data
**         waitForRTR      - Waits for a remote frame. If
**                           this parameter is <true>, only data from
**                           the message buffer will be transmitted as a
**                           response to a remote frame. If this
**                           parameter is <false>, the buffer transmit
**                           data immediately.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
**                           ERR_VALUE - Some parameter is out of
**                           possible range
**                           ERR_BUSY - Device is busy. The frame can't
**                           be transmitted.
** ===================================================================
*/
byte CAN1_SendFrame(byte BufferNum, dword MessageID, byte FrameType, byte Length,void* Data, bool waitForRTR)
{
  register byte Index, DataIndex = 0x00U, TxCode; /* Temporary variables */
  register byte *ptrDataIn = (byte*)Data; /* Pointer to an user input buffer */
  register TMsgBuff *MsgBuff;
  register dword StatusReg = getReg32(CAN_ESR1); /* Read content of the status register */

  if ((BufferNum > CAN_MAXBUFF) || (Length > CAN_MAX_DATA_LEN)) { /* Is BufferNum greater than CAN_MAXBUFF or Length greater than CAN_MAX_DATA_LEN? */
    return ERR_VALUE;                  /* If yes then error */
  }
  if (FrameType > REMOTE_FRAME) {      /* Is FrameType other than REMOTE_FRAME or DATA_FRAME? */
    return ERR_VALUE;                  /* If yes then error */
  }
  MsgBuff = (TMsgBuff *)MsgBuffer[BufferNum];
  EnterCritical();                     /* Disable global interrupts */
  MsgBuff->Control = (word)(MB_TX_NOT_ACTIVE_MASK); /* Hold inactive Tx buffer, clear SRR, IDE, RTR bits */
  MsgBuff->ID = Id2Idr(MessageID);     /* Convert ID to the Idr register format */
  if ((MessageID & CAN_EXTENDED_FRAME_ID) != 0x00U) { /* Convert and set the ID register, set ID register */
    MsgBuff->Control |= MB_CONTROL_IDE; /* Set ID Extended Bit */
  }
  if (FrameType == DATA_FRAME) {       /* Is it a data frame? */
    for (Index = 0U; Index < (byte)(Length >> 1); Index++) {
      MsgBuff->Data[MbDataIndex[Index]] = (word)(((word)ptrDataIn[DataIndex] << 8) | ptrDataIn[DataIndex + 1U]); /* Store data to the transmit register */
      DataIndex += 0x02U;
    }
    if ((Length & 0x01U) != 0x00U) {   /* Odd number of bytes to send? */
      MsgBuff->Data[MbDataIndex[Index]] = (word)((word)ptrDataIn[DataIndex] << 8);
    }
    if (waitForRTR) {                  /* Send date only if remote frame will be received? */
      TxCode = MB_TX_RESPONSE_FRAME;   /* Set buffer as a response transmit buffer for remote frames? */
    } else {
      TxCode = MB_TX_DATA_FRAME;       /* Set buffer as a transmit buffer always? */
    }
  } else {                             /* Remote frame */
    if ((MessageID & CAN_EXTENDED_FRAME_ID) != 0x00U) { /* Extended frame */
      MsgBuff->Control |= MB_CONTROL_RTR; /* Set the message as a remote frame */
    } else {                           /* Standard frame */
      MsgBuff->Control |= MB_CONTROL_SRR; /* Set the message as a remote frame */
    }
    TxCode = MB_TX_REMOTE_FRAME;
  }
  MsgBuff->Control |= (word)(((word)TxCode << 8) | (Length)); /* Set the length of the message and buffer code*/
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  CAN1_ReadFrame (component FreescaleCAN)
**
**     Description :
**         Reads a frame from the CAN device. The user is informed
**         about CAN reception through OnFullRxBuffer event or
**         GetStateRX method.
**     Parameters  :
**         NAME            - DESCRIPTION
**         BufferNum       - Number of the buffer.
**       * MessageID       - Identification of message
**       * FrameType       - Type of frame
**                           DATA_FRAME - data frame
**                           REMOTE_FRAME - remote frame
**       * FrameFormat     - Format of frame
**                           STANDARD_FORMAT - standard frame 11-bits
**                           EXTENDED_FORMAT - extended frame 29-bits. 
**                           Note: This parameter is obsolete and will
**                           be removed in future releases.
**       * Length          - The length of the frame
**       * Data            - The buffer for received data
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
**                           ERR_BUSY - The receive buffer is busy
** ===================================================================
*/
byte CAN1_ReadFrame(byte BufferNum, dword *MessageID, byte *FrameType, byte *FrameFormat,byte *Length, void* Data)
{
  register word RxCode, tmpControl;    /* Temporary variable */
  register byte Index;
  register byte *ptrDataOut = (byte *)Data; /* Pointer to an output user buffer */
  register TMsgBuff *MsgBuff;
  register dword BufferMask = (0x01UL << BufferNum); /* Temporary variable - bitmask of the requested messge buffer */

  if (BufferNum > CAN_MAXBUFF) {       /* Is the number of the required message buffer out of range?*/
    return ERR_VALUE;                  /* If yes then error */
  }
  MsgBuff = (TMsgBuff *)MsgBuffer[BufferNum];
  tmpControl = MsgBuff->Control;       /* Read the buffer control of the given message buffer */
  RxCode = (word)(tmpControl & 0x0F00U); /* Get the buffer code */
  if (RxCode == MB_RX_BUSY_MASK) {     /* Is the receive buffer busy? */
    return ERR_BUSY;                   /* If yes then error */
  }
  if (RxCode == MB_RX_EMPTY_MASK) {    /* Is the receive buffer empty? */
    getReg32(CAN_TIMER);               /* Dummy read of Free running timer register release buffer lock */
    return ERR_RXEMPTY;                /* If yes then error */
  }
  IntFlagReg &= (dword)~(BufferMask);  /* Reset the interrupt request flag in temp variable */
  EnterCritical();                     /* Disable global interrupts */
  MsgBuff->Control = (MsgBuff->Control & (word)~((word)MB_CS_CODE_MASK)); /* Hold inactive Rx buffer */
  *MessageID = Idr2Id(MsgBuff->ID, tmpControl); /* Convert Idr register to ID */
  if ((tmpControl & MB_CONTROL_IDE) != 0x00U) {
    *FrameFormat = EXTENDED_FORMAT;
    *FrameType = (byte)(((tmpControl & MB_CONTROL_RTR) > 0x00U)? REMOTE_FRAME : DATA_FRAME); /* Result the frame type */
    *MessageID &= ~CAN_EXTENDED_FRAME_ID; /* Remove EXTENDED_FRAME indicator, frame type will be returned in FrameType parameter */
  } else {
    *FrameFormat = STANDARD_FORMAT;
    *FrameType = (byte)(((tmpControl & MB_CONTROL_SRR) > 0x00U)? REMOTE_FRAME : DATA_FRAME); /* Result the frame type */
  }
  *Length = (byte)(tmpControl & 0x0FU); /* Result length of the message */
  if (*FrameType == DATA_FRAME) {      /* Is it "data frame"? */
    for (Index = 0U; Index < (byte)(*Length >> 1); Index++) {
      *ptrDataOut++ = (byte)(MsgBuff->Data[MbDataIndex[Index]] >> 8); /* Store data to the receive user buffer */
      *ptrDataOut++ = (byte)(MsgBuff->Data[MbDataIndex[Index]]);
    }
    if ((*Length & 0x01U) != 0x00U) {
      *ptrDataOut = (byte)(MsgBuff->Data[MbDataIndex[Index]] >> 8);
    }
  }
  MsgBuff->Control = ((word)MB_RX_EMPTY << 0x08U); /* Set the message buffer code*/
  ExitCritical();                      /* Enable global interrupts */
  if (RxCode == MB_RX_OVERRUN_MASK) {  /* Is the overrun flag set? */
    return ERR_OVERRUN;                /* Return error */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  CAN1_GetStateTX (component FreescaleCAN)
**
**     Description :
**         Returns the value of the transmission complete flags
**         (register FCIFLAG1).
**     Parameters  : None
**     Returns     :
**         ---             - Content of the transmitter complete flag
**                           register.
** ===================================================================
*/
word CAN1_GetStateTX(void)
{
  dword tmpIntFlagReg = IntFlagReg;

  IntFlagReg &= (dword)~((dword)CAN_TX_BUFFER_MASK); /* Reset the interrupt request flag in temp variable */
  return (word)(tmpIntFlagReg & CAN_TX_BUFFER_MASK); /* Return the interrupt flag mask of the buffers configured as transmit */
}

/*
** ===================================================================
**     Method      :  CAN1_SetAcceptanceMask (component FreescaleCAN)
**
**     Description :
**         Sets the acceptance mask registers. This method writes an
**         acceptance mask directly to the acceptance mask registers.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Mask            - 11-bit Mask could be selected for a
**                           standard frame or 29-bit for an extended
**                           frame
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - This component is disabled
**                           by user
** ===================================================================
*/
byte CAN1_SetAcceptanceMask(dword Mask)
{
  Mask = Id2Idr(Mask);                 /* Convert ID to the Idr register format */
  EnterCritical();                     /* Disable global interrupts */
  setReg32(CAN_RXMGMASK, Mask);        /* Set the global mask register */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  CAN1_InterruptRxTx (component FreescaleCAN)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void CAN1_InterruptRxTx(void)
{
  dword StatusReg = getReg32(CAN_IFLAG1); /* Read content of the interrupt flags */

  setReg32(CAN_IFLAG1, StatusReg);     /* Clear pending interrupt flags */
  IntFlagReg |= StatusReg;
  if ((StatusReg & CAN_TX_BUFFER_MASK) != 0U) { /* Is any interrupt flag of the buffer configured as transmit set? */
    CAN1_OnFreeTxBuffer((word)(StatusReg & CAN_TX_BUFFER_MASK)); /* If yes then invoke user event */
  }
  if ((StatusReg & CAN_RX_BUFFER_MASK) != 0U) { /* Is any interrupt flag of the buffer configured as receive set? */
    CAN1_OnFullRxBuffer();             /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  CAN1_Init (component FreescaleCAN)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void CAN1_Init(void)
{
  /* CAN_MCR: MDIS=1 */
  setReg32Bits(CAN_MCR, 0x80000000UL); /* Disable CAN module */ 
  /*Bus Clock selected*/
  /* CAN_CTRL1: PRESDIV=0,RJW=0,PSEG1=0,PSEG2=0,BOFFMSK=0,ERRMSK=0,CLKSRC=1,LPB=0,TWRNMSK=0,RWRNMSK=0,??=0,??=0,SMP=0,BOFFREC=0,TSYN=0,LBUF=0,LOM=0,PROPSEG=0 */
  setReg32(CAN_CTRL1, 0x2000UL);        
  /* CAN_MCR: MDIS=0,SOFTRST=1 */
  clrSetReg32Bits(CAN_MCR, 0x80000000UL, 0x02000000UL); /* Soft Reset */ 
  while(getRegBit(CAN_MCR, SOFTRST) == 0U){} /* Wait for Soft reset Acknowledge */
  while(getRegBit(CAN_MCR, FRZACK) == 0U){} /* Wait for entering the freeze mode */
  /* CAN_MCR: WRNEN=1,MAXMB&=~0x0E,MAXMB|=1 */
  clrSetReg32Bits(CAN_MCR, 0x0EUL, 0x00200001UL); /* Module configuration register settings */ 
  /* CAN_CTRL1: PRESDIV|=0x42,RJW|=1,PSEG1|=4,PSEG2=7,LPB=1 */
  setReg32Bits(CAN_CTRL1, 0x42671000UL); /* Set the CTRL1 register */ 
  /* CAN_CTRL2: RRS=1 */
  setReg32Bits(CAN_CTRL2, 0x00020000UL); /* Set the CTRL2 register */ 
  /* CAN_RXMGMASK: MG=0x1FFFFFFF */
  setReg32(CAN_RXMGMASK, 0x1FFFFFFFUL); /* Set the global acceptance mask register for buffers 0-13 */ 
  /* CAN_RX14MASK: RX14M=0x1FFFFFFF */
  setReg32(CAN_RX14MASK, 0x1FFFFFFFUL); /* Set the global acceptance mask register for buffers 14 */ 
  /* CAN_RX15MASK: RX15M=0x1FFFFFFF */
  setReg32(CAN_RX15MASK, 0x1FFFFFFFUL); /* Set the global acceptance mask register for buffers 15 */ 
  /* Initialization of all enabled message buffers */
  /* CAN_CS0: ??=0,??=0,??=0,??=0,CODE=8,??=0,SRR=0,IDE=0,RTR=0,DLC=0,TIME_STAMP=0 */
  setReg32(CAN_CS0, 0x08000000UL);     /* Initialize of the message buffer 0 as a transmit buffer */ 
  /* CAN_ID1: PRIO=0,STD=1,EXT=0 */
  setReg32(CAN_ID1, 0x00040000UL);     /* Set the ID register of the message buffer 1 */ 
  /* CAN_CS1: ??=0,??=0,??=0,??=0,CODE=4,??=0,SRR=0,IDE=0,RTR=0,DLC=0,TIME_STAMP=0 */
  setReg32(CAN_CS1, 0x04000000UL);     /* Initialize of the message buffer 1 as a receive buffer */ 
  HWEnDi();                            /* Enable/disable device according to status flags */
}


/* END CAN1. */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
