/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME:Vectors.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************/

#include "Cpu.h"
#include "Events.h"

extern void _EntryPoint(void);         /* Startup routine */
extern void init_MC56F847xx_ISR_HW_RESET(void);


/* defined ISR  */
extern void TI1_ISR(void);
extern void PDB0_ISR(void);
extern void PWMA_0_Reload_ISR(void);
extern void ADC12_EOS_ISR(void);
extern void PDB0_ISR(void);

volatile asm void _vectboot(void);
#pragma define_section Interrupt_vectorsboot "interrupt_vectorsboot.text"  RX
#pragma section Interrupt_vectorsboot begin
volatile asm void _vectboot(void) {
  JMP  init_MC56F847xx_ISR_HW_RESET                     /* 0x00 Interrupt no. 0 (Used)     - ivINT_HW_Reset */
  JMP  init_MC56F847xx_ISR_HW_RESET                     /* 0x02 Interrupt no. 1 (Used)     - ivINT_COP_Reset  */

}
#pragma section Interrupt_vectorsboot end

volatile asm void _vect(void);
#pragma define_section Interrupt_vectors "interrupt_vectors.text"  RX
#pragma section Interrupt_vectors begin
volatile asm void _vect(void) {

  JMP  init_MC56F847xx_ISR_HW_RESET                     /* 0x00 Interrupt no. 0 (Used)     - ivINT_HW_Reset */
  JMP  init_MC56F847xx_ISR_HW_RESET                     /* 0x02 Interrupt no. 1 (Used)     - ivINT_COP_Reset  */

  JSR  Cpu_Interrupt                   /* 0x04 Interrupt no. 2 (Unused)   - ivINT_Illegalinstruction  */
  JSR  Cpu_Interrupt                   /* 0x06 Interrupt no. 3 (Unused)   - ivINT_SW3  */
  JSR  Cpu_Interrupt                   /* 0x08 Interrupt no. 4 (Unused)   - ivINT_HWStackOverflow  */
  JSR  Cpu_Interrupt                   /* 0x0a Interrupt no. 5 (Unused)   - ivINT_MisalignedLongWordAccess  */
  JSR  Cpu_Interrupt                   /* 0x0c Interrupt no. 6 (Unused)   - ivINT_OnCE_StepCounter  */
  JSR  Cpu_Interrupt                   /* 0x0e Interrupt no. 7 (Unused)   - ivINT_OnCE_BreakpointUnit  */
  JSR  Cpu_Interrupt                   /* 0x10 Interrupt no. 8 (Unused)   - ivINT_OnCE_TraceBuffer  */
  JSR  Cpu_Interrupt                   /* 0x12 Interrupt no. 9 (Unused)   - ivINT_OnCE_TxREmpty  */
  JSR  Cpu_Interrupt                   /* 0x14 Interrupt no. 10 (Unused)  - ivINT_OnCE_RxRFull  */
  JSR  Cpu_Interrupt                   /* 0x16 Interrupt no. 11 (Unused)  - ivINT_Bus_ERR*/
  JSR  Cpu_Interrupt                   /* 0x18 Interrupt no. 12 (Unused)  - ivINT_Rsved  */
  JSR  Cpu_Interrupt                   /* 0x1a Interrupt no. 13 (Unused)  - ivINT_Rsved  */
  JSR  Cpu_Interrupt                   /* 0x1c Interrupt no. 14 (Unused)  - ivINT_Rsved  */
  JSR  Cpu_Interrupt                   /* 0x1e Interrupt no. 15 (Unused)  - ivINT_SW2  */
  JSR  Cpu_Interrupt                   /* 0x20 Interrupt no. 16 (Unused)  - ivINT_SW1  */
  JSR  Cpu_Interrupt                   /* 0x22 Interrupt no. 17 (Unused)  - ivINT_SW0  */
  JSR  Cpu_Interrupt                   /* 0x24 Interrupt no. 18 (Unused)  - ivINT_XBARA  */
  JSR  Cpu_Interrupt                   /* 0x26 Interrupt no. 19 (Unused)  - ivINT_LVI  */
  JSR  Cpu_Interrupt                   /* 0x28 Interrupt no. 20 (Unused)  - ivINT_OCCS  */
  JSR  Cpu_Interrupt                   /* 0x2a Interrupt no. 21 (Unused)  - ivINT_TMRB3  */
  JSR  Cpu_Interrupt                   /* 0x2c Interrupt no. 22 (Unused)  - ivINT_TMRB2  */
  JSR  Cpu_Interrupt                   /* 0x2e Interrupt no. 23 (Unused)  - ivINT_TMRB1  */
  JSR  Cpu_Interrupt                   /* 0x30 Interrupt no. 24 (Unused)  - ivINT_TMRB0  */
  JSR  Cpu_Interrupt                   /* 0x32 Interrupt no. 25 (Unused)  - ivINT_TMRA3  */
  JSR  Cpu_Interrupt                   /* 0x34 Interrupt no. 26 (Unused)  - ivINT_TMRA2  */
  JSR  TI1_ISR                        /* 0x36 Interrupt no. 27 (Unused)  - ivINT_TMRA1  */
  JSR  Cpu_Interrupt                   /* 0x38 Interrupt no. 28 (Unused)  - ivINT_TMRA0  */
  JSR  Cpu_Interrupt                   /* 0x3a Interrupt no. 29 (Unused)  - ivINT_ADC_CC1  */
  JSR  ADC12_EOS_ISR                   /* 0x3c Interrupt no. 30 (Unused)  - ivINT_ADC_CC0  */
  JSR  Cpu_Interrupt                   /* 0x3e Interrupt no. 31 (Unused)  - ivINT_ADC_ERR  */
  JSR  Cpu_Interrupt                   /* 0x40 Interrupt no. 32 (Unused)  - ivINT_ADC_COCO  */
  JSR  Cpu_Interrupt                   /* 0x42 Interrupt no. 33 (Unused)  - ivINT_DMA3  */
  JSR  Cpu_Interrupt                   /* 0x44 Interrupt no. 34 (Unused)  - ivINT_DMA2  */
  JSR  Cpu_Interrupt                   /* 0x46 Interrupt no. 35 (Unused)  - ivINT_DMA1  */
  JSR  Cpu_Interrupt                   /* 0x48 Interrupt no. 36 (Unused)  - ivINT_DMA0  */
  JSR  Cpu_Interrupt                   /* 0x4a Interrupt no. 37 (Unused)  - ivINT_CAN_MB_OR  */
  JSR  Cpu_Interrupt                   /* 0x4c Interrupt no. 38 (Unused)  - ivINT_CAN_BUS_OFF  */
  JSR  Cpu_Interrupt                   /* 0x4e Interrupt no. 39 (Unused)  - ivINT_CAN_ERR  */
  JSR  Cpu_Interrupt                   /* 0x50 Interrupt no. 40 (Unused)  - ivINT_CAN_TXWARN  */
  JSR  Cpu_Interrupt                   /* 0x52 Interrupt no. 41 (Unused)  - ivINT_CAN_RXWARN  */
  JSR  Cpu_Interrupt                   /* 0x54 Interrupt no. 42 (Unused)  - ivINT_CAN_WakeUp  */
  JSR  Cpu_Interrupt                   /* 0x56 Interrupt no. 43 (Unused)  - ivINT_QSCI2_RxError  */
  JSR  Cpu_Interrupt                   /* 0x58 Interrupt no. 44 (Unused)  - ivINT_QSCI2_RxFull  */
  JSR  Cpu_Interrupt                   /* 0x5a Interrupt no. 45 (Unused)  - ivINT_QSCI2_TxIdle  */
  JSR  Cpu_Interrupt                   /* 0x5c Interrupt no. 46 (Unused)  - ivINT_QSCI2_TxEmpty  */
  JSR  Cpu_Interrupt                   /* 0x5e Interrupt no. 47 (Unused)  - ivINT_QSCI1_RxError  */
  JSR  Cpu_Interrupt                   /* 0x60 Interrupt no. 48 (Unused)  - ivINT_QSCI1_RxFull  */
  JSR  Cpu_Interrupt                   /* 0x62 Interrupt no. 49 (Unused)  - ivINT_QSCI1_TxIdle  */
  JSR  Cpu_Interrupt                   /* 0x64 Interrupt no. 50 (Unused)  - ivINT_QSCI1_TxEmpty  */
  JSR  Cpu_Interrupt                   /* 0x66 Interrupt no. 51 (Unused)  - ivINT_QSCI0_RxError  */
  JSR  Cpu_Interrupt                   /* 0x68 Interrupt no. 52 (Unused)  - ivINT_QSCI0_RxFull  */
  JSR  Cpu_Interrupt                   /* 0x6a Interrupt no. 53 (Unused)  - ivINT_QSCI0_TxIdle  */
  JSR  Cpu_Interrupt                   /* 0x6c Interrupt no. 54 (Unused)  - ivINT_QSCI0_TxEmpty  */
  JSR  Cpu_Interrupt                   /* 0x6e Interrupt no. 55 (Unused)  - ivINT_QSPI2_TxEmpty  */
  JSR  Cpu_Interrupt                   /* 0x70 Interrupt no. 56 (Unused)  - ivINT_QSPI2_RxFull  */
  JSR  Cpu_Interrupt                   /* 0x72 Interrupt no. 57 (Unused)  - ivINT_QSPI1_TxEmpty  */
  JSR  Cpu_Interrupt                   /* 0x74 Interrupt no. 58 (Unused)  - ivINT_QSPI1_RxFull  */
  JSR  Cpu_Interrupt                   /* 0x76 Interrupt no. 59 (Unused)  - ivINT_QSPI0_TxEmpty  */
  JSR  Cpu_Interrupt                   /* 0x78 Interrupt no. 60 (Unused)  - ivINT_QSPI0_RxFull  */
  JSR  Cpu_Interrupt                   /* 0x7a Interrupt no. 61 (Unused)  - ivINT_IIC1  */
  JSR  Cpu_Interrupt                   /* 0x7c Interrupt no. 62 (Unused)  - ivINT_IIC0  */
  JSR  Cpu_Interrupt                   /* 0x7e Interrupt no. 63 (Unused)  - ivINT_PWMNS_Fault  */
  JSR  Cpu_Interrupt                   /* 0x80 Interrupt no. 64 (Unused)  - ivINT_PWMNS_RERR  */
  JSR  Cpu_Interrupt                   /* 0x82 Interrupt no. 65 (Unused)  - ivINT_PWMNS_Reload3  */
  JSR  Cpu_Interrupt                   /* 0x84 Interrupt no. 66 (Unused)  - ivINT_PWMNS_CAP3  */
  JSR  Cpu_Interrupt                   /* 0x86 Interrupt no. 67 (Unused)  - ivINT_PWMNS_CMP3  */
  JSR  Cpu_Interrupt                   /* 0x88 Interrupt no. 68 (Unused)  - ivINT_PWMNS_Reload2  */
  JSR  Cpu_Interrupt                   /* 0x8a Interrupt no. 69 (Unused)  - ivINT_PWMNS_CAP2  */
  JSR  Cpu_Interrupt                   /* 0x8c Interrupt no. 70 (Unused)  - ivINT_PWMNS_CMP2  */
  JSR  Cpu_Interrupt                   /* 0x8e Interrupt no. 71 (Unused)  - ivINT_PWMNS_Reload1  */
  JSR  Cpu_Interrupt                   /* 0x90 Interrupt no. 72 (Unused)  - ivINT_PWMNS_CAP1  */
  JSR  Cpu_Interrupt                   /* 0x92 Interrupt no. 73 (Unused)  - ivINT_PWMNS_CMP1  */
  JSR  Cpu_Interrupt                   /* 0x94 Interrupt no. 74 (Unused)  - ivINT_PWMNS_Reload0  */
  JSR  Cpu_Interrupt                   /* 0x96 Interrupt no. 75 (Unused)  - ivINT_PWMNS_CAP0  */
  JSR  Cpu_Interrupt                   /* 0x98 Interrupt no. 76 (Unused)  - ivINT_PWMNS_CMP0  */
  JSR  Cpu_Interrupt                   /* 0x9a Interrupt no. 77 (Unused)  - ivINT_PWMHS_Fault  */
  JSR  Cpu_Interrupt                   /* 0x9c Interrupt no. 78 (Unused)  - ivINT_PWMHS_RERR  */
  JSR  Cpu_Interrupt                   /* 0x9e Interrupt no. 79 (Unused)  - ivINT_PWMHS_Reload3  */
  JSR  Cpu_Interrupt                   /* 0xa0 Interrupt no. 80 (Unused)  - ivINT_PWMHS_CAP3  */
  JSR  Cpu_Interrupt                   /* 0xa2 Interrupt no. 81 (Unused)  - ivINT_PWMHS_CMP3  */
  JSR  Cpu_Interrupt                   /* 0xa4 Interrupt no. 82 (Unused)  - ivINT_PWMHS_Reload2  */
  JSR  Cpu_Interrupt                   /* 0xa6 Interrupt no. 83 (Unused)  - ivINT_PWMHS_CMP2  */
  JSR  Cpu_Interrupt                   /* 0xa8 Interrupt no. 84 (Unused)  - ivINT_PWMHS_Reload1  */
  JSR  Cpu_Interrupt                   /* 0xaa Interrupt no. 85 (Unused)  - ivINT_PWMHS_CMP1  */
  JSR  PWMA_0_Reload_ISR               /* 0xac Interrupt no. 86 (Unused)  - ivINT_PWMHS_Reload0  */
  JSR  Cpu_Interrupt                   /* 0xae Interrupt no. 87 (Unused)  - ivINT_PWMHS_CMP0  */
  JSR  Cpu_Interrupt                   /* 0xb0 Interrupt no. 88 (Unused)  - ivINT_FTFL_RDCOL  */
  JSR  Cpu_Interrupt                   /* 0xb2 Interrupt no. 89 (Unused)  - ivINT_FTFL_CC  */
  JSR  Cpu_Interrupt                   /* 0xb4 Interrupt no. 90 (Unused)  - ivINT_CMP3  */
  JSR  Cpu_Interrupt                   /* 0xb6 Interrupt no. 91 (Unused)  - ivINT_CMP2  */
  JSR  Cpu_Interrupt                   /* 0xb8 Interrupt no. 92 (Unused)  - ivINT_CMP1  */
  JSR  Cpu_Interrupt                   /* 0xba Interrupt no. 93 (Unused)  - ivINT_CMP0  */
  JSR  Cpu_Interrupt                   /* 0xbc Interrupt no. 94 (Unused)  - ivINT_PIT1  */
  JSR  Cpu_Interrupt                   /* 0xbe Interrupt no. 95 (Unused)  - ivINT_PIT0  */
  JSR  Cpu_Interrupt                   /* 0xc0 Interrupt no. 96 (Unused)  - ivINT_PDB1  */
  JSR  PDB0_ISR                        /* 0xc2 Interrupt no. 97 (Unused)  - ivINT_PDB0  */
  JSR  Cpu_Interrupt                   /* 0xc4 Interrupt no. 98 (Unused)  - ivINT_QDC_INDEX ENC */
  JSR  Cpu_Interrupt                   /* 0xc6 Interrupt no. 99 (Unused)  - ivINT_QDC_HOME_DOG ENC*/
  JSR  Cpu_Interrupt                   /* 0xc8 Interrupt no. 100 (Unused) - ivINT_QDC_COMP ENC */
  JSR  Cpu_Interrupt                   /* 0xca Interrupt no. 101 (Unused) - ivINT_GPIOG  */
  JSR  Cpu_Interrupt                   /* 0xcc Interrupt no. 102 (Unused) - ivINT_GPIOF  */
  JSR  Cpu_Interrupt                   /* 0xce Interrupt no. 103 (Unused) - ivINT_GPIOE  */
  JSR  Cpu_Interrupt                   /* 0xd0 Interrupt no. 104 (Unused) - ivINT_GPIOD  */
  JSR  Cpu_Interrupt                   /* 0xd2 Interrupt no. 105 (Unused) - ivINT_GPIOC  */
  JSR  Cpu_Interrupt                   /* 0xd4 Interrupt no. 106 (Unused) - ivINT_GPIOB  */
  JSR  Cpu_Interrupt                   /* 0xd6 Interrupt no. 107 (Unused) - ivINT_GPIOA  */
  JSR  Cpu_Interrupt                   /* 0xd8 Interrupt no. 108 (Unused) - ivINT_COP_INT  */
  JSR  Cpu_Interrupt                   /* 0xda Interrupt no. 109 (Unused) - ivINT_EWM_INT  */
  JSR  Cpu_Interrupt                   /* 0xdc Interrupt no. 110 (Unused) - ivINT_SWILP  */
}
#pragma section Interrupt_vectors end

