/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: PWM_B_Init.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "PWM_B_test.h"

/***************************************************************************//*!
*
* @brief   PWMB Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_B_Init(PWMB_REG_UPDATE *ptr)
{
	/* set GPIOE pins 6&7 as PWMB_2A&B outputs  */
	SIM_PCE0 	|= SIM_PCE0_GPIOE; // Enable GPIOE clock
	GPIOE_PER 	|= (GPIOE_PER_PE_6 | GPIOE_PER_PE_7);   	// Enabled PWM peripheral on GPIO_E
	SIM_GPSEL   |= (SIM_GPSEL_E6_1 | SIM_GPSEL_E7_1);       // enable PWMB 2A&2B channel
	
	/* set GPIOG pins 6&7 as PWMB_2A&B outputs  */
	SIM_PCE0 	|= SIM_PCE0_GPIOG; 							// Enable GPIOG clock
	GPIOG_PER |= (GPIOG_PER_PE_0 | GPIOG_PER_PE_1 | GPIOG_PER_PE_2 | GPIOG_PER_PE_3 ); 		// Enabled PWM peripheral on GPIO_G
	
	/* enable PWM_B clock to SM0, SM1, SM2 */
	SIM_PCE3 	|= (SIM_PCE3_PWMBCH0 | SIM_PCE3_PWMBCH1 | SIM_PCE3_PWMBCH2); // Enable PWM Module Clock
	
	/***************************************************************************************/
	/* SM0 Module */
	PWMB_SM0CTRL 	= PWMB_SM0CTRL_FULL;  // full reload cycle
	PWMB_SM0CTRL2 	= PWMB_SM0CTRL2_FORCE_SEL_1; // Local Reload signal from this submodule 
	
	/* set 10kHz PWM period --> 100us = 10ns * 50000 * 2   */
	PWMB_SM0INIT = -5000; 
	PWMB_SM0VAL0 = 0;	
	PWMB_SM0VAL1 = 4999;  
		
	PWMB_SM0VAL2 = -(PWMB_SM0VAL1>>1); 
	PWMB_SM0VAL3 = PWMB_SM0VAL1>>1; 

	PWMB_SM0VAL4 = 0; 
	PWMB_SM0VAL5 = 0;
	
	/* dead time = 1.5us */
	PWMB_SM0DTCNT0 = 150;
	PWMB_SM0DTCNT1 = 150;
	
	/* disable all faults */
	PWMB_SM0DISMAP0 = 0;
	PWMB_SM0DISMAP1 = 0;
	
	/***************************************************************************************/	
	/* SM1 Module */
	PWMB_SM1CTRL 	= PWMB_SM1CTRL_FULL;  // full reload cycle
	/* Local Reload signal from this submodule
	 * Clock from SM0
	 * Reload from SM0
	 * Sync from SM0 */
	PWMB_SM1CTRL2 	= PWMB_SM1CTRL2_FORCE_SEL_1 | PWMB_SM1CTRL2_CLK_SEL_1 | PWMB_SM1CTRL2_RELOAD_SEL | PWMB_SM1CTRL2_INIT_SEL_1;  
	
	/* set 10kHz PWM period --> 100us = 10ns * 50000 * 2   */
	PWMB_SM1INIT = -5000; 
	PWMB_SM1VAL0 = 0;	
	PWMB_SM1VAL1 = 4999;  
		
	PWMB_SM1VAL2 = -(PWMB_SM1VAL1>>1); 
	PWMB_SM1VAL3 = PWMB_SM1VAL1>>1; 

	PWMB_SM1VAL4 = 0; 
	PWMB_SM1VAL5 = 0;
		
	/* dead time = 1.5us */
	PWMB_SM1DTCNT0 = 150;
	PWMB_SM1DTCNT1 = 150;
		
	/* disable all faults */
	PWMB_SM1DISMAP0 = 0;
	PWMB_SM1DISMAP1 = 0;
	
	/***************************************************************************************/	
	/* SM2 Module */
	PWMB_SM2CTRL 	= PWMB_SM2CTRL_FULL;  // full reload cycle
	/* Local Reload signal from this submodule
	 * Clock from SM0
	 * Reload from SM0
	 * Sync from SM0 */
	PWMB_SM2CTRL2 	= PWMB_SM2CTRL2_FORCE_SEL_1 | PWMB_SM2CTRL2_CLK_SEL_1 | PWMB_SM2CTRL2_RELOAD_SEL | PWMB_SM2CTRL2_INIT_SEL_1;  
	
	/* set 10kHz PWM period --> 100us = 10ns * 50000 * 2   */
	PWMB_SM2INIT = -5000; 
	PWMB_SM2VAL0 = 0;	
	PWMB_SM2VAL1 = 4999;  
		
	PWMB_SM2VAL2 = -(PWMB_SM2VAL1>>1); 
	PWMB_SM2VAL3 = PWMB_SM2VAL1>>1; 

	PWMB_SM2VAL4 = 0; 
	PWMB_SM2VAL5 = 0;
			
	/* dead time = 1.5us */
	PWMB_SM2DTCNT0 = 150;
	PWMB_SM2DTCNT1 = 150;
			
	/* disable all faults */
	PWMB_SM2DISMAP0 = 0;
	PWMB_SM2DISMAP1 = 0;
	
	
	PWMB_OUTEN = (PWMB_OUTEN_PWMA_EN_0 | PWMB_OUTEN_PWMA_EN_1 | PWMB_OUTEN_PWMA_EN_2); // Enable output on PWMB_A0, PWMB_A1, PWMB_A2
	PWMB_OUTEN |= (PWMB_OUTEN_PWMB_EN_0 | PWMB_OUTEN_PWMB_EN_1 | PWMB_OUTEN_PWMB_EN_2); // Enable output on PWMB_B0, PWMB_B1, PWMB_B2
		
	PWMB_MCTRL |= PWMB_MCTRL_CLDOK; // Clear LDOK bit 
	PWMB_MCTRL |= PWMB_MCTRL_LDOK; // LDOK
	PWMB_MCTRL |= PWMB_MCTRL_RUN; // Enable clock 
	
	/* Module SM0 */
	ptr->SM0.pwmsminit = PWMB_SM0INIT;
	ptr->SM0.pwmsmval1 = PWMB_SM0VAL1;
	ptr->SM0.pwmsmval2 = PWMB_SM0VAL2;
	ptr->SM0.pwmsmval3 = PWMB_SM0VAL3;
		
	/* Module SM0 */
	ptr->SM1.pwmsminit = PWMB_SM1INIT;
	ptr->SM1.pwmsmval1 = PWMB_SM1VAL1;
	ptr->SM1.pwmsmval2 = PWMB_SM1VAL2;
	ptr->SM1.pwmsmval3 = PWMB_SM1VAL3;
	
	/* Module SM0 */
	ptr->SM2.pwmsminit = PWMB_SM2INIT;
	ptr->SM2.pwmsmval1 = PWMB_SM2VAL1;
	ptr->SM2.pwmsmval2 = PWMB_SM2VAL2;
	ptr->SM2.pwmsmval3 = PWMB_SM2VAL3;
	
	/* trigger signal 0 used to synchronize ADC via XBAR */
	PWMB_SM0TCTRL |= PWMB_SM0TCTRL_OUT_TRIG_EN_0;
		
}

/***************************************************************************//*!
*
* @brief   PWMB Module Value Register Update
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_B_Update(PWMB_REG_UPDATE *ptr)
{
	/* Module SM0 */
	PWMB_SM0INIT = ptr->SM0.pwmsminit;
	PWMB_SM0VAL1 = ptr->SM0.pwmsmval1;
	PWMB_SM0VAL2 = ptr->SM0.pwmsmval2;
	PWMB_SM0VAL3 = ptr->SM0.pwmsmval3;
	
	/* Module SM1 */
	PWMB_SM1INIT = ptr->SM1.pwmsminit;
	PWMB_SM1VAL1 = ptr->SM1.pwmsmval1;
	PWMB_SM1VAL2 = ptr->SM1.pwmsmval2;
	PWMB_SM1VAL3 = ptr->SM1.pwmsmval3;
	
	/* Module SM1 */
	PWMB_SM2INIT = ptr->SM2.pwmsminit;
	PWMB_SM2VAL1 = ptr->SM2.pwmsmval1;
	PWMB_SM2VAL2 = ptr->SM2.pwmsmval2;
	PWMB_SM2VAL3 = ptr->SM2.pwmsmval3;
	
	/* load new values to PWMB registers */
	PWMB_MCTRL |= PWMB_MCTRL_LDOK_0 | PWMB_MCTRL_LDOK_1 | PWMB_MCTRL_LDOK_2; // LDOK
	
}
/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/