/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: Timer_test.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "Timer_test.h"


/***************************************************************************//*!
*
* @brief   Timer A0 and A1 Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void Timer_Init(void)
{
  SIM_PCE0 |= SIM_PCE0_TA0 | SIM_PCE0_TA1; /* enable clock to TA0 and TA1 */
	
  setReg16(TMRA_0_CTRL,0x1620);         /* Stop all functions of the timer */
  setReg16(TMRA_1_CTRL,0xE820);         /* Set up cascade counter mode */
  setReg16(TMRA_1_SCTRL,0x00);
  setReg16(TMRA_0_SCTRL,0x00);
  setReg16(TMRA_1_CNTR,0x00);           /* Reset counter register */
  setReg16(TMRA_0_CNTR,0x00);
  setReg16(TMRA_1_LOAD,0x00);           /* Reset load register */
  setReg16(TMRA_0_LOAD,0x00);
  setReg16(TMRA_1_COMP1,0x03E8);        /* Set up compare 1 register for 1 second*/
  setReg16(TMRA_1_CMPLD1,0x03E8);
  setReg16(TMRA_0_COMP1,0x30D4);		   /* Set up compare 1 register for 1 millisecond*/
  setReg16(TMRA_0_CMPLD1,0x30D4);
  setReg16(TMRA_1_CSCTRL,0x41);         /* Enable compare 1 interrupt */
  setReg16(TMRA_0_CSCTRL,0x01);
  setReg16(TMRA_0_ENBL,0x03);
  clrSetReg16Bits(TMRA_0_CTRL, 0x0C000, 0x2000);  /* Run timerA0 */
  
#if 1
  clrSetReg16Bits(INTC_IPR2, 0x0010, 0x0020);	/* Set interrupt priority of COMP1 of TMRA1 as level 1 */
#endif
  
}
/* END Timer_Init. */


