/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : DMA.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : DMAChannel
**     Version     : Component 01.069, Driver 01.10, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:34, # CodeGen: 19
**     Abstract    :
**         This bean "DMAChannel" implements DMA channel.

**     Settings    :
**         DMA channel                 : DMA_Channel0
**
**         DMA interrupt
**             Vector name             : INT_DMA0
**             Interrupt priority      : 1
**
**         Source address              : 0
**         Destination address         : 0
**
**         Block length                : 10
**
**     Contents    :
**         SetSourceAddress                 - void DMA_SetSourceAddress(void* addr);
**         SetDestinationAddress            - void DMA_SetDestinationAddress(void* addr);
**         SetSourcePointerMode             - byte DMA_SetSourcePointerMode(byte mode);
**         SetDestinationPointerMode        - byte DMA_SetDestinationPointerMode(byte mode);
**         SetSourceTransferWidth           - byte DMA_SetSourceTransferWidth(byte width);
**         SetDestinationTransferWidth      - byte DMA_SetDestinationTransferWidth(byte width);
**         SetSourceCircularBufferSize      - byte DMA_SetSourceCircularBufferSize(word size);
**         GetSourceCircularBufferSize      - word DMA_GetSourceCircularBufferSize(void);
**         SetDestinationCircularBufferSize - byte DMA_SetDestinationCircularBufferSize(word size);
**         GetDestinationCircularBufferSize - word DMA_GetDestinationCircularBufferSize(void);
**         SetDataSize                      - byte DMA_SetDataSize(word size);
**         GetDataSize                      - dword DMA_GetDataSize(void);
**         Start                            - void DMA_Start(void);
**         Stop                             - void DMA_Stop(void);
**         GetStatus                        - byte DMA_GetStatus(void);
**         GetCompleteStatus                - bool DMA_GetCompleteStatus(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE DMA. */

#include "Events.h"
#include "DMA.h"

#define DONE_FLAG                      0x01U
#define ERROR_FLAGS                    0x70U

static word StatusFlags = 0U;          /* DMA channel status flags */
bool DMA_ActiveFlag = FALSE;           /* DMA channel active flag used in GetStatus method */

/*
** ===================================================================
**     Method      :  DMA_SetSourcePointerMode (component DMAChannel)
**
**     Description :
**         Specifies the source address pointer mode. Source address
**         can be incremented, decremented or can stay unchanged at the
**         end of each DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**         mode            - Source pointer mode. 
**                           DONT_CHANGE_POINTER - Don't change pointer
**                           INC_POINTER - Increment pointer
**                           DEC_POINTER - Decrement pointer
**     Returns     :
**         ---             - Error code
** ===================================================================
*/
byte DMA_SetSourcePointerMode(byte mode)
{
  switch (mode) {
    case DMA_DONT_CHANGE_POINTER:
         clrReg32Bit(DMA_DCR0, SINC);
         break;
    case DMA_INC_POINTER:
         setReg32Bit(DMA_DCR0, SINC);
         break;
    default:
         return ERR_VALUE;
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  DMA_SetDestinationPointerMode (component DMAChannel)
**
**     Description :
**         Specifies the destination address pointer mode. Destination
**         address can be incremented, decremented or can stay
**         unchanged at the end of each DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**         mode            - Destination pointer mode. 
**                           DONT_CHANGE_POINTER - Don't change pointer
**                           INC_POINTER - Increment pointer
**                           DEC_POINTER - Decrement pointer
**     Returns     :
**         ---             - Error code
** ===================================================================
*/
byte DMA_SetDestinationPointerMode(byte mode)
{
  switch (mode) {
    case DMA_DONT_CHANGE_POINTER:
         clrReg32Bit(DMA_DCR0, DINC);
         break;
    case DMA_INC_POINTER:
         setReg32Bit(DMA_DCR0, DINC);
         break;
    default:
         return ERR_VALUE;
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  DMA_SetSourceAddress (component DMAChannel)
**
**     Description :
**         Specifies address of the source buffer for DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * addr            - Pointer to the source buffer for DMA
**                           transfer.
**     Returns     : Nothing
** ===================================================================
*/
/*
void DMA_SetSourceAddress(void* addr)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_SetDestinationAddress (component DMAChannel)
**
**     Description :
**         Specifies address of the destination buffer for DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * addr            - Pointer to the destination buffer for
**                           DMA transfer.
**     Returns     : Nothing
** ===================================================================
*/
/*
void DMA_SetDestinationAddress(void* addr)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_SetDataSize (component DMAChannel)
**
**     Description :
**         Specifies the DMA data size - number of data to be
**         transferred.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - Number of bytes to be transferred.
**     Returns     :
**         ---             - Error code
** ===================================================================
*/
/*
byte DMA_SetDataSize(word size)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_Start (component DMAChannel)
**
**     Description :
**         Starts DMA transfer. If Peripheral mapping is used this
**         method enables peripheral requests and transfer starts after
**         peripheral request is asserted.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void DMA_Start(void)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_Stop (component DMAChannel)
**
**     Description :
**         Aborts DMA transfer. If Peripheral mapping is used this
**         method also disables peripheral requests.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void DMA_Stop(void)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_GetStatus (component DMAChannel)
**
**     Description :
**         Returns status of the selected DMA channel.
**     Parameters  : None
**     Returns     :
**         ---             - Status of the selected DMA channel.
**                           Possible values:
**                           DMA_ENABLED - DMA channel is enabled
**                           (active)
**                           DMA_DISABLED - DMA channel is disabled (not
**                           active)
** ===================================================================
*/
byte DMA_GetStatus(void)
{
  /* Was DMA channel activated and is still active? */
  EnterCritical();                     /* Enter the critical section */
  if (((getReg32(DMA_DSR_BCR0) & (DMA_DSR_BCR0_REQ_MASK | DMA_DSR_BCR0_BSY_MASK)) != 0x00U) || DMA_ActiveFlag) {
    ExitCritical();                    /* Exit the critical section */
    return DMA_ENABLED;
  }
  ExitCritical();                      /* Exit the critical section */
  return DMA_DISABLED;
}

/*
** ===================================================================
**     Method      :  DMA_Interrupt (component DMAChannel)
**
**     Description :
**         The method services the transfer complete interrupt of the 
**         selected peripheral(s) and eventually invokes the components 
**         event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void DMA_Interrupt(void)
{
  StatusFlags |= DONE_FLAG;            /* Store DONE flag */
  setReg32Bit(DMA_DSR_BCR0, DONE);     /* Clear status bits */
  DMA_OnComplete();                    /* If yes then invoke user event */
}

/*
** ===================================================================
**     Method      :  DMA_Init (component DMAChannel)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void DMA_Init(void)
{
  /* Disable DMA channel 0 */
  /* DMA_DCR0: EINT=0,ERQ=0,CS=0,AA=0,??=0,??=0,??=0,??=0,??=0,SINC=0,SSIZE=0,DINC=0,DSIZE=0,START=0,SMOD=0,DMOD=0,D_REQ=0,??=0,LINKCC=0,LCH1=0,LCH2=0 */
  setReg32(DMA_DCR0, 0x00);
  /* Clear flags */
  /* DMA_DSR_BCR0: ??=0,CE=0,BES=0,BED=0,??=0,REQ=0,BSY=0,DONE=1,BCR=0 */
  setReg32Bit(DMA_DSR_BCR0, DONE);
  /* DMA_REQC: CFSM0=1,??=0,??=0,??=0,DMAC0=0,CFSM1=0,??=0,??=0,??=0,DMAC1=0,CFSM2=0,??=0,??=0,??=0,DMAC2=0,CFSM3=0,??=0,??=0,??=0,DMAC3=0 */
  setReg32Bit(DMA_REQC, CFSM0);
  /* DMA_SAR0: SAR=0 */
  setReg32(DMA_SAR0, 0x00);
  /* DMA_DAR0: DAR=0 */
  setReg32(DMA_DAR0, 0x00);
  /* DMA_DCR0: EINT=1,ERQ=0,CS=0,AA=1,??=0,??=0,??=0,??=0,??=0,SINC=1,SSIZE=1,DINC=1,DSIZE=1,START=0,SMOD=0,DMOD=0,D_REQ=0,??=0,LINKCC=0,LCH1=0,LCH2=0 */
  setReg32(DMA_DCR0, 0x905A0000);
  /* DMA_DSR_BCR0: BCR = 10 */
  DMA_DSR_BCR0 = (10) & DMA_DSR_BCR0_BCR_MASK;
}

/*
** ===================================================================
**     Method      :  DMA_GetDataSize (component DMAChannel)
**
**     Description :
**         Specifies the DMA data size - number of data to be
**         transferred.
**     Parameters  : None
**     Returns     :
**         ---             - Data count for DMA transmit/receive
**                           operation of the given DMA channel.
** ===================================================================
*/
/*
dword DMA_GetDataSize(void)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_SetSourceTransferWidth (component DMAChannel)
**
**     Description :
**         Specifies the DMA transfer source width.
**     Parameters  :
**         NAME            - DESCRIPTION
**         width           - Transfer width
**                           DMA_TRANSFER_8_BIT - 8bit
**                           DMA_TRANSFER_16_BIT - 16 bit
**                           DMA_TRANSFER_32_BIT - 32 bit
**     Returns     :
**         ---             - Error code
** ===================================================================
*/
/*
byte DMA_SetSourceTransferWidth(byte width)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_SetDestinationTransferWidth (component DMAChannel)
**
**     Description :
**         Specifies the DMA transfer destination width.
**     Parameters  :
**         NAME            - DESCRIPTION
**         width           - Transfer width
**                           DMA_TRANSFER_8_BIT - 8bit
**                           DMA_TRANSFER_16_BIT - 16 bit
**                           DMA_TRANSFER_32_BIT - 32 bit
**     Returns     :
**         ---             - Error code
** ===================================================================
*/
/*
byte DMA_SetDestinationTransferWidth(byte width)

**      This method is implemented as a macro. See header module. **
*/

/*
** ===================================================================
**     Method      :  DMA_SetSourceCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA source circular buffer size.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - Requested DMA circular buffer size in
**                           bytes represented as power of two (e.g.
**                           size = 10 for 1024 bytes buffer size). Zero
**                           represents buffer disable.
**     Returns     :
**         ---             - Error code
**                           ERR_OK - OK
**                           ERR_RANGE - Requested DMA circular buffer
**                           size out of allowed range
** ===================================================================
*/
byte DMA_SetSourceCircularBufferSize(word size)
{
  if ((size != 0x00U) && ((size < 0x04U) || (size > 0x12U))) { /* Is requested circular buffer size outside allowed range? */
    return ERR_RANGE;                  /* If yes then error */
  }
  if (size == 0U) {
    setReg32BitGroupVal(DMA_DCR0, SMOD, size); /* Circular buffer disable */\
  } else {
    setReg32BitGroupVal(DMA_DCR0, SMOD, SET_BUFFER_POWER_OF_2_FORM(size)); /* Set requested circular buffer size */\
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  DMA_GetSourceCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA source circular buffer size.
**     Parameters  : None
**     Returns     :
**         ---             - Source circular buffer size for the
**                           selected DMA channel represented as power
**                           of two (e.g. size = 10 for 1024 bytes
**                           buffer size). Zero represents buffer
**                           disabled.
** ===================================================================
*/
word DMA_GetSourceCircularBufferSize(void)
{
  word size = (word)(testReg32BitGroup(DMA_DCR0, SMOD) >> DMA_DCR0_SMOD_BITNUM);
  if (size != 0U) {
    size = GET_BUFFER_POWER_OF_2_FORM(size);
  }
  return size;
}

/*
** ===================================================================
**     Method      :  DMA_SetDestinationCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA destination circular buffer size.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - Requested DMA circular buffer size in
**                           bytes represented as power of two (e.g.
**                           size = 10 for 1024 bytes buffer size). Zero
**                           represents buffer disable.
**     Returns     :
**         ---             - Error code
**                           ERR_OK - OK
**                           ERR_RANGE - Requested DMA circular buffer
**                           size out of allowed range
** ===================================================================
*/
byte DMA_SetDestinationCircularBufferSize(word size)
{
  if ((size != 0x00U) && ((size < 0x04U) || (size > 0x12U))) { /* Is requested circular buffer size outside allowed range? */
    return ERR_RANGE;                  /* If yes then error */
  }
  if (size == 0U) {
    setReg32BitGroupVal(DMA_DCR0, DMOD, size); /* Circular buffer disable */\
  } else {
    setReg32BitGroupVal(DMA_DCR0, DMOD, SET_BUFFER_POWER_OF_2_FORM(size)); /* Set requested circular buffer size */\
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  DMA_GetDestinationCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA destination circular buffer size.
**     Parameters  : None
**     Returns     :
**         ---             - Destination circular buffer size for the
**                           selected DMA channel represented as power
**                           of two (e.g. size = 10 for 1024 bytes
**                           buffer size). Zero represents buffer
**                           disabled.
** ===================================================================
*/
word DMA_GetDestinationCircularBufferSize(void)
{
  word size = (word)(testReg32BitGroup(DMA_DCR0, DMOD) >> DMA_DCR0_DMOD_BITNUM);
  if (size != 0U) {
    size = GET_BUFFER_POWER_OF_2_FORM(size);
  }
  return size;
}

/*
** ===================================================================
**     Method      :  DMA_GetCompleteStatus (component DMAChannel)
**
**     Description :
**         This method returns a transfer complete status since last
**         call of this method.
**     Parameters  : None
**     Returns     :
**         ---             - Complete status. Possible values:
**                           <true> - DMA transfer completed since last
**                           call
**                           <false> - DMA transfer didn't complete
**                           since last call
** ===================================================================
*/
bool DMA_GetCompleteStatus(void)
{
  EnterCritical();                     /* Enter the critical section */
  if ((StatusFlags & DONE_FLAG) != 0x00U) { /* DONE flag asserted since last GetCompleteStatus() invocation? */
    StatusFlags &= ~(word)(DONE_FLAG); /* If yes, clear flag and return */
    ExitCritical();                    /* Exit the critical section */
    return TRUE;
  }
  ExitCritical();                      /* Exit the critical section */
  return FALSE;
}

/* END DMA. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
