/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : DMA.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : DMAChannel
**     Version     : Component 01.069, Driver 01.10, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:34, # CodeGen: 19
**     Abstract    :
**         This bean "DMAChannel" implements DMA channel.

**     Settings    :
**         DMA channel                 : DMA_Channel0
**
**         DMA interrupt
**             Vector name             : INT_DMA0
**             Interrupt priority      : 1
**
**         Source address              : 0
**         Destination address         : 0
**
**         Block length                : 10
**
**     Contents    :
**         SetSourceAddress                 - void DMA_SetSourceAddress(void* addr);
**         SetDestinationAddress            - void DMA_SetDestinationAddress(void* addr);
**         SetSourcePointerMode             - byte DMA_SetSourcePointerMode(byte mode);
**         SetDestinationPointerMode        - byte DMA_SetDestinationPointerMode(byte mode);
**         SetSourceTransferWidth           - byte DMA_SetSourceTransferWidth(byte width);
**         SetDestinationTransferWidth      - byte DMA_SetDestinationTransferWidth(byte width);
**         SetSourceCircularBufferSize      - byte DMA_SetSourceCircularBufferSize(word size);
**         GetSourceCircularBufferSize      - word DMA_GetSourceCircularBufferSize(void);
**         SetDestinationCircularBufferSize - byte DMA_SetDestinationCircularBufferSize(word size);
**         GetDestinationCircularBufferSize - word DMA_GetDestinationCircularBufferSize(void);
**         SetDataSize                      - byte DMA_SetDataSize(word size);
**         GetDataSize                      - dword DMA_GetDataSize(void);
**         Start                            - void DMA_Start(void);
**         Stop                             - void DMA_Stop(void);
**         GetStatus                        - byte DMA_GetStatus(void);
**         GetCompleteStatus                - bool DMA_GetCompleteStatus(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __DMA
#define __DMA

/* MODULE DMA. */

/* Pointer increment constants */
#ifndef DMA_DONT_CHANGE_POINTER
  #define DMA_DONT_CHANGE_POINTER    0U
#endif
#ifndef DMA_INC_POINTER
  #define DMA_INC_POINTER            2U
#endif
#ifndef DMA_DEC_POINTER
  #define DMA_DEC_POINTER            3U
#endif

/* Status bits constants */
/* DMA channel is disabled (not active) */
#ifndef DMA_DISABLED
  #define DMA_DISABLED               0x00U
#endif
/* DMA channel is enabled (active) */
#ifndef DMA_ENABLED
  #define DMA_ENABLED                0x01U
#endif
/* Configuration error */
#ifndef DMA_CONFIG_ERR
  #define DMA_CONFIG_ERR             0x40U
#endif
/* Bus error on source */
#ifndef DMA_BUS_SOURCE_ERR
  #define DMA_BUS_SOURCE_ERR         0x20U
#endif
/* Bus error on destination */
#ifndef DMA_BUS_DESTINATION_ERR
  #define DMA_BUS_DESTINATION_ERR    0x10U
#endif
/* DMA request is pending */
#ifndef DMA_REQUEST_PENDING
  #define DMA_REQUEST_PENDING        0x04U
#endif
/* DMA channel transfer is active */
#ifndef DMA_BUSY
  #define DMA_BUSY                   0x02U
#endif
/* DMA channel transfer completed (with or without error) */
#ifndef DMA_DONE
  #define DMA_DONE                   0x01U
#endif

/* Transfer width constants */
#ifndef DMA_TRANSFER_8_BIT
  #define DMA_TRANSFER_8_BIT         1U
#endif
#ifndef DMA_TRANSFER_16_BIT
  #define DMA_TRANSFER_16_BIT        2U
#endif
#ifndef DMA_TRANSFER_32_BIT
  #define DMA_TRANSFER_32_BIT        0U
#endif

/* Circular buffer macro transforming power of two form to register value form
   (applicable only for integer values greater than 3) */
#define SET_BUFFER_POWER_OF_2_FORM(size) (size - 3U)
/* Circular buffer macro transforming register value form to power of two form
   (applicable only for integer values greater than 0) */
#define GET_BUFFER_POWER_OF_2_FORM(size) (size + 3U)

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"




byte DMA_SetSourcePointerMode(byte mode);
/*
** ===================================================================
**     Method      :  DMA_SetSourcePointerMode (component DMAChannel)
**
**     Description :
**         Specifies the source address pointer mode. Source address
**         can be incremented, decremented or can stay unchanged at the
**         end of each DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**         mode            - Source pointer mode. 
**                           DONT_CHANGE_POINTER - Don't change pointer
**                           INC_POINTER - Increment pointer
**                           DEC_POINTER - Decrement pointer
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

byte DMA_SetDestinationPointerMode(byte mode);
/*
** ===================================================================
**     Method      :  DMA_SetDestinationPointerMode (component DMAChannel)
**
**     Description :
**         Specifies the destination address pointer mode. Destination
**         address can be incremented, decremented or can stay
**         unchanged at the end of each DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**         mode            - Destination pointer mode. 
**                           DONT_CHANGE_POINTER - Don't change pointer
**                           INC_POINTER - Increment pointer
**                           DEC_POINTER - Decrement pointer
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

#define DMA_SetSourceAddress(addr) (setReg32(DMA_SAR0, addr))
/*
** ===================================================================
**     Method      :  DMA_SetSourceAddress (component DMAChannel)
**
**     Description :
**         Specifies address of the source buffer for DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * addr            - Pointer to the source buffer for DMA
**                           transfer.
**     Returns     : Nothing
** ===================================================================
*/

#define DMA_SetDestinationAddress(addr) (setReg32(DMA_DAR0, addr))
/*
** ===================================================================
**     Method      :  DMA_SetDestinationAddress (component DMAChannel)
**
**     Description :
**         Specifies address of the destination buffer for DMA transfer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * addr            - Pointer to the destination buffer for
**                           DMA transfer.
**     Returns     : Nothing
** ===================================================================
*/

#define DMA_SetDataSize(size) (setReg32BitGroupVal(DMA_DSR_BCR0, BCR, size), (byte)ERR_OK)
/*
** ===================================================================
**     Method      :  DMA_SetDataSize (component DMAChannel)
**
**     Description :
**         Specifies the DMA data size - number of data to be
**         transferred.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - Number of bytes to be transferred.
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

#define DMA_Start() do {EnterCritical(); DMA_ActiveFlag = TRUE; ExitCritical(); setReg32Bit(DMA_DCR0, START);} while(0)
/*
** ===================================================================
**     Method      :  DMA_Start (component DMAChannel)
**
**     Description :
**         Starts DMA transfer. If Peripheral mapping is used this
**         method enables peripheral requests and transfer starts after
**         peripheral request is asserted.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define DMA_Stop() do {EnterCritical(); DMA_ActiveFlag = FALSE; ExitCritical(); setReg32Bit(DMA_DSR_BCR0, DONE);} while(0)
/*
** ===================================================================
**     Method      :  DMA_Stop (component DMAChannel)
**
**     Description :
**         Aborts DMA transfer. If Peripheral mapping is used this
**         method also disables peripheral requests.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
byte DMA_GetStatus(void);
/*
** ===================================================================
**     Method      :  DMA_GetStatus (component DMAChannel)
**
**     Description :
**         Returns status of the selected DMA channel.
**     Parameters  : None
**     Returns     :
**         ---             - Status of the selected DMA channel.
**                           Possible values:
**                           DMA_ENABLED - DMA channel is enabled
**                           (active)
**                           DMA_DISABLED - DMA channel is disabled (not
**                           active)
** ===================================================================
*/

void DMA_Interrupt(void);
/*
** ===================================================================
**     Method      :  DMA_Interrupt (component DMAChannel)
**
**     Description :
**         The method services the transfer complete interrupt of the 
**         selected peripheral(s) and eventually invokes the components 
**         event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void DMA_Init(void);
/*
** ===================================================================
**     Method      :  DMA_Init (component DMAChannel)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define DMA_GetDataSize(size) ((dword)testReg32Bits(DMA_DSR_BCR0, DMA_DSR_BCR0_BCR_MASK))
/*
** ===================================================================
**     Method      :  DMA_GetDataSize (component DMAChannel)
**
**     Description :
**         Specifies the DMA data size - number of data to be
**         transferred.
**     Parameters  : None
**     Returns     :
**         ---             - Data count for DMA transmit/receive
**                           operation of the given DMA channel.
** ===================================================================
*/

#define DMA_SetSourceTransferWidth(width) (setReg32BitGroupVal(DMA_DCR0, SSIZE, width), (byte)ERR_OK)
/*
** ===================================================================
**     Method      :  DMA_SetSourceTransferWidth (component DMAChannel)
**
**     Description :
**         Specifies the DMA transfer source width.
**     Parameters  :
**         NAME            - DESCRIPTION
**         width           - Transfer width
**                           DMA_TRANSFER_8_BIT - 8bit
**                           DMA_TRANSFER_16_BIT - 16 bit
**                           DMA_TRANSFER_32_BIT - 32 bit
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

#define DMA_SetDestinationTransferWidth(width) (setReg32BitGroupVal(DMA_DCR0, DSIZE, width), (byte)ERR_OK)
/*
** ===================================================================
**     Method      :  DMA_SetDestinationTransferWidth (component DMAChannel)
**
**     Description :
**         Specifies the DMA transfer destination width.
**     Parameters  :
**         NAME            - DESCRIPTION
**         width           - Transfer width
**                           DMA_TRANSFER_8_BIT - 8bit
**                           DMA_TRANSFER_16_BIT - 16 bit
**                           DMA_TRANSFER_32_BIT - 32 bit
**     Returns     :
**         ---             - Error code
** ===================================================================
*/

byte DMA_SetSourceCircularBufferSize(word size);
/*
** ===================================================================
**     Method      :  DMA_SetSourceCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA source circular buffer size.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - Requested DMA circular buffer size in
**                           bytes represented as power of two (e.g.
**                           size = 10 for 1024 bytes buffer size). Zero
**                           represents buffer disable.
**     Returns     :
**         ---             - Error code
**                           ERR_OK - OK
**                           ERR_RANGE - Requested DMA circular buffer
**                           size out of allowed range
** ===================================================================
*/

word DMA_GetSourceCircularBufferSize(void);
/*
** ===================================================================
**     Method      :  DMA_GetSourceCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA source circular buffer size.
**     Parameters  : None
**     Returns     :
**         ---             - Source circular buffer size for the
**                           selected DMA channel represented as power
**                           of two (e.g. size = 10 for 1024 bytes
**                           buffer size). Zero represents buffer
**                           disabled.
** ===================================================================
*/

byte DMA_SetDestinationCircularBufferSize(word size);
/*
** ===================================================================
**     Method      :  DMA_SetDestinationCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA destination circular buffer size.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - Requested DMA circular buffer size in
**                           bytes represented as power of two (e.g.
**                           size = 10 for 1024 bytes buffer size). Zero
**                           represents buffer disable.
**     Returns     :
**         ---             - Error code
**                           ERR_OK - OK
**                           ERR_RANGE - Requested DMA circular buffer
**                           size out of allowed range
** ===================================================================
*/

word DMA_GetDestinationCircularBufferSize(void);
/*
** ===================================================================
**     Method      :  DMA_GetDestinationCircularBufferSize (component DMAChannel)
**
**     Description :
**         Specifies DMA destination circular buffer size.
**     Parameters  : None
**     Returns     :
**         ---             - Destination circular buffer size for the
**                           selected DMA channel represented as power
**                           of two (e.g. size = 10 for 1024 bytes
**                           buffer size). Zero represents buffer
**                           disabled.
** ===================================================================
*/

bool DMA_GetCompleteStatus(void);
/*
** ===================================================================
**     Method      :  DMA_GetCompleteStatus (component DMAChannel)
**
**     Description :
**         This method returns a transfer complete status since last
**         call of this method.
**     Parameters  : None
**     Returns     :
**         ---             - Complete status. Possible values:
**                           <true> - DMA transfer completed since last
**                           call
**                           <false> - DMA transfer didn't complete
**                           since last call
** ===================================================================
*/


extern bool DMA_ActiveFlag;            /* DMA channel active flag used in GetStatus method */

/* END DMA. */

#endif /* ifndef __DMA */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
