/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PS1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PulseStream
**     Version     : Component 01.045, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:35, # CodeGen: 10
**     Abstract    :
**          This component "PulseStream" implements a pulse stream generator.
**          PulseStream allows generation of several pulses 1:1 with a
**          predefined width. The signal is generated after the Enable
**          method is invoked. Number of pulses is predefined in the component
**          and may be changed by method SetNumOfPulses.
**     Settings    :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       12            |  GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**             ----------------------------------------------------
**
**         Timer name                  : TMRA1 (16-bit)
**         Compare name                : TMRA1_Compare
**
**         Number of output pulses     : 9999
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 100000000 Hz
**           Pulse width
**             Xtal ticks              : 800
**             microseconds            : 100
**             seconds (real)          : 0.0001
**             Hz                      : 10000
**             kHz                     : 10
**
**         Runtime setting             : none
**
**         Initialization:
**              Output level           : low
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TMRA_1_CNTR [E155]
**              Mode                   : TMRA_1_CTRL [E156]
**              Run                    : TMRA_1_CTRL [E156]
**              Prescaler              : TMRA_1_CTRL [E156]
**
**         Compare registers
**              Compare                : TMRA_1_COMP1 [E150]
**
**         Clock source registers
**              Timer name             : TMRA2 (16-bit)
**              Counter                : TMRA_2_CNTR [E165]
**              Mode                   : TMRA_2_CTRL [E166]
**              Run                    : TMRA_2_CTRL [E166]
**              Prescaler              : TMRA_2_CTRL [E166]
**              Compare                : TMRA_2_COMP1 [E160]
**
**         Interrupt name              : INT_TMRA_1
**         Priority                    : 2
**         User handling procedure     : PS1_OnEnd
**         This event is called when the 9999 of pulses is generated
**
**     Contents    :
**         Enable         - byte PS1_Enable(void);
**         SetNumOfPulses - byte PS1_SetNumOfPulses(word Num);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE PS1. */

#include "Events.h"
#include "PS1.h"



/* Internal method prototypes */
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component PulseStream)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  setReg(TMRA_2_COMP1,Val);            /* Store given value to the compare 1 register */
}

/*
** ===================================================================
**     Method      :  SetPV (component PulseStream)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_2_CTRL,PCS,Val); /* Store given value to the prescaler */
  setReg(TMRA_2_CNTR,0);               /* Reset counter */
}

/*
** ===================================================================
**     Method      :  PS1_Enable (component PulseStream)
**
**     Description :
**         Enables the component - starts the signal generation. This
**         method must be generated. After all pulses are generated,
**         the component is automatically disabled (and event < OnEnd >
**         may be generated).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte PS1_Enable(void)
{
  if (getRegBitGroup(TMRA_1_CTRL,CM)) { /* Is counter running? */
    return ERR_ENABLED;                /* If yes then error */
  }
  setRegBitGroup(TMRA_2_CTRL,CM,0);    /* Stop source clock counter */
  setRegBit(TMRA_2_SCTRL,FORCE);       /* Synchronize source clock */
  setReg(TMRA_2_CNTR,0x00);            /* Reset source counter register */
  EnterCritical();                     /* Disable global interrupts */
  setRegBitGroup(TMRA_2_CTRL,CM,0x01); /* Run source clock counter */
  setRegBitGroup(TMRA_1_CTRL,CM,0x01); /* Run counter */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PS1_SetNumOfPulses (component PulseStream)
**
**     Description :
**         Sets the number of pulses that has to be generated.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Num             - Number of pulses to be generated
**     Returns     :
**         ---             - Error code, possible codes:  
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work
**                           in the active speed mode
**                           ERR_ENABLED - Component is enabled. Component must
**                           be disabled (see <Disable> method)
** ===================================================================
*/
byte PS1_SetNumOfPulses(word Num)
{
  if (getRegBitGroup(TMRA_1_CTRL,CM)) { /* Is counter running? */
    return ERR_ENABLED;                /* If yes then error */
  }
  setReg(TMRA_1_COMP1,Num);            /* Set up compare 1 register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PS1_Init (component PulseStream)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PS1_Init(void)
{
  /* TMRA_2_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=3 */
  setReg(TMRA_2_CTRL,0x23);            /* Set up mode */
  /* TMRA_2_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_2_SCTRL,0x00);
  setReg(TMRA_2_LOAD,0x00);            /* Reset load register */
  /* TMRA_2_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=0 */
  setReg(TMRA_2_CSCTRL,0x00);          /* Set up comparator control register */
  /* TMRA_1_CTRL: CM=0,PCS=6,SCS=0,ONCE=1,LENGTH=1,DIR=0,COINIT=0,OUTMODE=7 */
  setReg(TMRA_1_CTRL,0x0C67);          /* Set up mode */
  /* TMRA_1_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=1 */
  setReg(TMRA_1_SCTRL,0x01);
  setReg(TMRA_1_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_1_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_1_COMP1,0x270F);         /* Set up compare 1 register */
  /* TMRA_1_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=1,TCF2=0,TCF1=0,CL2=0,CL1=0 */
  setReg(TMRA_1_CSCTRL,0x40);          /* Set up comparator control register */
  SetCV((word)0x270F);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x08);                   /* Set prescaler register according to the selected high speed CPU mode */
}

/*
** ===================================================================
**     Method      :  PS1_Interrupt (component PulseStream)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void PS1_Interrupt(void)
{
  clrRegBit(TMRA_1_CSCTRL,TCF1);       /* Reset interrupt request flag */
  PS1_OnEnd();                         /* Invoke user event */
}

/* END PS1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
