/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PS1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PulseStream
**     Version     : Component 01.045, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:38, # CodeGen: 12
**     Abstract    :
**          This component "PulseStream" implements a pulse stream generator.
**          PulseStream allows generation of several pulses 1:1 with a
**          predefined width. The signal is generated after the Enable
**          method is invoked. Number of pulses is predefined in the component
**          and may be changed by method SetNumOfPulses.
**     Settings    :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       11            |  GPIOC3/TA0/CMPA_O/RXD0/CLKIN1
**             ----------------------------------------------------
**
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**
**         Number of output pulses     : 254
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 100000000 Hz
**           Pulse width
**             Xtal ticks              : 800
**             microseconds            : 100
**             seconds (real)          : 0.0001
**             Hz                      : 10000
**             kHz                     : 10
**
**         Runtime setting             : none
**
**         Initialization:
**              Output level           : low
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**
**         Compare registers
**              Compare                : TMRA_0_COMP1 [E140]
**
**         Clock source registers
**              Timer name             : TMRA2 (16-bit)
**              Counter                : TMRA_2_CNTR [E165]
**              Mode                   : TMRA_2_CTRL [E166]
**              Run                    : TMRA_2_CTRL [E166]
**              Prescaler              : TMRA_2_CTRL [E166]
**              Compare                : TMRA_2_COMP1 [E160]
**
**         Interrupt name              : INT_TMRA_0
**         Priority                    : 1
**         User handling procedure     : PS1_OnEnd
**         This event is called when the 254 of pulses is generated
**
**     Contents    :
**         Enable         - byte PS1_Enable(void);
**         SetNumOfPulses - byte PS1_SetNumOfPulses(word Num);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __PS1
#define __PS1

/* MODULE PS1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"


byte PS1_Enable(void);
/*
** ===================================================================
**     Method      :  PS1_Enable (component PulseStream)
**
**     Description :
**         Enables the component - starts the signal generation. This
**         method must be generated. After all pulses are generated,
**         the component is automatically disabled (and event < OnEnd >
**         may be generated).
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte PS1_SetNumOfPulses(word Num);
/*
** ===================================================================
**     Method      :  PS1_SetNumOfPulses (component PulseStream)
**
**     Description :
**         Sets the number of pulses that has to be generated.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Num             - Number of pulses to be generated
**     Returns     :
**         ---             - Error code, possible codes:  
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work
**                           in the active speed mode
**                           ERR_ENABLED - Component is enabled. Component must
**                           be disabled (see <Disable> method)
** ===================================================================
*/

void PS1_Init(void);
/*
** ===================================================================
**     Method      :  PS1_Init (component PulseStream)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void PS1_Interrupt(void);
/*
** ===================================================================
**     Method      :  PS1_Interrupt (component PulseStream)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END PS1. */

#endif /* ifndef __PS1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
