/** ###################################################################
**     Filename    : Events.c
**     Project     : EvntCn8
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 16:25, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

bool end;
bool overflow;

/*
** ===================================================================
**     Event       :  PS1_OnEnd (module Events)
**
**     Component   :  PS1 [PulseStream]
**     Description :
**         This event is called after all pulses have been generated (only
**         if the events are enabled - <"EnableEvent">). The event
**         may be selected only if interrupt service is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void PS1_OnEnd(void)
{
  end = TRUE;
}

/*
** ===================================================================
**     Event       :  EC81_OnEnd (module Events)
**
**     Component   :  EC81 [EventCntr8]
**     Description :
**         This event is called when the specified number of iterations
**         is generated. This event is available only if a <interrupt
**         service/event> is enabled, the component is in <Repetitive mode>
**         and is enabled - <Enable> method and the events are
**         enabled - <EnableEvent> method.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void EC81_OnEnd(void)
{
  overflow = TRUE;
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert 0.00.00 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
