/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : FC1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : FreeCntr
**     Version     : Component 01.115, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:40, # CodeGen: 11
**     Abstract    :
**         This device "FreeCntr" implements a free running counter for
**         time measurement.
**     Settings    :
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-4
**             Clock                   : 25000000 Hz
**           Period
**             Xtal ticks              : 16000
**             microseconds            : 2000
**             milliseconds            : 2
**             seconds (real)          : 0.002
**             Hz                      : 500
**           Frequency of counting (Bus clock / prescaler)
**             Hz                      : 25000000
**
**         Initialization:
**              Timer                  : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**              Compare                : TMRA_0_COMP1 [E140]
**
**         User handling procedure     : not specified
**     Contents    :
**         Enable          - byte FC1_Enable(void);
**         Reset           - byte FC1_Reset(void);
**         GetCounterValue - byte FC1_GetCounterValue(FC1_TTimerValue *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE FC1. */

#include "FC1.h"


/* Internal method prototypes */
static void HWEnDi(void);
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component FreeCntr)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMRA_0_CMPLD1,Val);           /* Store given value to the compare preload 1 register */
  setReg(TMRA_0_CMPLD2,Val);           /* Store given value to the compare preload 2 register */
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (component FreeCntr)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(TMRA_0_CTRL,PCS,Val); /* Store given value to the prescaler */
  setReg(TMRA_0_CNTR,0);               /* Reset counter */
}

/*
** ===================================================================
**     Method      :  HWEnDi (component FreeCntr)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
    setReg(TMRA_0_COMP1,getReg(TMRA_0_CMPLD1)); /* Refresh compare 1 register */
    setReg(TMRA_0_COMP2,getReg(TMRA_0_CMPLD2)); /* Refresh compare 2 register */
    setReg(TMRA_0_CNTR,0);             /* Reset counter */
    setRegBitGroup(TMRA_0_CTRL,CM,0x01); /* Run counter */
}

/*
** ===================================================================
**     Method      :  FC1_Enable (component FreeCntr)
**
**     Description :
**         This method enables the component, i.e. timer is enabled and
**         the internal clocks are counted. The method usually also
**         reset the counter (if it is supported by HW). 
**         The method is not available if the counter is shared.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte FC1_Enable(void)
{
  HWEnDi();                            /* Enable the device */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  FC1_Reset (component FreeCntr)
**
**     Description :
**         This method resets the timer-counter (sets to zero for
**         up-counting HW or to appropriate value for down-counting HW).
**         The method is available only if the counter register can be
**         set by software and the counter is not shared.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte FC1_Reset(void)
{
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  FC1_GetCounterValue (component FreeCntr)
**
**     Description :
**         This method returns a content of the counter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - Pointer to returned value.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte FC1_GetCounterValue(FC1_TTimerValue *Value)
{
  *Value = getReg(TMRA_0_CNTR);        /* Return counter value */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  FC1_Init (component FreeCntr)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void FC1_Init(void)
{
  /* TMRA_0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,COINIT=0,OUTMODE=4 */
  setReg(TMRA_0_CTRL,0x24);            /* Stop timer, use alternating compare registers */
  setReg(TMRA_0_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_0_LOAD,0x00);            /* Reset load register */
  setReg(TMRA_0_COMP1,0xC34F);         /* Set up compare 1 register */
  setReg(TMRA_0_COMP2,0xC34F);         /* Set up compare 2 register */
  /* TMRA_0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,ROC=0,TCI=0,UP=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=1,CL1=2 */
  setReg(TMRA_0_CSCTRL,0x06);          /* Enable compare 1 interrupt */
  SetCV((word)0xC34F);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x0A);                   /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/* END FC1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
