/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : FC1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : FreeCntr
**     Version     : Component 01.115, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:40, # CodeGen: 11
**     Abstract    :
**         This device "FreeCntr" implements a free running counter for
**         time measurement.
**     Settings    :
**         Timer name                  : TMRA0 (16-bit)
**         Compare name                : TMRA0_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-4
**             Clock                   : 25000000 Hz
**           Period
**             Xtal ticks              : 16000
**             microseconds            : 2000
**             milliseconds            : 2
**             seconds (real)          : 0.002
**             Hz                      : 500
**           Frequency of counting (Bus clock / prescaler)
**             Hz                      : 25000000
**
**         Initialization:
**              Timer                  : Enabled
**
**         Timer registers
**              Counter                : TMRA_0_CNTR [E145]
**              Mode                   : TMRA_0_CTRL [E146]
**              Run                    : TMRA_0_CTRL [E146]
**              Prescaler              : TMRA_0_CTRL [E146]
**              Compare                : TMRA_0_COMP1 [E140]
**
**         User handling procedure     : not specified
**     Contents    :
**         Enable          - byte FC1_Enable(void);
**         Reset           - byte FC1_Reset(void);
**         GetCounterValue - byte FC1_GetCounterValue(FC1_TTimerValue *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __FC1
#define __FC1

/* MODULE FC1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"

#ifndef __BWUserType_FC1_TTimerValue
#define __BWUserType_FC1_TTimerValue
  typedef word FC1_TTimerValue;        /* Counter or compare value, width depend on timer width, 8, 16, 32 or 64 bits. */
#endif

#define FC1_PERIOD_VALUE   0xC350UL    /* Initial period value in ticks of the timer. It is available only if the bean is enabled in high speed mode. */
#define FC1_PERIOD_VALUE_HIGH 0xC350UL /* Period value in ticks of the timer in high speed mode. It is available only if the bean is enabled in high speed mode. */
#define FC1_PRESCALER_VALUE 0x04UL     /* Initial prescaler value of the timer. It is available only if the bean is enabled in high speed mode. */
#define FC1_PRESCALER_VALUE_HIGH 0x04UL /* Prescaler value of the timer in high speed mode. It is available only if the bean is enabled in high speed mode. */
#define FC1_COUNTER_INPUT_CLOCK_HIGH 0x017D7840UL /* Counter input clock value in high speed mode [Hz] (integer number). It is available only if the bean is enabled in high speed mode. */
#define FC1_COUNTER_INPUT_CLOCK 0x017D7840UL /* Initial counter input clock value [Hz] (integer number). It is available only if the bean is enabled in high speed mode. */
#define FC1_UP_COUNTER     1           /* The timer counts upwards */
#define FC1_RESET_ON_COMPARE 1         /* This constant is defined if Reset counter on compare property is selected. */
/* Deprecated constants */
#define FC1_FChigh         0x017D7840UL /* Frequency of counting in high speed CPU mode */

byte FC1_Enable(void);
/*
** ===================================================================
**     Method      :  FC1_Enable (component FreeCntr)
**
**     Description :
**         This method enables the component, i.e. timer is enabled and
**         the internal clocks are counted. The method usually also
**         reset the counter (if it is supported by HW). 
**         The method is not available if the counter is shared.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte FC1_Reset(void);
/*
** ===================================================================
**     Method      :  FC1_Reset (component FreeCntr)
**
**     Description :
**         This method resets the timer-counter (sets to zero for
**         up-counting HW or to appropriate value for down-counting HW).
**         The method is available only if the counter register can be
**         set by software and the counter is not shared.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte FC1_GetCounterValue(FC1_TTimerValue *Value);
/*
** ===================================================================
**     Method      :  FC1_GetCounterValue (component FreeCntr)
**
**     Description :
**         This method returns a content of the counter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - Pointer to returned value.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

void FC1_Init(void);
/*
** ===================================================================
**     Method      :  FC1_Init (component FreeCntr)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END FC1. */

#endif /* ifndef __FC1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
