/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PE_Types.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PE_Types
**     Version     : Driver 01.15
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:42, # CodeGen: 7
**     Abstract    :
**         PE_Types.h - contains definitions of basic types,
**         register access macros and hardware specific macros
**         which can be used in user application.
**     Settings    :
**     Contents    :
**         No public methods
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __PE_Types_H
#define __PE_Types_H

/* Standard ANSI C types */
#include <stdint.h>

typedef char                char_t;

#ifndef FALSE
  #define  FALSE  0U                   /* Boolean value FALSE. FALSE is defined always as a zero value. */
#endif
#ifndef TRUE
  #define  TRUE   1U                   /* Boolean value TRUE. TRUE is defined always as a non zero value. */
#endif

#ifndef NULL
  #define  NULL   0U
#endif

/* PE types definition */
typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];
typedef uint8_t TPE_ErrCode;
#ifndef TPE_Float
typedef float TPE_Float;
#endif

/* SDK types definition */
typedef signed char    Word8;
typedef unsigned char  UWord8;
typedef short          Word16;
typedef unsigned short UWord16;
typedef long           Word32;
typedef unsigned long  UWord32;
typedef signed char    Int8;
typedef unsigned char  UInt8;
typedef int            Int16;
typedef unsigned int   UInt16;
typedef long           Int32;
typedef unsigned long  UInt32;
typedef __typeof__(sizeof(0)) ssize_t;
typedef int ibool;

/*lint -save  -esym(960,19.12) -esym(961,19.13) Disable MISRA rule (19.12,19.13) checking. */
/**************************************************/
/* PE register access macros                      */
/**************************************************/
#define setRegBit(reg, bit)                                     (reg |= (word)(reg##_##bit##_##MASK))
#define clrRegBit(reg, bit)                                     (reg &= (word)(~(word)reg##_##bit##_##MASK))
#define getRegBit(reg, bit)                                     (reg & reg##_##bit##_##MASK)
#define setReg(reg, val)                                        (reg = (word)(val))
#define getReg(reg)                                             (reg)
#define setRegBits(reg, mask)                                   (reg |= (word)(mask))
#define getRegBits(reg, mask)                                   (reg & (word)(mask))
#define clrRegBits(reg, mask)                                   (reg &= (word)(~(word)(mask)))
#define setRegBitGroup(reg, bits, val)                          (reg = (word)((word)(reg & ~(word)reg##_##bits##_##MASK) | ((word)(val) << reg##_##bits##_##BITNUM)))
#define getRegBitGroup(reg, bits)                               ((reg & reg##_##bits##_##MASK) >> reg##_##bits##_##BITNUM)
/* If 16-bit mask constants are used and 56800EX instructions are enabled then this macro compiles as atomic operation */
#define setRegMask(reg, maskAnd, maskOr)                        (reg = (word)((getReg(reg) & (word)(~(word)((word)(maskAnd) | (word)(maskOr)))) | (word)(maskOr)))
#define setRegBitVal(reg, bit, val)                             (((val) == 0U) ? (reg &= ~(word)reg##_##bit##_##MASK) : (reg |= reg##_##bit##_##MASK))
#define changeRegBits(reg, mask)                                (reg ^= (mask))
#define changeRegBit(reg, bit)                                  (reg ^= reg##_##bit##_##MASK)


/**********************************************************/
/* Uniform multiplatform 8-bits peripheral access macros */
/**********************************************************/

#define setReg8Bit(RegName, BitName)                            (RegName |= (byte)(RegName##_##BitName##_##MASK))
#define clrReg8Bit(RegName, BitName)                            (RegName &= (byte)(~(byte)RegName##_##BitName##_##MASK))
#define invertReg8Bit(RegName, BitName)                         (RegName ^= (byte)(RegName##_##BitName##_##MASK))
#define testReg8Bit(RegName, BitName)                           (RegName & RegName##_##BitName##_##MASK)

/* Whole peripheral register access macros */
#define setReg8(RegName, val)                                   (RegName = (byte)(val))
#define getReg8(RegName)                                        (RegName)

/* Bits peripheral register access macros */
#define testReg8Bits(RegName, GetMask)                          (RegName & (byte)(GetMask))
#define clrReg8Bits(RegName, ClrMask)                           (RegName &= (byte)(~(byte)(ClrMask)))
#define setReg8Bits(RegName, SetMask)                           (RegName |= (byte)(SetMask))
#define invertReg8Bits(RegName, InvMask)                        (RegName ^= (byte)(InvMask))
#define clrSetReg8Bits(RegName, ClrMask, SetMask)               (RegName = (byte)((RegName & (~(byte)(ClrMask))) | (byte)(SetMask)))
#define seqClrSetReg8Bits(RegName, BitsMask, BitsVal)           ( RegName &= (byte)(~((~(byte)(BitsVal)) & (byte)(BitsMask))),\
                                                                 RegName |= (byte)((byte)(BitsVal) & (byte)(BitsMask)) )
#define seqSetClrReg8Bits(RegName, BitsMask, BitsVal)           ( RegName |= (byte)((byte)(BitsVal) & (byte)(BitsMask)),\
                                                                 RegName &= (byte)(~(~(byte)(BitsVal) & (byte)(BitsMask))) )
#define seqResetSetReg8Bits(RegName, BitsMask, BitsVal)         ( RegName &= (byte)(~(byte)(BitsMask)),\
                                                                 RegName |= (byte)((byte)(BitsVal) & (byte)(BitsMask)) )
#define clrReg8BitsByOne(RegName, ClrMask, BitsMask)            (RegName &= (byte)((byte)(ClrMask) & (byte)(BitsMask)))

/* Bit group peripheral register access macros */
#define testReg8BitGroup(RegName, GroupName)                    (RegName & RegName##_##GroupName##_##MASK)
#define getReg8BitGroupVal(RegName, GroupName)                  ((RegName & RegName##_##GroupName##_##MASK) >> RegName##_##GroupName##_##BITNUM)
#define setReg8BitGroupVal(RegName, GroupName, GroupVal)        (RegName = (byte)((RegName & ~(byte)RegName##_##GroupName##_##MASK) | ((byte)(GroupVal) << RegName##_##GroupName##_##BITNUM)))
#define seqClrSetReg8BitGroupVal(RegName,GroupName,GroupVal)    ( RegName &= (byte)(~(~((byte)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)),\
                                                                 RegName |= (byte)(((byte)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK) )
#define seqSetClrReg8BitGroupVal(RegName,GroupName,GroupVal)    ( RegName |= (byte)(((byte)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK),\
                                                                 RegName &= (byte)(~(~((byte)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)) )
#define seqResetSetReg8BitGroupVal(RegName,GroupName,GroupVal)  ( RegName &= (byte)(~(byte)RegName##_##GroupName##_##MASK),\
                                                                 RegName |= (byte)(((byte)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK) )

/* Peripheral access macros based on the memory address */
#define periphMemWrite8(Address, Val)                           (*((volatile uint8_t *)(Address)) = (uint8_t)(Val))
#define periphMemRead8(Address)                                 (*((volatile uint8_t *)(Address)))
#define periphBitsClr8(Address, ClrMask)                        (*((volatile uint8_t *)(Address)) &= (uint8_t)(~(uint8_t)(ClrMask)))
#define periphBitsSet8(Address, SetMask)                        (*((volatile uint8_t *)(Address)) |= (uint8_t)(SetMask))
#define periphBitsTest8(Address, GetMask)                       (*((volatile uint8_t *)(Address)) & (uint8_t)(GetMask))


/**********************************************************/
/* Uniform multiplatform 16-bits peripheral access macros */
/**********************************************************/

#define setReg16Bit(RegName, BitName)                           (RegName |= (word)(RegName##_##BitName##_##MASK))
#define clrReg16Bit(RegName, BitName)                           (RegName &= (word)(~(word)RegName##_##BitName##_##MASK))
#define invertReg16Bit(RegName, BitName)                        (RegName ^= (word)(RegName##_##BitName##_##MASK))
#define testReg16Bit(RegName, BitName)                          (RegName & RegName##_##BitName##_##MASK)

/* Whole peripheral register access macros */
#define setReg16(RegName, val)                                   (RegName = (word)(val))
#define getReg16(RegName)                                        (RegName)

/* Bits peripheral register access macros */
#define testReg16Bits(RegName, GetMask)                          (RegName & (word)(GetMask))
#define clrReg16Bits(RegName, ClrMask)                           (RegName &= (word)(~(word)(ClrMask)))
#define setReg16Bits(RegName, SetMask)                           (RegName |= (word)(SetMask))
#define invertReg16Bits(RegName, InvMask)                        (RegName ^= (word)(InvMask))
/* If 16-bit mask constants are used and 56800EX instructions are enabled then this macro compiles as atomic operation */
#define clrSetReg16Bits(RegName, ClrMask, SetMask)               (RegName = (word)((RegName & (word)(~(word)((word)(ClrMask) | (word)(SetMask)))) | (word)(SetMask)))
#define seqClrSetReg16Bits(RegName, BitsMask, BitsVal)           ( RegName &= (word)(~(word)(~(word)(BitsVal) & (word)(BitsMask))),\
                                                                 RegName |= (word)((word)(BitsVal) & (word)(BitsMask)) )
#define seqSetClrReg16Bits(RegName, BitsMask, BitsVal)           ( RegName |= (word)((word)(BitsVal) & (word)(BitsMask)),\
                                                                 RegName &= (word)(~(~(word)(BitsVal) & (word)(BitsMask))) )
#define seqResetSetReg16Bits(RegName, BitsMask, BitsVal)         ( RegName &= (word)(~(word)(BitsMask)),\
                                                                 RegName |= (word)((word)(BitsVal) & (word)(BitsMask)) )
#define clrReg16BitsByOne(RegName, ClrMask, BitsMask)            (RegName &= (word)((word)(ClrMask) & (word)(BitsMask)))

/* Bit group peripheral register access macros */
#define testReg16BitGroup(RegName, GroupName)                    (RegName & (word)(RegName##_##GroupName##_##MASK))
#define getReg16BitGroupVal(RegName, GroupName)                  ((RegName & RegName##_##GroupName##_##MASK) >> RegName##_##GroupName##_##BITNUM)
#define setReg16BitGroupVal(RegName, GroupName, GroupVal)        (RegName = (word)((RegName & ~(word)RegName##_##GroupName##_##MASK) | ((word)(GroupVal) << RegName##_##GroupName##_##BITNUM)))
#define seqClrSetReg16BitGroupVal(RegName,GroupName,GroupVal)    ( RegName &= (word)(~(~((word)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)),\
                                                                 RegName |= (word)(((word)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK) )
#define seqSetClrReg16BitGroupVal(RegName,GroupName,GroupVal)    ( RegName |= (word)(((word)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK),\
                                                                 RegName &= (word)(~(~((word)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)) )
#define seqResetSetReg16BitGroupVal(RegName,GroupName,GroupVal)  ( RegName &= (word)(~(word)RegName##_##GroupName##_##MASK),\
                                                                 RegName |= (word)(((word)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK) )

/* Peripheral access macros based on the memory address */
#define periphMemWrite16(Address, Val)                           (*((volatile uint16_t *)(Address)) = (uint16_t)(Val))
#define periphMemRead16(Address)                                 (*((volatile uint16_t *)(Address)))
#define periphBitsClr16(Address, ClrMask)                        (*((volatile uint16_t *)(Address)) &= (uint16_t)(~(uint16_t)(ClrMask)))
#define periphBitsSet16(Address, SetMask)                        (*((volatile uint16_t *)(Address)) |= (uint16_t)(SetMask))
#define periphBitsTest16(Address, GetMask)                       (*((volatile uint16_t *)(Address)) & (uint16_t)(GetMask))



/**********************************************************/
/* Uniform multiplatform 32-bits peripheral access macros */
/**********************************************************/
#define setReg32Bit(RegName, BitName)                           (RegName = ((RegName) | ((dword)(RegName##_##BitName##_##MASK))))
#define clrReg32Bit(RegName, BitName)                           (RegName = ((RegName) & ((dword)(~(dword)RegName##_##BitName##_##MASK))))
#define invertReg32Bit(RegName, BitName)                        (RegName = ((RegName) ^ ((dword)(RegName##_##BitName##_##MASK))))
#define testReg32Bit(RegName, BitName)                          (RegName & RegName##_##BitName##_##MASK)

/* Whole peripheral register access macros */
#define setReg32(RegName, val)                                   (RegName = (dword)(val))
#define getReg32(RegName)                                        (RegName)

/* Bits peripheral register access macros */
#define testReg32Bits(RegName, GetMask)                          (RegName & (dword)(GetMask))
#define clrReg32Bits(RegName, ClrMask)                           (RegName = ((RegName) & ((dword)(~(dword)(ClrMask)))))
#define setReg32Bits(RegName, SetMask)                           (RegName = ((RegName) | ((dword)(SetMask))))
#define invertReg32Bits(RegName, InvMask)                        (RegName = ((RegName) ^ ((dword)(InvMask))))
#define clrSetReg32Bits(RegName, ClrMask, SetMask)               (RegName = (dword)((RegName & (~(dword)(ClrMask))) | (dword)(SetMask)))
#define seqClrSetReg32Bits(RegName, BitsMask, BitsVal)           ( RegName = (RegName) & ((dword)(~(~(dword)(BitsVal) & (dword)(BitsMask)))),\
                                                                 RegName = (RegName) | ((dword)((dword)(BitsVal) & (dword)(BitsMask))) )
#define seqSetClrReg32Bits(RegName, BitsMask, BitsVal)           ( RegName = (RegName) | ((dword)((dword)(BitsVal) & (dword)(BitsMask))),\
                                                                 RegName = (RegName) & ((dword)(~(~(dword)(BitsVal) & (dword)(BitsMask)))) )
#define seqResetSetReg32Bits(RegName, BitsMask, BitsVal)         ( RegName = (RegName) & ((dword)(~(dword)(BitsMask))),\
                                                                 RegName |= (dword)((dword)(BitsVal) & (dword)(BitsMask)) )
#define clrReg32BitsByOne(RegName, ClrMask, BitsMask)            (RegName = (RegName) & ((dword)((dword)(ClrMask) & (dword)(BitsMask))))

/* Bit group peripheral register access macros */
#define testReg32BitGroup(RegName, GroupName)                    (RegName & RegName##_##GroupName##_##MASK)
#define getReg32BitGroupVal(RegName, GroupName)                  ((RegName & RegName##_##GroupName##_##MASK) >> RegName##_##GroupName##_##BITNUM)
#define setReg32BitGroupVal(RegName, GroupName, GroupVal)        (RegName = (dword)((RegName & ~(dword)RegName##_##GroupName##_##MASK) | ((dword)(GroupVal) << RegName##_##GroupName##_##BITNUM)))
#define seqClrSetReg32BitGroupVal(RegName,GroupName,GroupVal)    ( RegName = (RegName) & ((dword)(~(~((dword)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK))),\
                                                                 RegName = (RegName) | ((dword)(((dword)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)) )
#define seqSetClrReg32BitGroupVal(RegName,GroupName,GroupVal)    ( RegName = (RegName) | ((dword)(((dword)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)),\
                                                                 RegName = (RegName) & ((dword)(~(~((dword)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK))) )
#define seqResetSetReg32BitGroupVal(RegName,GroupName,GroupVal)  ( RegName = (RegName) & ((dword)(~(dword)RegName##_##GroupName##_##MASK)),\
                                                                 RegName = (RegName) | ((dword)(((dword)(GroupVal) << RegName##_##GroupName##_##BITNUM) & RegName##_##GroupName##_##MASK)) )

/* Peripheral access macros based on the memory address */
#define periphMemWrite32(Address, Val)                           (*((volatile uint32_t *)(Address)) = (uint32_t)(Val))
#define periphMemRead32(Address)                                 (*((volatile uint32_t *)(Address)))
#define periphBitsClr32(Address, ClrMask)                        (*((volatile uint32_t *)(Address)) &= (uint32_t)(~(uint32_t)(ClrMask)))
#define periphBitsSet32(Address, SetMask)                        (*((volatile uint32_t *)(Address)) |= (uint32_t)(SetMask))
#define periphBitsTest32(Address, GetMask)                       (*((volatile uint32_t *)(Address)) & (uint32_t)(GetMask))


#define in16(var,l,h)  (var = ((word)(l)) | (((word)(h)) << 8))
#define out16(l,h,val) { l = (byte)(val); h = (byte)((val) >> 8); }

#define output(P, V) setReg(P,V)
#define input(P) getReg(P)

#define __EI0() do { asm(bfclr  #0x0300,SR); } while(0) /* Enable interrupts of level 0,1,2,3 */
#define __EI1() do { asm(bfset  #0x0100,SR); asm(bfclr  #0x0200,SR); } while(0) /* Enable interrupts of level 1,2,3 */
#define __EI2() do { asm(bfset  #0x0200,SR); asm(bfclr  #0x0100,SR); } while(0) /* Enable interrupts of level 2,3 */
#define __EI3() do { asm(bfset  #0x0300,SR); } while(0) /* Enable interrupts of level 3 */
/*lint -save  -esym(960,14.3) Disable MISRA rule (14.3) checking. */
#define __EI(level) __EI##level()      /* Enable interrupts of the given level */
/*lint -restore  +esym(960,14.3) Enable MISRA rule (14.3) checking. */
#define __DI()  __EI3()                /* Disable interrupts, only level 3 is allowed */


/* Save status register and disable interrupts */
#define EnterCritical()     do {\
                              /*lint -save  -e530 Disable MISRA rule (9.1) checking. */\
                              volatile word StatusReg;\
                              asm(move.w SR, StatusReg);\
                              asm(bfset  #0x0300,SR);\
                              asm(nop);\
                              asm(nop);\
                              asm(nop);\
                              asm(nop);\
                              asm(nop);\
                              asm(nop);\
                              if (SR_lock++ == 0U) {\
                                SR_reg = StatusReg;\
                              }\
                              /*lint -restore Enable MISRA rule (9.1) checking. */\
                            } while (0)

/* Restore status register  */
#define ExitCritical()      do {\
                              if (--SR_lock == 0U) {\
                                asm(moveu.w SR_reg, SR);\
                                asm(nop);\
                                asm(nop);\
                              }\
                            } while (0)


/*lint -restore  +esym(960,19.12) +esym(961,19.13) Enable MISRA rule (19.12,19.13) checking. */

typedef struct {          /* Black&White Image  */
  word width;             /* Image width  */
  word height;            /* Image height */
  byte *pixmap;           /* Image pixel bitmap */
  dword size;             /* Image size */
  char_t *name;           /* Image name */
} TIMAGE;
typedef TIMAGE* PIMAGE ; /* Pointer to image */

/* 16-bit register (big endian) */
typedef union {
   word w;
   struct {
     byte high,low;
   } b;
} TWREG;

typedef union
{
        struct
        {
          UWord16 LSBpart;
          Word16 MSBpart;
        } RegParts;

        Word32 Reg32bit;

} decoder_uReg32bit;

typedef struct
{
        union { Word16 PositionDifferenceHoldReg;
                Word16 posdh; };
        union { Word16 RevolutionHoldReg;
                Word16 revh; };
        union { decoder_uReg32bit PositionHoldReg;
                Word32 posh; };

}decoder_sState;

typedef struct
{
        UWord16 EncPulses;
        UWord16 RevolutionScale;

        Int16   scaleDiffPosCoef;
        UInt16  scalePosCoef;
        Int16   normDiffPosCoef;
        Int16   normPosCoef;
}decoder_sEncScale;

typedef struct
{
        /*lint -save  -e46 Disable MISRA rule (6.4) checking. */
        UWord16 Index    :1;
        UWord16 PhaseB   :1;
        UWord16 PhaseA   :1;
        UWord16 Reserved :13;
        /*lint -restore Enable MISRA rule (6.4) checking. */
}decoder_sEncSignals;

typedef union{
        decoder_sEncSignals  EncSignals;
        UWord16 Value;
} decoder_uEncSignals;

/******************************************************************************
*
* This Motor Control section contains generally useful and generic
* types that are used throughout the domain of motor control.
*
******************************************************************************/
/* Fractional data types for portability */
typedef short          Frac16;
typedef long           Frac32;

typedef enum
{
        mcPhaseA,
        mcPhaseB,
        mcPhaseC
} mc_ePhaseType;

typedef struct
{
        Frac16 PhaseA;
        Frac16 PhaseB;
        Frac16 PhaseC;
} mc_s3PhaseSystem;

/* general types, primary used in FOC */

typedef struct
{
        Frac16 alpha;
        Frac16 beta;
} mc_sPhase;

typedef struct
{
        Frac16 sine;
        Frac16 cosine;
} mc_sAngle;

typedef struct
{
        Frac16 d_axis;
        Frac16 q_axis;
} mc_sDQsystem;

typedef struct
{
        Frac16 psi_Rd;
        Frac16 omega_field;
        Frac16 i_Sd;
        Frac16 i_Sq;
} mc_sDQEstabl;

typedef UWord16 mc_tPWMSignalMask;    /*  pwm_tSignalMask contains six control bits
                                          representing six PWM signals, shown below.
                                          The bits can be combined in a numerical value
                                          that represents the union of the appropriate
                                          bits.  For example, the value 0x15 indicates
                                          that PWM signals 0, 2, and 4 are set.
                                      */

#define MC_PWM_SIGNAL_0       0x0001
#define MC_PWM_SIGNAL_1       0x0002
#define MC_PWM_SIGNAL_2       0x0004
#define MC_PWM_SIGNAL_3       0x0008
#define MC_PWM_SIGNAL_4       0x0010
#define MC_PWM_SIGNAL_5       0x0020
#define MC_PWM_NO_SIGNALS     0x0000     /* No (none) PWM signals */
#define MC_PWM_ALL_SIGNALS   (MC_PWM_SIGNAL_0 | \
                              MC_PWM_SIGNAL_1 | \
                              MC_PWM_SIGNAL_2 | \
                              MC_PWM_SIGNAL_3 | \
                              MC_PWM_SIGNAL_4 | \
                              MC_PWM_SIGNAL_5)

/* general types, primary used in PI, PID and other controllers */

typedef struct
{
   Word16 ProportionalGain;
   Word16 ProportionalGainScale;
   Word16 IntegralGain;
   Word16 IntegralGainScale;
   Word16 DerivativeGain;
   Word16 DerivativeGainScale;
   Word16 PositivePIDLimit;
   Word16 NegativePIDLimit;
   Word16 IntegralPortionK_1;
   Word16 InputErrorK_1;
}mc_sPIDparams;

typedef struct
{
   Word16 ProportionalGain;
   Word16 ProportionalGainScale;
   Word16 IntegralGain;
   Word16 IntegralGainScale;
   Word16 PositivePILimit;
   Word16 NegativePILimit;
   Word16 IntegralPortionK_1;
}mc_sPIparams;


#endif /* __PE_Types_H */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
