/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.14
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-08, 12:25, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "CRC1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define DATA_LEN 16		//Do not change! CRC is computed for this value.

void main(void)
{
  /* Write your local variable definition here */

  test_sRec test;
  UInt32 i;
  UInt32 result;
	
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  
  TEST1_testStart( &test , "Init_CRC" );
  
  TEST1_testComment( &test , "Feeding data" );
  
  for( i = 0 ; i < DATA_LEN ; i++ ) {
	  PESL( CRC , CRC_WRITE_DATA_REG , i );
	  
  } 
  
  TEST1_testComment( &test , "Comparing result" );
  
  result = PESL(CRC, CRC_READ_CRC, NULL);
  
  if( result == 0x9519d748 ) {
	  TEST1_testComment( &test , "OK" );
  } else {
	  TEST1_testFailed( &test , "Comparing result" );
  }
  
  TEST1_testEnd( &test );
    

  for(;;) {}
}

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 0.00.00 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
