/*
** #################################################################################################################
**     THIS MODULE IS A PART OF PROCESSOR EXPERT SYSTEM LIBRARY.
**
**     Filename  : FCAN.H
**
**     Family    : Freescale DSP
**
**     Compiler  : Freescale DSP C Compiler
**
**     Abstract  :
**
**         This PESL module implements a CAN.
**
**         Implemented devices:
**
**           CAN - Flex Controller Area Network module
**
**         Supported CPUs:
**           MC56F84451VLF,MC56F84452VLH,MC56F84462VLH,MC56F84540VLF,MC56F84543VLH,MC56F84565VLK,MC56F84567VLL,MC56F84585VLK,MC56F84587VLL,MC56F84763VLH,MC56F84766VLK,MC56F84769VLL,MC56F84786VLK,MC56F84789VLL
**
**     (c) Freescale Semiconductor
**     2012 All Rights Reserved
**
**     http      : www.freescale.com
**
** #################################################################################################################
*/

#include "CAN.h"
#include "PESLlib.h"
#include "periph.h"

#ifdef __cplusplus
extern "C" {
#endif


#pragma interrupt called
void ioctl_FCANMB_SET_ID_V(UWord16 * pFCanMB, register UWord32 id)
{
  ioctlFCANMB_SET_ID( pFCanMB, id );
}

/* Retrieve 32bit ID from the apropriate bits in given MB */

#pragma interrupt called
UWord32 ioctl_FCANMB_GET_ID(register UWord16* pFCanMB)
{
	register UWord32 ret;

	// optimized assembly conversion
	asm {
		move.w X:(pFCanMB+1), A;	// get id_h
		brclr #8, A1, std_id;		// jump to process std ID

	ext_id:
		move.w X:(pFCanMB+2), A0;	// get id_l
		lsrr.l #1, A;				// move bits ID[17-0] to the right place
		tfr A,B;					// save bits ID[17-0]
		bfclr #0xfffc,B1;			// leave only ID[17-0] saved

		lsrr.w #2,A;				// move bits ID[28-18] to the right place (zero A0)
		bfclr #0x3,A1;				// zero position on ID[17-16]
		or.l B,A;
		bfset #0x8000,A1;			// mark extended ID (bit 31)
		bra rtrn;

	std_id:
		lsrr.l #21, A;

	rtrn:
		tfr A, ret
	}

	return ret;
}


#ifdef __cplusplus
}
#endif