/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : AD1.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : ADC
**     Version     : Component 01.650, Driver 02.07, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:51, # CodeGen: 8
**     Abstract    :
**         This device "ADC" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
**     Settings    :
**          Component name                                 : AD1
**          A/D converter                                  : ADC12
**          Sharing                                        : Disabled
**          Interrupt service/event                        : Disabled
**          A/D channels                                   : 1
**            Channel0                                     : 
**              A/D channel (pin)                          : GPIOA7/ANA7/ANC11
**              A/D channel (pin) signal                   : 
**              Amplifier                                  : x 1
**              Mode select                                : Single Ended
**          ANA7 internal source                           : Disabled
**          ANB7 internal source                           : Disabled
**          Queue                                          : Enabled
**            Mode                                         : Sequential
**            A/D samples                                  : 16
**              Sample0                                    : Enabled
**                Channel                                  : 0
**                High limit                               : 32760
**                Low limit                                : 0
**                Offset                                   : 0
**                Zero crossing                            : Disabled
**              Sample1                                    : Disabled
**              Sample2                                    : Disabled
**              Sample3                                    : Disabled
**              Sample4                                    : Disabled
**              Sample5                                    : Disabled
**              Sample6                                    : Disabled
**              Sample7                                    : Disabled
**              Sample8                                    : Disabled
**              Sample9                                    : Disabled
**              Sample10                                   : Disabled
**              Sample11                                   : Disabled
**              Sample12                                   : Disabled
**              Sample13                                   : Disabled
**              Sample14                                   : Disabled
**              Sample15                                   : Disabled
**          A/D resolution                                 : Autoselect
**          Conversion time                                : 5.44 s
**          Sample time                                    : 5 clock periods
**          Internal trigger                               : Disabled
**          Volt. ref. recovery time                       : 100
**          Power up delay                                 : 13
**          Power savings mode                             : Disabled
**          Auto standby                                   : Disabled
**          Volt. ref. source                              : controlled by this component for both converter
**            High volt. ref. source                       : internal
**            Low volt. ref. source                        : internal
**            High volt. ref. source                       : internal
**            Low volt. ref. source                        : internal
**          Number of conversions                          : 1
**          Initialization                                 : 
**            Enabled in init. code                        : yes
**            Events enabled in init.                      : yes
**          CPU clock/speed selection                      : 
**            High speed mode                              : This component enabled
**            Low speed mode                               : This component disabled
**            Slow speed mode                              : This component disabled
**          High input limit                               : 1
**          Low input limit                                : 0
**          Get value directly                             : yes
**          Wait for result                                : yes
**     Contents    :
**         Measure    - byte AD1_Measure(bool WaitForResult);
**         GetValue16 - byte AD1_GetValue16(word *Values);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE AD1. */

#ifndef __AD1
#define __AD1

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* MODULE AD1. */



byte AD1_Measure(bool WaitForResult);
/*
** ===================================================================
**     Method      :  AD1_Measure (component ADC)
**
**     Description :
**         This method performs one measurement on all channels that
**         are set in the component inspector. (Note: If the <number of
**         conversions> is more than one the conversion of A/D channels
**         is performed specified number of times.)
**     Parameters  :
**         NAME            - DESCRIPTION
**         WaitForResult   - Wait for a result of a
**                           conversion. If <interrupt service> is
**                           disabled, A/D peripheral doesn't support
**                           measuring all channels at once or Autoscan
**                           mode property isn't enabled and at the same
**                           time the <number of channel> is greater
**                           than 1, then the WaitForResult parameter is
**                           ignored and the method waits for each
**                           result every time. If the <interrupt
**                           service> is disabled and a <number of
**                           conversions> is greater than 1, the
**                           parameter is ignored and the method also
**                           waits for each result every time.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - Device is disabled
**                           ERR_BUSY - A conversion is already running
** ===================================================================
*/

byte AD1_GetValue16(word *Values);
/*
** ===================================================================
**     Method      :  AD1_GetValue16 (component ADC)
**
**     Description :
**         This method returns the last measured values of all channels
**         justified to the left. Compared with <GetValue> method this
**         method returns more accurate result if the <number of
**         conversions> is greater than 1 and <AD resolution> is less
**         than 16 bits. In addition, the user code dependency on <AD
**         resolution> is eliminated.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Values          - Pointer to the array that contains
**                           the measured data.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_OVERRUN - External trigger overrun flag
**                           was detected after the last value(s) was
**                           obtained (for example by GetValue). This
**                           error may not be supported on some CPUs
**                           (see generated code).
** ===================================================================
*/

void AD1_Init(void);
/*
** ===================================================================
**     Method      :  AD1_Init (component ADC)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END AD1. */

#endif /* ifndef __AD1 */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
