/** ###################################################################
**     Filename    : Events.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-13, 12:17, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

extern bool transComplete;

/*
** ===================================================================
**     Interrupt handler : DMA_OnComplete
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(DMA_OnComplete_FAST_INT)
#pragma interrupt fast
#elif defined(DMA_OnComplete_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void DMA_OnComplete(void)
{
	transComplete = TRUE;
	PESL(DMA, DMA_CLEAR_DONE_CH0, NULL );
}
#if defined(DMA_OnComplete_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif


/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert 0.00.00 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
