/** ###################################################################
**     Filename    : Events.c
**     Project     : Init_GPIO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 11:46, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

extern word ISRnum;

/*
** ===================================================================
**     Interrupt handler : GPIO_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(GPIO_ISR_FAST_INT)
#pragma interrupt fast
#elif defined(GPIO_ISR_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void GPIO_ISR(void)
{
  PESL(Bits1_DEVICE, GPIO_CLEAR_INT_PENDING, (1 << 7));
  ISRnum++;
}
#if defined(GPIO_ISR_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
