/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Init_GPIO
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 11:46, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Init_GPIO */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Bits1.h"
#include "Bit2.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define Bits1_Pin6_Mask (1 << 6)
#define Bits1_Pin7_Mask (1 << 7)
#define Bits1_Mask (Bits1_Pin6_Mask | Bits1_Pin7_Mask)
#define Bit2_Pin5_Mask (1 << 5)

word ISRnum = 0;

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Init_GPIO test");
  TEST1_testComment(&testRec, "Pins GPIOA7_ANA7 and GPIOC5_DACO_XB_IN7 should be interconnected!");
  Cpu_Delay100US(1000);

  TEST1_testComment(&testRec, "Bits1 - input; Bit2 - output, initial level low");
  PESL(Bit2_DEVICE, GPIO_SETAS_OUTPUT, Bit2_Pin5_Mask);
  Cpu_Delay100US(10);
  if ((PESL(Bits1_DEVICE, GPIO_READ_DATA, NULL) & Bits1_Pin7_Mask))
    TEST1_testFailed(&testRec, "Bits1 read high level");
  else  
    TEST1_testComment(&testRec, "Bits1 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - input; Bit2 - output, level high");
  PESL(Bit2_DEVICE, GPIO_SET_PIN, Bit2_Pin5_Mask);
  Cpu_Delay100US(10);
  if (!(PESL(Bits1_DEVICE, GPIO_READ_DATA, NULL) & Bits1_Pin7_Mask))
    TEST1_testFailed(&testRec, "Bits1 read low level");
  else  
    TEST1_testComment(&testRec, "Bits1 read high level");
  
  TEST1_testComment(&testRec, "Bits1 - input; Bit2 - output, level low");
  PESL(Bit2_DEVICE, GPIO_CLEAR_PIN, Bit2_Pin5_Mask);
  Cpu_Delay100US(10);
  if ((PESL(Bits1_DEVICE, GPIO_READ_DATA, NULL) & Bits1_Pin7_Mask))
    TEST1_testFailed(&testRec, "Bits1 read high level");
  else  
    TEST1_testComment(&testRec, "Bits1 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - output, initial level low; Bit2 - input");
  PESL(Bit2_DEVICE, GPIO_SETAS_INPUT, Bit2_Pin5_Mask);
  PESL(Bits1_DEVICE, GPIO_SETAS_OUTPUT, Bits1_Mask);
  PESL(Bits1_DEVICE, GPIO_SET_PIN, Bits1_Pin7_Mask);
  Cpu_Delay100US(10);
  if (!(PESL(Bit2_DEVICE, GPIO_READ_DATA, NULL) & Bit2_Pin5_Mask))
    TEST1_testFailed(&testRec, "Bit2 read high level");
  else  
    TEST1_testComment(&testRec, "Bit2 read low level");
  
  TEST1_testComment(&testRec, "Bits1 - output, level high; Bit2 - input");
  PESL(Bits1_DEVICE, GPIO_TOGGLE_PIN, Bits1_Pin7_Mask);
  Cpu_Delay100US(10);
  if ((PESL(Bit2_DEVICE, GPIO_READ_DATA, NULL) & Bit2_Pin5_Mask))
    TEST1_testFailed(&testRec, "Bit2 read low level");
  else  
    TEST1_testComment(&testRec, "Bit2 read high level");

  TEST1_testComment(&testRec, "Bits1 - output, level high; Bit2 - input");
  PESL(Bits1_DEVICE, GPIO_TOGGLE_PIN, Bits1_Pin7_Mask);
  Cpu_Delay100US(10);
  if (!(PESL(Bit2_DEVICE, GPIO_READ_DATA, NULL) & Bit2_Pin5_Mask))
    TEST1_testFailed(&testRec, "Bit2 read low level");
  else  
    TEST1_testComment(&testRec, "Bit2 read high level");
  
  TEST1_testComment(&testRec, "Bits1 - output, low; Bit2 - input");
  PESL(Bits1_DEVICE, GPIO_CLEAR_PIN, Bits1_Pin7_Mask);
  Cpu_Delay100US(100);
  Cpu_Delay100US(10);
  if ((PESL(Bit2_DEVICE, GPIO_READ_DATA, NULL) & Bit2_Pin5_Mask))
    TEST1_testFailed(&testRec, "Bit2 read high level");
  else  
    TEST1_testComment(&testRec, "Bit2 read low level");
  
  if (ISRnum == 3) {
    TEST1_testComment(&testRec, "ISR test OK.");
  }
  else {
    TEST1_testFailed(&testRec, "ISR test.");
  }


  TEST1_testEnd(&testRec);

}
/* END demo_Init_GPIO */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
