/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cpu.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : MC56F84789VLL
**     Version     : Component 01.066, Driver 01.00, CPU db: 3.50.001
**     Datasheet   : MC56F847XXRM Rev.0RC 10/201
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 11:57, # CodeGen: 44
**     Abstract    :
**
**     Settings    :
**
**     Contents    :
**         EnableInt   - void Cpu_EnableInt(void);
**         DisableInt  - void Cpu_DisableInt(void);
**         SetWaitMode - void Cpu_SetWaitMode(void);
**         SetStopMode - void Cpu_SetStopMode(void);
**         Delay100US  - asm void Cpu_Delay100US(word us100);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cpu. */
#include "Timer.h"
#include "Cap1.h"
#include "Bit1.h"
#include "TEST1.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


/* Global variables */
volatile word SR_lock = 0U;            /* Lock */
volatile word SR_reg;                  /* Current value of the SR register */
/*
** ===================================================================
**     Method      :  Cpu_Interrupt0 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt0(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_HW_RESET" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt1 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt1(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_COP_RESET" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt2 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt2(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_ILLEGAL_OP" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt3 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt3(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_SWI3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt4 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt4(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_OVERFLOW" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt5 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt5(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_MISALIGNED" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt6 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt6(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_STPCNT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt7 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt7(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_BKPT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt8 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt8(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TRBUF" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt9 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt9(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TX_REG" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt10 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt10(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_RX_REG" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt11 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt11(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_BUS_ERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt12 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt12(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_PLAT_3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt13 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt13(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_PLAT_2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt14 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt14(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_PLAT_1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt15 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt15(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_SWI2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt16 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt16(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_SWI1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt17 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt17(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_SWI0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt18 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt18(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_XBARA" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt19 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt19(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_LVI1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt20 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt20(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_OCCS" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt21 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt21(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRB_3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt22 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt22(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRB_2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt23 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt23(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRB_1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt24 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt24(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRB_0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt25 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt25(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRA_3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt26 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt26(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRA_2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt27 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt27(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TMRA_1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt29 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt29(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_ADC12_CC1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt30 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt30(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_ADC12_CC0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt31 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt31(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_ADC12_ERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt32 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt32(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_ADC16" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt33 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt33(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_DMA3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt34 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt34(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_DMA2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt35 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt35(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_DMA1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt36 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt36(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_DMA0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt37 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt37(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_MB_OR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt38 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt38(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_BUS_OFF" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt39 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt39(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_ERROR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt40 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt40(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_TX_WARN" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt41 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt41(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_RX_WARN" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt42 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt42(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_WAKEUP" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt43 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt43(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI2_RERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt44 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt44(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI2_RCV" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt45 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt45(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI2_TIDLE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt46 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt46(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI2_TDRE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt47 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt47(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI1_RERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt48 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt48(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI1_RCV" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt49 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt49(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI1_TIDLE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt50 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt50(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI1_TDRE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt51 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt51(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI0_RERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt52 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt52(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI0_RCV" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt53 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt53(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI0_TIDLE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt54 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt54(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSCI0_TDRE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt55 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt55(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSPI2_XMIT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt56 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt56(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSPI2_RCV" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt57 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt57(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSPI1_XMIT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt58 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt58(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSPI1_RCV" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt59 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt59(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSPI0_XMIT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt60 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt60(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_QSPI0_RCV" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt61 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt61(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_IIC1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt62 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt62(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_IIC0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt63 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt63(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_FAULT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt64 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt64(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_RERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt65 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt65(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_RELOAD3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt66 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt66(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CAP3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt67 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt67(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CMP3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt68 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt68(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_RELOAD2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt69 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt69(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CAP2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt70 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt70(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CMP2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt71 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt71(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_RELOAD1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt72 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt72(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CAP1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt73 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt73(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CMP1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt74 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt74(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_RELOAD0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt75 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt75(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CAP0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt76 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt76(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMB_CMP0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt77 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt77(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_FAULT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt78 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt78(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_RERR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt79 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt79(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_RELOAD3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt80 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt80(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_CAP" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt81 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt81(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_CMP3" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt82 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt82(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_RELOAD2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt83 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt83(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_CMP2" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt84 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt84(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_RELOAD1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt85 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt85(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_CMP1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt86 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt86(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_RELOAD0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt87 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt87(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_eFlexPWMA_CMP0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt88 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt88(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_FTFL_RDCOL" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt89 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt89(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_FTFL_CC" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt90 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt90(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_CMPD" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt91 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt91(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_CMPC" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt92 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt92(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_CMPB" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt93 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt93(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_CMPA" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt94 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt94(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_PIT1_ROLLOVR" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt96 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt96(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_PDB1" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt97 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt97(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_PDB0" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt98 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt98(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_INDEX" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt99 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt99(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_HOME_DOG" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt100 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt100(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_COMPARE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt101 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt101(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOG" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt102 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt102(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOF" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt103 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt103(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOE" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt104 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt104(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOD" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt105 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt105(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOC" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt106 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt106(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOB" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt107 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt107(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_GPIOA" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt108 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt108(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_COP_INT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt109 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt109(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_EWM_INT" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Interrupt110 (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt110(void)
{
  asm(DEBUGHLT);                       /* Interrupt "ivINT_SWILP" - Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Delay100US (component MC56F84789VLL)
**
**     Description :
**         This method realizes software delay. The length of delay
**         is at least 100 microsecond multiply input parameter
**         [us100]. As the delay implementation is not based on real
**         clock, the delay time may be increased by interrupt
**         service routines processed during the delay. Adding read
**         wait states for external program memory can cause delay
**         extension as well. The method is independent on selected
**         speed mode.
**     Parameters  :
**         NAME            - DESCRIPTION
**         us100           - Number of 100 us delay repetitions.
**     Returns     : Nothing
** ===================================================================
*/
/*lint -save  -e586 Disable MISRA rule (2.1) checking. Method is implemented using assembler. */
asm void Cpu_Delay100US(word us100)
{
  /* Total irremovable overhead: about 16 cycles */
  /* move.w: 2 cycles overhead (load parameter into register) */
  /* jsr:    5 cycles overhead (jump to subroutine) */
  /* rts:    8 cycles overhead (return from subroutine) */
  /* nop:    1 cycles overhead (aditional nops) */

  loop:
  /* 100 us delay block begin */
  /*
   * Delay
   *   - requested                  : 100 us @ 200MHz,
   *   - possible                   : 20000 c, 100000 ns
   *   - without removable overhead : 19994 c, 99970 ns
   */
  adda #2, SP                          /* (1 c: 5 ns) move SP forward */
  move.l A10, X:(SP)                   /* (2 c: 10 ns) push A */
  move.w #0x2705, A                    /* (2 c: 10 ns) number of iterations */
  do A, label0                         /* (8 c: 40 ns) repeat 9989x nop */
    nop                                /* (1 c: 5 ns) wait for 1 c */
  label0:
  move.l X:(SP), A                     /* (2 c: 10 ns) pop A */
  suba #2, SP                          /* (1 c: 5 ns) move SP back */
  /* 100 us delay block end */
  dec.w Y0                             /* us100 parameter is passed via Y0 register */
  jne loop                             /* next loop */
  nop                                  /* avoid pipeline conflicts */
  rts                                  /* return from subroutine */
}
/*lint -restore Enable MISRA rule (2.1) checking. */

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (component MC56F84789VLL)
**
**     Description :
**         Disables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (component MC56F84789VLL)
**
**     Description :
**         Enables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetStopMode (component MC56F84789VLL)
**
**     Description :
**         Sets low power mode - Stop mode.
**         For more information about the stop mode see this CPU
**         documentation.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetStopMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetWaitMode (component MC56F84789VLL)
**
**     Description :
**         Sets low power mode - Wait mode.
**         For more information about the wait mode see this CPU
**         documentation.
**         Release from wait mode: Reset or interrupt
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetWaitMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (component MC56F84789VLL)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void init_56800_(void);         /* Forward declaration of external startup function declared in startup file */

/*** !!! Here you can place your own code using property "User data declarations" on the build options tab. !!! ***/

void _EntryPoint(void)
{
  #pragma constarray off

  /*** !!! Here you can place your own code before PE initialization using property "User code before PE initialization" on the build options tab. !!! ***/

  /*** ### MC56F84789VLL "Cpu" init code ... ***/

  /*** PE initialization code after reset ***/

  /* Disable watchdog after reset based on the setting of the "Watchdog" property in CPU component */
  /* COP_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,PSS=3,INTEN=0,CLKSEL=0,CLOREN=0,CSEN=0,CWEN=0,CEN=0,CWP=0 */
  setReg16(COP_CTRL, 0x0300U);          

  /* System clock initialization */
  setRegBitGroup(OCCS_OSCTL1, FREQ_TRIM8M, ((*(word *)0xE42C) & 0x03FFU)); /* Trim the 8MHz internal relaxation oscillator, frequency trim value */
  clrReg16Bit(OCCS_OSCTL1, ROPD);      /* Enable internal 8MHz oscillator */
  setReg16Bit(OCCS_OSCTL1, CLK_MODE);  /* Select an external clock bypass mode */
  setRegBitGroup(OCCS_CTRL, PRECS, 0U); /* Select an internal 8MHz clock source for the CPU core */
  clrSetReg16Bits(OCCS_CTRL, OCCS_CTRL_PLLPD_MASK, OCCS_CTRL_LCKON_MASK); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_DIVBY: LORTP=2,COD=0,??=0,??=0,PLLDB=0x31 */
  setReg16(OCCS_DIVBY, 0x2031U);       /* Set the clock prescalers */ 
  while(!getRegBit(OCCS_STAT, LCK0)){} /* Wait for PLL lock */
  setReg16Bits(OCCS_CTRL, OCCS_CTRL_ZSRC_MASK); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_PROT: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,FRQEP=0,OSCEP=0,PLLEP=0 */
  setReg16(OCCS_PROT, 0x00U);          /* Set the OCCS protection register */ 
  /*** End of PE initialization code after reset ***/

  /*** !!! Here you can place your own code after PE initialization using property "User code after PE initialization" on the build options tab. !!! ***/

  asm(JMP init_56800_);                /* Jump to C startup code */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (component MC56F84789VLL)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
      /* Initialization of the SIM module */
  /* SIM_MISC0: PIT_MSTR=0 */
  clrReg16Bits(SIM_MISC0, 0x01U);       
  /* SIM_CTRL: RST_FILT=0,DMAEbl=3,OnceEbl=0,STOP_disable=0,WAIT_disable=0 */
  clrSetReg16Bits(SIM_CTRL, 0x052FU, 0xC0U); 
  /* SIM_PWR: SR12STDBY=0,SR27PDN=0,SR27STDBY=0,LRSTDBY=0 */
  clrReg16Bits(SIM_PWR, 0xFFU);         
  /* SIM_CLKOUT: CLKODIV=0,CLKDIS1=1,CLKOSEL1=0,CLKDIS0=1,CLKOSEL0=0 */
  clrSetReg16Bits(SIM_CLKOUT, 0xE387U, 0x1020U); 
  /* SIM_PCE0: TA0=1,TA1=0,TA2=0,TA3=0,TB0=0,TB1=0,TB2=0,TB3=0,GPIOA=0,GPIOB=0,GPIOC=1,GPIOD=0,GPIOE=0,GPIOF=0,GPIOG=0 */
  clrSetReg16Bits(SIM_PCE0, 0x7F6FU, 0x8010U); 
  /* SIM_PCE1: DAC=0,SCI0=0,SCI1=0,SCI2=0,QSPI0=0,QSPI1=0,QSPI2=0,IIC0=0,IIC1=0,FLEXCAN=0 */
  clrReg16Bits(SIM_PCE1, 0x3FE1U);      
  /* SIM_PCE2: CMPA=0,CMPB=0,CMPC=0,CMPD=0,SARADC=0,CYCADC=0,CRC=0,QDC=0,PIT0=1,PIT1=0,PDB0=0,PDB1=0 */
  clrSetReg16Bits(SIM_PCE2, 0x1FB7U, 0x08U); 
  /* SIM_PCE3: PWMACH0=0,PWMACH1=0,PWMACH2=0,PWMACH3=0,PWMBCH0=0,PWMBCH1=0,PWMBCH2=0,PWMBCH3=0 */
  clrReg16Bits(SIM_PCE3, 0xFFU);        
  /* SIM_SD0: TA0=0,TA1=0,TA2=0,TA3=0,TB0=0,TB1=0,TB2=0,TB3=0,GPIOA=0,GPIOB=0,GPIOC=0,GPIOD=0,GPIOE=0,GPIOF=0,GPIOG=0 */
  clrReg16Bits(SIM_SD0, 0xFF7FU);       
  /* SIM_SD1: DAC=0,SCI0=0,SCI1=0,SCI2=0,QSPI0=0,QSPI1=0,QSPI2=0,IIC0=0,IIC1=0,FLEXCAN=0 */
  clrReg16Bits(SIM_SD1, 0x3FE1U);       
  /* SIM_SD2: CMPA=0,CMPB=0,CMPC=0,CMPD=0,SARADC=0,CYCADC=0,CRC=0,QDC=0,PIT0=0,PIT1=0,PDB0=0,PDB1=0 */
  clrReg16Bits(SIM_SD2, 0x1FBFU);       
  /* SIM_SD3: PWMACH0=0,PWMACH1=0,PWMACH2=0,PWMACH3=0,PWMBCH0=0,PWMBCH1=0,PWMBCH2=0,PWMBCH3=0 */
  clrReg16Bits(SIM_SD3, 0xFFU);         
  /* SIM_PROT: PMODE=0,GDP=0,PCEP=0,GIPSP=0 */
  clrReg16Bits(SIM_PROT, 0xFFU);        
  /* SIM_PCR: ??=0,??=0,SCI0_CR=1,SCI1_CR=1,SCI2_CR=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg16(SIM_PCR, 0x3800U);          /* Set the QSCI0; QSCI1; QSCI2 module clock rates */ 
      /* Initialization of the MCM module */
  /* MCM_UPRAMBAR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,RBA=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg32(MCM_UPRAMBAR, 0x00UL);       
  /* MCM_UFLASHBAR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,FBA=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg32(MCM_UFLASHBAR, 0x00UL);      
  /* MCM_CPCR: XBARARB=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IBDIS=0,SRDIS=0,RCDIS=0,INSDIS=0,SOCCR=0 */
  setReg32(MCM_CPCR, 0x00UL);           
  /* MCM_RPCR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,RL=0,RPE=0 */
  setReg32(MCM_RPCR, 0x00UL);           
      /* Initialization of the GPIOA module */
  /* GPIOA_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOA_DRIVE, 0x0FFFU);   
  /* GPIOA_SRE: SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOA_SRE, 0x0FFFU);     
      /* Initialization of the GPIOB module */
  /* GPIOB_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOB_DRIVE, 0x0FFFU);   
  /* GPIOB_SRE: SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOB_SRE, 0x0FFFU);     
      /* Initialization of the GPIOC module */
  /* GPIOC_DRIVE: DRIVE15=0,DRIVE14=0,DRIVE13=0,DRIVE12=0,DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIOC_DRIVE, 0x00U);         
  /* GPIOC_SRE: SRE15=1,SRE14=1,SRE13=1,SRE12=1,SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16(GPIOC_SRE, 0xFFFFU);         
      /* Initialization of the GPIOD module */
  /* GPIOD_DRIVE: DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOD_DRIVE, 0xFFU);     
  /* GPIOD_SRE: SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOD_SRE, 0xFFU);       
      /* Initialization of the GPIOE module */
  /* GPIOE_DRIVE: DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOE_DRIVE, 0x03FFU);   
  /* GPIOE_SRE: SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOE_SRE, 0x03FFU);     
      /* Initialization of the GPIOF module */
  /* GPIOF_DRIVE: DRIVE15=0,DRIVE14=0,DRIVE13=0,DRIVE12=0,DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIOF_DRIVE, 0x00U);         
  /* GPIOF_SRE: SRE15=1,SRE14=1,SRE13=1,SRE12=1,SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16(GPIOF_SRE, 0xFFFFU);         
      /* Initialization of the GPIOG module */
  /* GPIOG_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOG_DRIVE, 0x0FFFU);   
  /* GPIOG_SRE: SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOG_SRE, 0x0FFFU);     
/*lint -save  -e586 Disable MISRA rule (2.1) checking. Functionality is implemented using assembler. */
  /* Shadow registers initialization */
  asm {
    move.l #0, R0
    move.l #0, R1
    move.l #0, R2
    move.l #0, R3
    move.l #0, R4
    move.l #0, R5
    move.l #0, N
    moveu.w #65535, N3
    moveu.w #65535, M01
    nop
    nop
    swap shadows
    /* Reset the M01 register for linear addressing */
    moveu.w #65535,M01
  }
/*lint -restore Enable MISRA rule (2.1) checking. */
  /* Common initialization of the CPU registers */
  /* INTC_IPR10: PIT0_ROLLOVR=1 */
  clrSetReg16Bits(INTC_IPR10, 0x2000U, 0x1000U); 
  /* INTC_IPR2: TMRA_0=2 */
  clrSetReg16Bits(INTC_IPR2, 0x40U, 0x80U); 
  /* GPIOC_PER: PE4=0,PE3=1 */
  clrSetReg16Bits(GPIOC_PER, 0x10U, 0x08U); 
  /* SIM_GPSCL: C3=0 */
  clrReg16Bits(SIM_GPSCL, 0xC0U);       
  /* SIM_IPS0: TA0=0 */
  clrReg16Bits(SIM_IPS0, 0x0100U);      
  /* GPIOC_PUR: PU3=0 */
  clrReg16Bits(GPIOC_PUR, 0x08U);       
  /* GPIOC_PUS: PUS3=0 */
  clrReg16Bits(GPIOC_PUS, 0x08U);       
  /* TMRA_0_ENBL: ENBL&=~1 */
  clrReg16Bits(TMRA_0_ENBL, 0x01U);     
  /* GPIOC_IENR: IEN4=0 */
  clrReg16Bits(GPIOC_IENR, 0x10U);      
  /* GPIOC_IAR: IA4=0 */
  clrReg16Bits(GPIOC_IAR, 0x10U);       
  /* GPIOC_IESR: IES4=1 */
  setReg16Bits(GPIOC_IESR, 0x10U);      
  /* GPIOC_PPMODE: PPMODE4=1 */
  setReg16Bits(GPIOC_PPMODE, 0x10U);    
  /* GPIOC_DR: D4=0 */
  clrReg16Bits(GPIOC_DR, 0x10U);        
  /* GPIOC_DDR: DD4=1 */
  setReg16Bits(GPIOC_DDR, 0x10U);       
  /* GPIOD_PER: PE4=1 */
  setReg16Bits(GPIOD_PER, 0x10U);       
  /* Initialization of the SIM module */
  /* ### Init_PIT "Timer" init code ... */
  Timer_Init();
  /* ### Timer capture encapsulation "Cap1" init code ... */
  Cap1_Init();
  /* Common peripheral initialization - ENABLE */
  /* TMRA_0_ENBL: ENBL|=1 */
  setReg16Bits(TMRA_0_ENBL, 0x01U);     
  __EI(0);                             /* Enable interrupts of the selected priority level */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
