/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Init_SCI
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 13:46, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Init_SCI */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SCI1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define LOOP_LENGTH 5

byte LoopTxBuffer;
byte LoopRxBuffer;
volatile byte i, err;
volatile byte TxCharInt = 0;
volatile byte RxCharInt = 0;

static byte SendChar(byte Chr)
{
  if (!PESL(QSCI0, SCI_GET_TX_EMPTY, NULL))  /* Is the transmitter empty? */
    return ERR_TXFULL;                       /* If yes then error */
  PESL(QSCI0, SCI_WRITE_DATA, Chr);
  PESL(QSCI0, SCI_INT_ENABLE, SCI_TX_EMPTY); /* Enable TX idle interrupt */
  return ERR_OK;                             /* OK */
}

static byte GetCharsInRxBuf(void)
{
  return (byte)((RxCharInt != 0)? 1 : 0);    /* Return number of chars in receive buffer */
}

static byte RecvChar(byte *Chr)
{
  register byte Result = ERR_OK;       /* Return error code */
  register word StatReg = PESL(QSCI0, SCI_GET_STATUS_REG, NULL); /* Read status register */

  PESL(QSCI0, SCI_CLEAR_STATUS_REG, NULL); /* Reset error request flags */
  if (StatReg & (QSCI0_STAT_OR_MASK|QSCI0_STAT_NF_MASK|QSCI0_STAT_FE_MASK|QSCI0_STAT_PF_MASK)) { /* Is any error set? */
    Result = ERR_COMMON;               /* If yes then set common error value */
  } else if (!(StatReg & QSCI0_STAT_RDRF_MASK)) { /* Is the reciver empty and no error is set? */
    return ERR_RXEMPTY;                /* If yes then error */
  }
  *Chr = (byte)PESL(QSCI0, SCI_READ_DATA, NULL); /* Read data from the receiver */
  return Result;                       /* Return error code */
}

void main(void)
{
  test_sRec testRec;


  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Init_SCI test");
  //
  for (i=0;i<LOOP_LENGTH;i++) {
    LoopTxBuffer= 0;
    LoopRxBuffer= 0xff;
    //
    TEST1_testComment(&testRec, "Transmitting one character ...");
    err = SendChar(LoopTxBuffer);
    //
    while (GetCharsInRxBuf() == 0) {}
    //
    if (err == ERR_OK)
      TEST1_testComment(&testRec, "PASSED");
    else
      TEST1_testFailed(&testRec, "Transmitting one character failed");
    //
    TEST1_testComment(&testRec, "Receiving one character ...");
    if (err != ERR_OK)
      TEST1_testFailed(&testRec, "Receiving one character failed");
    else if (LoopRxBuffer != LoopTxBuffer)
      TEST1_testFailed(&testRec, "Comparing received/sent data failed");
    else
      TEST1_testComment(&testRec, "PASSED");
  }
  //
  TEST1_testComment(&testRec, "Testing TxEmpty interrupt ...");
  if (TxCharInt != LOOP_LENGTH) {
    TEST1_testFailed(&testRec, "Testing TxEmpty interrupt failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }
  TEST1_testComment(&testRec, "Testing RxFull interrupt ...");
  if (RxCharInt != LOOP_LENGTH) {
    TEST1_testFailed(&testRec, "Testing RxFull interrupt failed");
  } else {
    TEST1_testComment(&testRec, "PASSED");
  }
  //
  TEST1_testEnd(&testRec);
  //
}

/*
** ===================================================================
**     Interrupt handler : AS1_RxFull
**
**     Description :
**         User interrupt service routine.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(AS1_RxFull_FAST_INT)
#pragma interrupt fast
#elif defined(AS1_RxFull_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void AS1_RxFull(void)
{
  PESL(QSCI0, SCI_GET_STATUS_REG, NULL); /* Read status register */
  err = RecvChar(&LoopRxBuffer);
  RxCharInt++;
}
#if defined(AS1_RxFull_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif

/*
** ===================================================================
**     Interrupt handler : AS1_TxIdle
**
**     Description :
**         User interrupt service routine.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#if defined(AS1_TxEmpty_FAST_INT)
#pragma interrupt fast
#elif defined(AS1_TxEmpty_VECT_TABLE_ISR_FAST_INT)
#pragma define_section interrupt_fast "interrupt_fast.text"  RX
#pragma section interrupt_fast begin
#pragma interrupt fast
#else
#pragma interrupt
#endif
void AS1_TxEmpty(void)
{
  PESL(QSCI0, SCI_INT_DISABLE, SCI_TX_EMPTY);  /* Disable TX idle interrupt */
  TxCharInt++;
}
#if defined(AS1_TxEmpty_VECT_TABLE_ISR_FAST_INT)
#pragma section interrupt_fast end
#endif

/* END demo_Init_SCI */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
