/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : Init_SPI
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-23, 13:59, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_Init_SPI */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SPI1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define BLOCKSIZE 17

word ISR_Rx_Num = 0;
word ISR_Tx_Num = 0;
byte DataOut[] = " Message: Master ";
byte DataIn[BLOCKSIZE];
byte i;
bool Error;

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Init_SPI test");
  TEST1_testComment(&testRec, "Please interconnect the pins GPIOC8_MISO_RXD0 and GPIOC10_MOSI_XB_IN5_MISO.");

  Error = FALSE;
  for (i = 0; i < BLOCKSIZE; i++) {
    PESL(SPI1_DEVICE, SPI_INT_ENABLE, SPI_RX_FULL | SPI_TX_EMPTY);
    
    /* SendChar */
    PESL(SPI1_DEVICE, SPI_WRITE_DATA, DataOut[i]);
    while (!PESL(SPI1_DEVICE, SPI_GET_RX_FULL, NULL)) {}

    /* RecvChar */
    DataIn[i] = (byte)PESL(SPI1_DEVICE, SPI_READ_DATA, NULL);
    if (DataOut[i] != DataIn[i]) {
      Error = TRUE;
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "Transmitting and receiving characters test OK.");
  else  
    TEST1_testFailed(&testRec, "Transmitting and receiving failed.");
 
  if ((ISR_Rx_Num != 17) || (ISR_Tx_Num != 17)) {
    TEST1_testFailed(&testRec, "ISRs test.");
  }
  else {
    TEST1_testComment(&testRec, "ISRs test OK.");
  }
 
  TEST1_testEnd(&testRec);

}
/* END demo_Init_SPI */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
