/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.14
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-06, 18:28, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "eFPWM1.h"
#include "Cap1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"


UInt8 compareInterrupts = 0;
byte edge = 0;
UInt16 Ticks[ 6 ];

void main(void)
{
  /* Write your local variable definition here */
  test_sRec testRec;
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
  PESL(PWMA, PWM_WRITE_MASTER_CONTROL_REG, PESL(PWMA, PWM_READ_MASTER_CONTROL_REG, NULL) & ~PWM_MCTRL_RUN0 );
  Cap1_Disable();
  TEST1_testStart( &testRec , "eFlexPWM" );
  TEST1_testComment( &testRec , "Please interconnect pins GPIOE1/PWMA_0A and GPIOF1/CLK01/XB_IN7/CMPD_O" );
  
  TEST1_testComment( &testRec , "PWM Will generate 3 pulses" );
  
  Cap1_Enable();
  PESL(PWMA, PWM_WRITE_MASTER_CONTROL_REG, PESL(PWMA, PWM_READ_MASTER_CONTROL_REG, NULL) | PWM_MCTRL_RUN0 );
  PESL(PWMA, PWM_SM0_COMPARE_0_INTERRUPT, PWM_ENABLE );
  PESL(PWMA, PWM_SM0_RELOAD_INTERRUPT, PWM_ENABLE );
  
  
  while( compareInterrupts < 6 ) {}
  
  Cap1_Disable();
 
  PESL(PWMA, PWM_WRITE_MASTER_CONTROL_REG, PESL(PWMA, PWM_READ_MASTER_CONTROL_REG, NULL) & ~PWM_MCTRL_RUN0 );
  PESL(PWMA, PWM_SM0_COMPARE_0_INTERRUPT, PWM_DISABLE );
  PESL(PWMA, PWM_SM0_RELOAD_INTERRUPT, PWM_DISABLE );
  
  TEST1_testComment( &testRec , "Testing OnCompare events" );
  
  if( compareInterrupts == 6 ) {
    TEST1_testComment( &testRec , "count OK" );  
  } else {
    TEST1_testFailed( &testRec , "count");
  }  
  
  TEST1_testComment( &testRec , "Testing edge 1 timing with 1% error margin: " );
  if( Ticks[ 0 ] > 4140 - 20 && Ticks[ 0 ] < 4140 + 20  ) {
	  TEST1_testComment( &testRec , "Number of ticks OK" );
  } else {
	  TEST1_testFailed( &testRec , "Number of ticks");
  }
  
  TEST1_testComment( &testRec , "Testing edge 2 timing with 1% error margin: " );
  if( Ticks[ 1 ] > 8140 - 40 && Ticks[ 1 ] < 8140 + 40  ) {
	  TEST1_testComment( &testRec , "Number of ticks OK" );
  } else {
	  TEST1_testFailed( &testRec , "Number of ticks");
  }
  
  TEST1_testComment( &testRec , "Testing edge 3 timing with 1% error margin: " );
  if( Ticks[ 2 ] > 12140 - 60 && Ticks[ 2 ] < 12140 + 60  ) {
	  TEST1_testComment( &testRec , "Number of ticks OK" );
  } else {
	  TEST1_testFailed( &testRec , "Number of ticks");
  }
  
  TEST1_testComment( &testRec , "Testing edge 4 timing with 1% error margin: " );
  if( Ticks[ 3 ] > 16140 - 80 && Ticks[ 3 ] < 16140 + 80  ) {
	  TEST1_testComment( &testRec , "Number of ticks OK" );
  } else {
	  TEST1_testFailed( &testRec , "Number of ticks");
  }
  
  TEST1_testComment( &testRec , "Testing edge 5 timing with 1% error margin: " );
  if( Ticks[ 4 ] > 20140 - 100 && Ticks[ 4 ] < 20140 + 100  ) {
	  TEST1_testComment( &testRec , "Number of ticks OK" );
  } else {
	  TEST1_testFailed( &testRec , "Number of ticks");
  }
  
  TEST1_testComment( &testRec , "Testing edge 6 timing with 1% error margin: " );
  if( Ticks[ 5 ] > 24140 - 120 && Ticks[ 5 ] < 24140 + 120  ) {
	  TEST1_testComment( &testRec , "Number of ticks OK" );
  } else {
	  TEST1_testFailed( &testRec , "Number of ticks");
  }
  
  TEST1_testEnd( &testRec );

  for(;;) {}
}

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 0.00.00 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
